# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AssetEgressEndpoint',
    'AssetTag',
    'ChannelHlsIngest',
    'ChannelIngestEndpoint',
    'ChannelLogConfiguration',
    'ChannelTag',
    'OriginEndpointAuthorization',
    'OriginEndpointCmafEncryption',
    'OriginEndpointCmafPackage',
    'OriginEndpointDashEncryption',
    'OriginEndpointDashPackage',
    'OriginEndpointHlsEncryption',
    'OriginEndpointHlsManifest',
    'OriginEndpointHlsPackage',
    'OriginEndpointMssEncryption',
    'OriginEndpointMssPackage',
    'OriginEndpointSpekeKeyProvider',
    'OriginEndpointStreamSelection',
    'OriginEndpointTag',
    'PackagingConfigurationCmafEncryption',
    'PackagingConfigurationCmafPackage',
    'PackagingConfigurationDashEncryption',
    'PackagingConfigurationDashManifest',
    'PackagingConfigurationDashPackage',
    'PackagingConfigurationHlsEncryption',
    'PackagingConfigurationHlsManifest',
    'PackagingConfigurationHlsPackage',
    'PackagingConfigurationMssEncryption',
    'PackagingConfigurationMssManifest',
    'PackagingConfigurationMssPackage',
    'PackagingConfigurationSpekeKeyProvider',
    'PackagingConfigurationStreamSelection',
    'PackagingConfigurationTag',
    'PackagingGroupAuthorization',
    'PackagingGroupLogConfiguration',
    'PackagingGroupTag',
]

@pulumi.output_type
class AssetEgressEndpoint(dict):
    """
    The endpoint URL used to access an Asset using one PackagingConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packagingConfigurationId":
            suggest = "packaging_configuration_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssetEgressEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssetEgressEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssetEgressEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 packaging_configuration_id: str,
                 url: str):
        """
        The endpoint URL used to access an Asset using one PackagingConfiguration.
        :param str packaging_configuration_id: The ID of the PackagingConfiguration being applied to the Asset.
        :param str url: The URL of the parent manifest for the repackaged Asset.
        """
        pulumi.set(__self__, "packaging_configuration_id", packaging_configuration_id)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="packagingConfigurationId")
    def packaging_configuration_id(self) -> str:
        """
        The ID of the PackagingConfiguration being applied to the Asset.
        """
        return pulumi.get(self, "packaging_configuration_id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL of the parent manifest for the repackaged Asset.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class AssetTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ChannelHlsIngest(dict):
    """
    An HTTP Live Streaming (HLS) ingest resource configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingestEndpoints":
            suggest = "ingest_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelHlsIngest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelHlsIngest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelHlsIngest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingest_endpoints: Optional[Sequence['outputs.ChannelIngestEndpoint']] = None):
        """
        An HTTP Live Streaming (HLS) ingest resource configuration.
        :param Sequence['ChannelIngestEndpoint'] ingest_endpoints: A list of endpoints to which the source stream should be sent.
        """
        if ingest_endpoints is not None:
            pulumi.set(__self__, "ingest_endpoints", ingest_endpoints)

    @property
    @pulumi.getter(name="ingestEndpoints")
    def ingest_endpoints(self) -> Optional[Sequence['outputs.ChannelIngestEndpoint']]:
        """
        A list of endpoints to which the source stream should be sent.
        """
        return pulumi.get(self, "ingest_endpoints")


@pulumi.output_type
class ChannelIngestEndpoint(dict):
    """
    An endpoint for ingesting source content for a Channel.
    """
    def __init__(__self__, *,
                 id: Optional[str] = None,
                 password: Optional[str] = None,
                 url: Optional[str] = None,
                 username: Optional[str] = None):
        """
        An endpoint for ingesting source content for a Channel.
        :param str id: The system generated unique identifier for the IngestEndpoint
        :param str password: The system generated password for ingest authentication.
        :param str url: The ingest URL to which the source stream should be sent.
        :param str username: The system generated username for ingest authentication.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The system generated unique identifier for the IngestEndpoint
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The system generated password for ingest authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The ingest URL to which the source stream should be sent.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The system generated username for ingest authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ChannelLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ChannelLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ChannelLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ChannelLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_name: Optional[str] = None):
        """
        :param str log_group_name: Sets a custom AWS CloudWatch log group name for access logs. If a log group name isn't specified, the defaults are used: /aws/MediaPackage/EgressAccessLogs for egress access logs and /aws/MediaPackage/IngressAccessLogs for ingress access logs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[str]:
        """
        Sets a custom AWS CloudWatch log group name for access logs. If a log group name isn't specified, the defaults are used: /aws/MediaPackage/EgressAccessLogs for egress access logs and /aws/MediaPackage/IngressAccessLogs for ingress access logs.
        """
        return pulumi.get(self, "log_group_name")


@pulumi.output_type
class ChannelTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class OriginEndpointAuthorization(dict):
    """
    CDN Authorization credentials
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cdnIdentifierSecret":
            suggest = "cdn_identifier_secret"
        elif key == "secretsRoleArn":
            suggest = "secrets_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cdn_identifier_secret: str,
                 secrets_role_arn: str):
        """
        CDN Authorization credentials
        :param str cdn_identifier_secret: The Amazon Resource Name (ARN) for the secret in Secrets Manager that your Content Distribution Network (CDN) uses for authorization to access your endpoint.
        :param str secrets_role_arn: The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        """
        pulumi.set(__self__, "cdn_identifier_secret", cdn_identifier_secret)
        pulumi.set(__self__, "secrets_role_arn", secrets_role_arn)

    @property
    @pulumi.getter(name="cdnIdentifierSecret")
    def cdn_identifier_secret(self) -> str:
        """
        The Amazon Resource Name (ARN) for the secret in Secrets Manager that your Content Distribution Network (CDN) uses for authorization to access your endpoint.
        """
        return pulumi.get(self, "cdn_identifier_secret")

    @property
    @pulumi.getter(name="secretsRoleArn")
    def secrets_role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        """
        return pulumi.get(self, "secrets_role_arn")


@pulumi.output_type
class OriginEndpointCmafEncryption(dict):
    """
    A Common Media Application Format (CMAF) encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spekeKeyProvider":
            suggest = "speke_key_provider"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "keyRotationIntervalSeconds":
            suggest = "key_rotation_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointCmafEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointCmafEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointCmafEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 speke_key_provider: 'outputs.OriginEndpointSpekeKeyProvider',
                 constant_initialization_vector: Optional[str] = None,
                 key_rotation_interval_seconds: Optional[int] = None):
        """
        A Common Media Application Format (CMAF) encryption configuration.
        :param str constant_initialization_vector: An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
        :param int key_rotation_interval_seconds: Time (in seconds) between each encryption key rotation.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if key_rotation_interval_seconds is not None:
            pulumi.set(__self__, "key_rotation_interval_seconds", key_rotation_interval_seconds)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> 'outputs.OriginEndpointSpekeKeyProvider':
        return pulumi.get(self, "speke_key_provider")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[str]:
        """
        An optional 128-bit, 16-byte hex value represented by a 32-character string, used in conjunction with the key for encrypting blocks. If you don't specify a value, then MediaPackage creates the constant initialization vector (IV).
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="keyRotationIntervalSeconds")
    def key_rotation_interval_seconds(self) -> Optional[int]:
        """
        Time (in seconds) between each encryption key rotation.
        """
        return pulumi.get(self, "key_rotation_interval_seconds")


@pulumi.output_type
class OriginEndpointCmafPackage(dict):
    """
    A Common Media Application Format (CMAF) packaging configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hlsManifests":
            suggest = "hls_manifests"
        elif key == "segmentDurationSeconds":
            suggest = "segment_duration_seconds"
        elif key == "segmentPrefix":
            suggest = "segment_prefix"
        elif key == "streamSelection":
            suggest = "stream_selection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointCmafPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointCmafPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointCmafPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption: Optional['outputs.OriginEndpointCmafEncryption'] = None,
                 hls_manifests: Optional[Sequence['outputs.OriginEndpointHlsManifest']] = None,
                 segment_duration_seconds: Optional[int] = None,
                 segment_prefix: Optional[str] = None,
                 stream_selection: Optional['outputs.OriginEndpointStreamSelection'] = None):
        """
        A Common Media Application Format (CMAF) packaging configuration.
        :param Sequence['OriginEndpointHlsManifest'] hls_manifests: A list of HLS manifest configurations
        :param int segment_duration_seconds: Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
        :param str segment_prefix: An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
        """
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if hls_manifests is not None:
            pulumi.set(__self__, "hls_manifests", hls_manifests)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if segment_prefix is not None:
            pulumi.set(__self__, "segment_prefix", segment_prefix)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.OriginEndpointCmafEncryption']:
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="hlsManifests")
    def hls_manifests(self) -> Optional[Sequence['outputs.OriginEndpointHlsManifest']]:
        """
        A list of HLS manifest configurations
        """
        return pulumi.get(self, "hls_manifests")

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[int]:
        """
        Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
        """
        return pulumi.get(self, "segment_duration_seconds")

    @property
    @pulumi.getter(name="segmentPrefix")
    def segment_prefix(self) -> Optional[str]:
        """
        An optional custom string that is prepended to the name of each segment. If not specified, it defaults to the ChannelId.
        """
        return pulumi.get(self, "segment_prefix")

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional['outputs.OriginEndpointStreamSelection']:
        return pulumi.get(self, "stream_selection")


@pulumi.output_type
class OriginEndpointDashEncryption(dict):
    """
    A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spekeKeyProvider":
            suggest = "speke_key_provider"
        elif key == "keyRotationIntervalSeconds":
            suggest = "key_rotation_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointDashEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointDashEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointDashEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 speke_key_provider: 'outputs.OriginEndpointSpekeKeyProvider',
                 key_rotation_interval_seconds: Optional[int] = None):
        """
        A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
        :param int key_rotation_interval_seconds: Time (in seconds) between each encryption key rotation.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if key_rotation_interval_seconds is not None:
            pulumi.set(__self__, "key_rotation_interval_seconds", key_rotation_interval_seconds)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> 'outputs.OriginEndpointSpekeKeyProvider':
        return pulumi.get(self, "speke_key_provider")

    @property
    @pulumi.getter(name="keyRotationIntervalSeconds")
    def key_rotation_interval_seconds(self) -> Optional[int]:
        """
        Time (in seconds) between each encryption key rotation.
        """
        return pulumi.get(self, "key_rotation_interval_seconds")


@pulumi.output_type
class OriginEndpointDashPackage(dict):
    """
    A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adTriggers":
            suggest = "ad_triggers"
        elif key == "adsOnDeliveryRestrictions":
            suggest = "ads_on_delivery_restrictions"
        elif key == "manifestLayout":
            suggest = "manifest_layout"
        elif key == "manifestWindowSeconds":
            suggest = "manifest_window_seconds"
        elif key == "minBufferTimeSeconds":
            suggest = "min_buffer_time_seconds"
        elif key == "minUpdatePeriodSeconds":
            suggest = "min_update_period_seconds"
        elif key == "periodTriggers":
            suggest = "period_triggers"
        elif key == "segmentDurationSeconds":
            suggest = "segment_duration_seconds"
        elif key == "segmentTemplateFormat":
            suggest = "segment_template_format"
        elif key == "streamSelection":
            suggest = "stream_selection"
        elif key == "suggestedPresentationDelaySeconds":
            suggest = "suggested_presentation_delay_seconds"
        elif key == "utcTiming":
            suggest = "utc_timing"
        elif key == "utcTimingUri":
            suggest = "utc_timing_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointDashPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointDashPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointDashPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_triggers: Optional[Sequence['OriginEndpointDashPackageAdTriggersItem']] = None,
                 ads_on_delivery_restrictions: Optional['OriginEndpointAdsOnDeliveryRestrictions'] = None,
                 encryption: Optional['outputs.OriginEndpointDashEncryption'] = None,
                 manifest_layout: Optional['OriginEndpointDashPackageManifestLayout'] = None,
                 manifest_window_seconds: Optional[int] = None,
                 min_buffer_time_seconds: Optional[int] = None,
                 min_update_period_seconds: Optional[int] = None,
                 period_triggers: Optional[Sequence['OriginEndpointDashPackagePeriodTriggersItem']] = None,
                 profile: Optional['OriginEndpointDashPackageProfile'] = None,
                 segment_duration_seconds: Optional[int] = None,
                 segment_template_format: Optional['OriginEndpointDashPackageSegmentTemplateFormat'] = None,
                 stream_selection: Optional['outputs.OriginEndpointStreamSelection'] = None,
                 suggested_presentation_delay_seconds: Optional[int] = None,
                 utc_timing: Optional['OriginEndpointDashPackageUtcTiming'] = None,
                 utc_timing_uri: Optional[str] = None):
        """
        A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        :param Sequence['OriginEndpointDashPackageAdTriggersItem'] ad_triggers: A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        :param 'OriginEndpointDashPackageManifestLayout' manifest_layout: Determines the position of some tags in the Media Presentation Description (MPD).  When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation.  When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        :param int manifest_window_seconds: Time window (in seconds) contained in each manifest.
        :param int min_buffer_time_seconds: Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        :param int min_update_period_seconds: Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD).
        :param Sequence['OriginEndpointDashPackagePeriodTriggersItem'] period_triggers: A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into more than one period. If the list contains "ADS", new periods will be created where the Channel source contains SCTE-35 ad markers.
        :param 'OriginEndpointDashPackageProfile' profile: The Dynamic Adaptive Streaming over HTTP (DASH) profile type.  When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        :param int segment_duration_seconds: Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
        :param 'OriginEndpointDashPackageSegmentTemplateFormat' segment_template_format: Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).  When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.  When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        :param int suggested_presentation_delay_seconds: Duration (in seconds) to delay live content before presentation.
        :param 'OriginEndpointDashPackageUtcTiming' utc_timing: Determines the type of UTCTiming included in the Media Presentation Description (MPD)
        :param str utc_timing_uri: Specifies the value attribute of the UTCTiming field when utcTiming is set to HTTP-ISO or HTTP-HEAD
        """
        if ad_triggers is not None:
            pulumi.set(__self__, "ad_triggers", ad_triggers)
        if ads_on_delivery_restrictions is not None:
            pulumi.set(__self__, "ads_on_delivery_restrictions", ads_on_delivery_restrictions)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if manifest_layout is not None:
            pulumi.set(__self__, "manifest_layout", manifest_layout)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if min_buffer_time_seconds is not None:
            pulumi.set(__self__, "min_buffer_time_seconds", min_buffer_time_seconds)
        if min_update_period_seconds is not None:
            pulumi.set(__self__, "min_update_period_seconds", min_update_period_seconds)
        if period_triggers is not None:
            pulumi.set(__self__, "period_triggers", period_triggers)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if segment_template_format is not None:
            pulumi.set(__self__, "segment_template_format", segment_template_format)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)
        if suggested_presentation_delay_seconds is not None:
            pulumi.set(__self__, "suggested_presentation_delay_seconds", suggested_presentation_delay_seconds)
        if utc_timing is not None:
            pulumi.set(__self__, "utc_timing", utc_timing)
        if utc_timing_uri is not None:
            pulumi.set(__self__, "utc_timing_uri", utc_timing_uri)

    @property
    @pulumi.getter(name="adTriggers")
    def ad_triggers(self) -> Optional[Sequence['OriginEndpointDashPackageAdTriggersItem']]:
        """
        A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        """
        return pulumi.get(self, "ad_triggers")

    @property
    @pulumi.getter(name="adsOnDeliveryRestrictions")
    def ads_on_delivery_restrictions(self) -> Optional['OriginEndpointAdsOnDeliveryRestrictions']:
        return pulumi.get(self, "ads_on_delivery_restrictions")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.OriginEndpointDashEncryption']:
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="manifestLayout")
    def manifest_layout(self) -> Optional['OriginEndpointDashPackageManifestLayout']:
        """
        Determines the position of some tags in the Media Presentation Description (MPD).  When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation.  When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        """
        return pulumi.get(self, "manifest_layout")

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[int]:
        """
        Time window (in seconds) contained in each manifest.
        """
        return pulumi.get(self, "manifest_window_seconds")

    @property
    @pulumi.getter(name="minBufferTimeSeconds")
    def min_buffer_time_seconds(self) -> Optional[int]:
        """
        Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        """
        return pulumi.get(self, "min_buffer_time_seconds")

    @property
    @pulumi.getter(name="minUpdatePeriodSeconds")
    def min_update_period_seconds(self) -> Optional[int]:
        """
        Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD).
        """
        return pulumi.get(self, "min_update_period_seconds")

    @property
    @pulumi.getter(name="periodTriggers")
    def period_triggers(self) -> Optional[Sequence['OriginEndpointDashPackagePeriodTriggersItem']]:
        """
        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into more than one period. If the list contains "ADS", new periods will be created where the Channel source contains SCTE-35 ad markers.
        """
        return pulumi.get(self, "period_triggers")

    @property
    @pulumi.getter
    def profile(self) -> Optional['OriginEndpointDashPackageProfile']:
        """
        The Dynamic Adaptive Streaming over HTTP (DASH) profile type.  When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[int]:
        """
        Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source segment duration.
        """
        return pulumi.get(self, "segment_duration_seconds")

    @property
    @pulumi.getter(name="segmentTemplateFormat")
    def segment_template_format(self) -> Optional['OriginEndpointDashPackageSegmentTemplateFormat']:
        """
        Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).  When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs.  When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        """
        return pulumi.get(self, "segment_template_format")

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional['outputs.OriginEndpointStreamSelection']:
        return pulumi.get(self, "stream_selection")

    @property
    @pulumi.getter(name="suggestedPresentationDelaySeconds")
    def suggested_presentation_delay_seconds(self) -> Optional[int]:
        """
        Duration (in seconds) to delay live content before presentation.
        """
        return pulumi.get(self, "suggested_presentation_delay_seconds")

    @property
    @pulumi.getter(name="utcTiming")
    def utc_timing(self) -> Optional['OriginEndpointDashPackageUtcTiming']:
        """
        Determines the type of UTCTiming included in the Media Presentation Description (MPD)
        """
        return pulumi.get(self, "utc_timing")

    @property
    @pulumi.getter(name="utcTimingUri")
    def utc_timing_uri(self) -> Optional[str]:
        """
        Specifies the value attribute of the UTCTiming field when utcTiming is set to HTTP-ISO or HTTP-HEAD
        """
        return pulumi.get(self, "utc_timing_uri")


@pulumi.output_type
class OriginEndpointHlsEncryption(dict):
    """
    An HTTP Live Streaming (HLS) encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spekeKeyProvider":
            suggest = "speke_key_provider"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "encryptionMethod":
            suggest = "encryption_method"
        elif key == "keyRotationIntervalSeconds":
            suggest = "key_rotation_interval_seconds"
        elif key == "repeatExtXKey":
            suggest = "repeat_ext_x_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointHlsEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointHlsEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointHlsEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 speke_key_provider: 'outputs.OriginEndpointSpekeKeyProvider',
                 constant_initialization_vector: Optional[str] = None,
                 encryption_method: Optional['OriginEndpointHlsEncryptionEncryptionMethod'] = None,
                 key_rotation_interval_seconds: Optional[int] = None,
                 repeat_ext_x_key: Optional[bool] = None):
        """
        An HTTP Live Streaming (HLS) encryption configuration.
        :param str constant_initialization_vector: A constant initialization vector for encryption (optional). When not specified the initialization vector will be periodically rotated.
        :param 'OriginEndpointHlsEncryptionEncryptionMethod' encryption_method: The encryption method to use.
        :param int key_rotation_interval_seconds: Interval (in seconds) between each encryption key rotation.
        :param bool repeat_ext_x_key: When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if encryption_method is not None:
            pulumi.set(__self__, "encryption_method", encryption_method)
        if key_rotation_interval_seconds is not None:
            pulumi.set(__self__, "key_rotation_interval_seconds", key_rotation_interval_seconds)
        if repeat_ext_x_key is not None:
            pulumi.set(__self__, "repeat_ext_x_key", repeat_ext_x_key)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> 'outputs.OriginEndpointSpekeKeyProvider':
        return pulumi.get(self, "speke_key_provider")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[str]:
        """
        A constant initialization vector for encryption (optional). When not specified the initialization vector will be periodically rotated.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="encryptionMethod")
    def encryption_method(self) -> Optional['OriginEndpointHlsEncryptionEncryptionMethod']:
        """
        The encryption method to use.
        """
        return pulumi.get(self, "encryption_method")

    @property
    @pulumi.getter(name="keyRotationIntervalSeconds")
    def key_rotation_interval_seconds(self) -> Optional[int]:
        """
        Interval (in seconds) between each encryption key rotation.
        """
        return pulumi.get(self, "key_rotation_interval_seconds")

    @property
    @pulumi.getter(name="repeatExtXKey")
    def repeat_ext_x_key(self) -> Optional[bool]:
        """
        When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        """
        return pulumi.get(self, "repeat_ext_x_key")


@pulumi.output_type
class OriginEndpointHlsManifest(dict):
    """
    A HTTP Live Streaming (HLS) manifest configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adMarkers":
            suggest = "ad_markers"
        elif key == "adTriggers":
            suggest = "ad_triggers"
        elif key == "adsOnDeliveryRestrictions":
            suggest = "ads_on_delivery_restrictions"
        elif key == "includeIframeOnlyStream":
            suggest = "include_iframe_only_stream"
        elif key == "manifestName":
            suggest = "manifest_name"
        elif key == "playlistType":
            suggest = "playlist_type"
        elif key == "playlistWindowSeconds":
            suggest = "playlist_window_seconds"
        elif key == "programDateTimeIntervalSeconds":
            suggest = "program_date_time_interval_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointHlsManifest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointHlsManifest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointHlsManifest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: str,
                 ad_markers: Optional['OriginEndpointHlsManifestAdMarkers'] = None,
                 ad_triggers: Optional[Sequence['OriginEndpointHlsManifestAdTriggersItem']] = None,
                 ads_on_delivery_restrictions: Optional['OriginEndpointAdsOnDeliveryRestrictions'] = None,
                 include_iframe_only_stream: Optional[bool] = None,
                 manifest_name: Optional[str] = None,
                 playlist_type: Optional['OriginEndpointHlsManifestPlaylistType'] = None,
                 playlist_window_seconds: Optional[int] = None,
                 program_date_time_interval_seconds: Optional[int] = None,
                 url: Optional[str] = None):
        """
        A HTTP Live Streaming (HLS) manifest configuration.
        :param str id: The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
        :param 'OriginEndpointHlsManifestAdMarkers' ad_markers: This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
        :param Sequence['OriginEndpointHlsManifestAdTriggersItem'] ad_triggers: A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        :param bool include_iframe_only_stream: When enabled, an I-Frame only stream will be included in the output.
        :param str manifest_name: An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
        :param 'OriginEndpointHlsManifestPlaylistType' playlist_type: The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
        :param int playlist_window_seconds: Time window (in seconds) contained in each parent manifest.
        :param int program_date_time_interval_seconds: The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        :param str url: The URL of the packaged OriginEndpoint for consumption.
        """
        pulumi.set(__self__, "id", id)
        if ad_markers is not None:
            pulumi.set(__self__, "ad_markers", ad_markers)
        if ad_triggers is not None:
            pulumi.set(__self__, "ad_triggers", ad_triggers)
        if ads_on_delivery_restrictions is not None:
            pulumi.set(__self__, "ads_on_delivery_restrictions", ads_on_delivery_restrictions)
        if include_iframe_only_stream is not None:
            pulumi.set(__self__, "include_iframe_only_stream", include_iframe_only_stream)
        if manifest_name is not None:
            pulumi.set(__self__, "manifest_name", manifest_name)
        if playlist_type is not None:
            pulumi.set(__self__, "playlist_type", playlist_type)
        if playlist_window_seconds is not None:
            pulumi.set(__self__, "playlist_window_seconds", playlist_window_seconds)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the manifest. The ID must be unique within the OriginEndpoint and it cannot be changed after it is created.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="adMarkers")
    def ad_markers(self) -> Optional['OriginEndpointHlsManifestAdMarkers']:
        """
        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
        """
        return pulumi.get(self, "ad_markers")

    @property
    @pulumi.getter(name="adTriggers")
    def ad_triggers(self) -> Optional[Sequence['OriginEndpointHlsManifestAdTriggersItem']]:
        """
        A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        """
        return pulumi.get(self, "ad_triggers")

    @property
    @pulumi.getter(name="adsOnDeliveryRestrictions")
    def ads_on_delivery_restrictions(self) -> Optional['OriginEndpointAdsOnDeliveryRestrictions']:
        return pulumi.get(self, "ads_on_delivery_restrictions")

    @property
    @pulumi.getter(name="includeIframeOnlyStream")
    def include_iframe_only_stream(self) -> Optional[bool]:
        """
        When enabled, an I-Frame only stream will be included in the output.
        """
        return pulumi.get(self, "include_iframe_only_stream")

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> Optional[str]:
        """
        An optional short string appended to the end of the OriginEndpoint URL. If not specified, defaults to the manifestName for the OriginEndpoint.
        """
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="playlistType")
    def playlist_type(self) -> Optional['OriginEndpointHlsManifestPlaylistType']:
        """
        The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
        """
        return pulumi.get(self, "playlist_type")

    @property
    @pulumi.getter(name="playlistWindowSeconds")
    def playlist_window_seconds(self) -> Optional[int]:
        """
        Time window (in seconds) contained in each parent manifest.
        """
        return pulumi.get(self, "playlist_window_seconds")

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[int]:
        """
        The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @property
    @pulumi.getter
    def url(self) -> Optional[str]:
        """
        The URL of the packaged OriginEndpoint for consumption.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class OriginEndpointHlsPackage(dict):
    """
    An HTTP Live Streaming (HLS) packaging configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adMarkers":
            suggest = "ad_markers"
        elif key == "adTriggers":
            suggest = "ad_triggers"
        elif key == "adsOnDeliveryRestrictions":
            suggest = "ads_on_delivery_restrictions"
        elif key == "includeIframeOnlyStream":
            suggest = "include_iframe_only_stream"
        elif key == "playlistType":
            suggest = "playlist_type"
        elif key == "playlistWindowSeconds":
            suggest = "playlist_window_seconds"
        elif key == "programDateTimeIntervalSeconds":
            suggest = "program_date_time_interval_seconds"
        elif key == "segmentDurationSeconds":
            suggest = "segment_duration_seconds"
        elif key == "streamSelection":
            suggest = "stream_selection"
        elif key == "useAudioRenditionGroup":
            suggest = "use_audio_rendition_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointHlsPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointHlsPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointHlsPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_markers: Optional['OriginEndpointHlsPackageAdMarkers'] = None,
                 ad_triggers: Optional[Sequence['OriginEndpointHlsPackageAdTriggersItem']] = None,
                 ads_on_delivery_restrictions: Optional['OriginEndpointAdsOnDeliveryRestrictions'] = None,
                 encryption: Optional['outputs.OriginEndpointHlsEncryption'] = None,
                 include_iframe_only_stream: Optional[bool] = None,
                 playlist_type: Optional['OriginEndpointHlsPackagePlaylistType'] = None,
                 playlist_window_seconds: Optional[int] = None,
                 program_date_time_interval_seconds: Optional[int] = None,
                 segment_duration_seconds: Optional[int] = None,
                 stream_selection: Optional['outputs.OriginEndpointStreamSelection'] = None,
                 use_audio_rendition_group: Optional[bool] = None):
        """
        An HTTP Live Streaming (HLS) packaging configuration.
        :param 'OriginEndpointHlsPackageAdMarkers' ad_markers: This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
        :param Sequence['OriginEndpointHlsPackageAdTriggersItem'] ad_triggers: A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        :param bool include_iframe_only_stream: When enabled, an I-Frame only stream will be included in the output.
        :param 'OriginEndpointHlsPackagePlaylistType' playlist_type: The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
        :param int playlist_window_seconds: Time window (in seconds) contained in each parent manifest.
        :param int program_date_time_interval_seconds: The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        :param int segment_duration_seconds: Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the source fragment duration.
        :param bool use_audio_rendition_group: When enabled, audio streams will be placed in rendition groups in the output.
        """
        if ad_markers is not None:
            pulumi.set(__self__, "ad_markers", ad_markers)
        if ad_triggers is not None:
            pulumi.set(__self__, "ad_triggers", ad_triggers)
        if ads_on_delivery_restrictions is not None:
            pulumi.set(__self__, "ads_on_delivery_restrictions", ads_on_delivery_restrictions)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if include_iframe_only_stream is not None:
            pulumi.set(__self__, "include_iframe_only_stream", include_iframe_only_stream)
        if playlist_type is not None:
            pulumi.set(__self__, "playlist_type", playlist_type)
        if playlist_window_seconds is not None:
            pulumi.set(__self__, "playlist_window_seconds", playlist_window_seconds)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)
        if use_audio_rendition_group is not None:
            pulumi.set(__self__, "use_audio_rendition_group", use_audio_rendition_group)

    @property
    @pulumi.getter(name="adMarkers")
    def ad_markers(self) -> Optional['OriginEndpointHlsPackageAdMarkers']:
        """
        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source. "DATERANGE" inserts EXT-X-DATERANGE tags to signal ad and program transition events in HLS and CMAF manifests. For this option, you must set a programDateTimeIntervalSeconds value that is greater than 0.
        """
        return pulumi.get(self, "ad_markers")

    @property
    @pulumi.getter(name="adTriggers")
    def ad_triggers(self) -> Optional[Sequence['OriginEndpointHlsPackageAdTriggersItem']]:
        """
        A list of SCTE-35 message types that are treated as ad markers in the output.  If empty, no ad markers are output.  Specify multiple items to create ad markers for all of the included message types.
        """
        return pulumi.get(self, "ad_triggers")

    @property
    @pulumi.getter(name="adsOnDeliveryRestrictions")
    def ads_on_delivery_restrictions(self) -> Optional['OriginEndpointAdsOnDeliveryRestrictions']:
        return pulumi.get(self, "ads_on_delivery_restrictions")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.OriginEndpointHlsEncryption']:
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="includeIframeOnlyStream")
    def include_iframe_only_stream(self) -> Optional[bool]:
        """
        When enabled, an I-Frame only stream will be included in the output.
        """
        return pulumi.get(self, "include_iframe_only_stream")

    @property
    @pulumi.getter(name="playlistType")
    def playlist_type(self) -> Optional['OriginEndpointHlsPackagePlaylistType']:
        """
        The HTTP Live Streaming (HLS) playlist type. When either "EVENT" or "VOD" is specified, a corresponding EXT-X-PLAYLIST-TYPE entry will be included in the media playlist.
        """
        return pulumi.get(self, "playlist_type")

    @property
    @pulumi.getter(name="playlistWindowSeconds")
    def playlist_window_seconds(self) -> Optional[int]:
        """
        Time window (in seconds) contained in each parent manifest.
        """
        return pulumi.get(self, "playlist_window_seconds")

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[int]:
        """
        The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[int]:
        """
        Duration (in seconds) of each fragment. Actual fragments will be rounded to the nearest multiple of the source fragment duration.
        """
        return pulumi.get(self, "segment_duration_seconds")

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional['outputs.OriginEndpointStreamSelection']:
        return pulumi.get(self, "stream_selection")

    @property
    @pulumi.getter(name="useAudioRenditionGroup")
    def use_audio_rendition_group(self) -> Optional[bool]:
        """
        When enabled, audio streams will be placed in rendition groups in the output.
        """
        return pulumi.get(self, "use_audio_rendition_group")


@pulumi.output_type
class OriginEndpointMssEncryption(dict):
    """
    A Microsoft Smooth Streaming (MSS) encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spekeKeyProvider":
            suggest = "speke_key_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointMssEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointMssEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointMssEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 speke_key_provider: 'outputs.OriginEndpointSpekeKeyProvider'):
        """
        A Microsoft Smooth Streaming (MSS) encryption configuration.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> 'outputs.OriginEndpointSpekeKeyProvider':
        return pulumi.get(self, "speke_key_provider")


@pulumi.output_type
class OriginEndpointMssPackage(dict):
    """
    A Microsoft Smooth Streaming (MSS) packaging configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestWindowSeconds":
            suggest = "manifest_window_seconds"
        elif key == "segmentDurationSeconds":
            suggest = "segment_duration_seconds"
        elif key == "streamSelection":
            suggest = "stream_selection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointMssPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointMssPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointMssPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption: Optional['outputs.OriginEndpointMssEncryption'] = None,
                 manifest_window_seconds: Optional[int] = None,
                 segment_duration_seconds: Optional[int] = None,
                 stream_selection: Optional['outputs.OriginEndpointStreamSelection'] = None):
        """
        A Microsoft Smooth Streaming (MSS) packaging configuration.
        :param int manifest_window_seconds: The time window (in seconds) contained in each manifest.
        :param int segment_duration_seconds: The duration (in seconds) of each segment.
        """
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if manifest_window_seconds is not None:
            pulumi.set(__self__, "manifest_window_seconds", manifest_window_seconds)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.OriginEndpointMssEncryption']:
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="manifestWindowSeconds")
    def manifest_window_seconds(self) -> Optional[int]:
        """
        The time window (in seconds) contained in each manifest.
        """
        return pulumi.get(self, "manifest_window_seconds")

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[int]:
        """
        The duration (in seconds) of each segment.
        """
        return pulumi.get(self, "segment_duration_seconds")

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional['outputs.OriginEndpointStreamSelection']:
        return pulumi.get(self, "stream_selection")


@pulumi.output_type
class OriginEndpointSpekeKeyProvider(dict):
    """
    A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"
        elif key == "roleArn":
            suggest = "role_arn"
        elif key == "systemIds":
            suggest = "system_ids"
        elif key == "certificateArn":
            suggest = "certificate_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointSpekeKeyProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointSpekeKeyProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointSpekeKeyProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: str,
                 role_arn: str,
                 system_ids: Sequence[str],
                 url: str,
                 certificate_arn: Optional[str] = None):
        """
        A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        :param str resource_id: The resource ID to include in key requests.
        :param str role_arn: An Amazon Resource Name (ARN) of an IAM role that AWS Elemental MediaPackage will assume when accessing the key provider service.
        :param Sequence[str] system_ids: The system IDs to include in key requests.
        :param str url: The URL of the external key provider service.
        :param str certificate_arn: An Amazon Resource Name (ARN) of a Certificate Manager certificate that MediaPackage will use for enforcing secure end-to-end data transfer with the key provider service.
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "system_ids", system_ids)
        pulumi.set(__self__, "url", url)
        if certificate_arn is not None:
            pulumi.set(__self__, "certificate_arn", certificate_arn)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The resource ID to include in key requests.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        """
        An Amazon Resource Name (ARN) of an IAM role that AWS Elemental MediaPackage will assume when accessing the key provider service.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="systemIds")
    def system_ids(self) -> Sequence[str]:
        """
        The system IDs to include in key requests.
        """
        return pulumi.get(self, "system_ids")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL of the external key provider service.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[str]:
        """
        An Amazon Resource Name (ARN) of a Certificate Manager certificate that MediaPackage will use for enforcing secure end-to-end data transfer with the key provider service.
        """
        return pulumi.get(self, "certificate_arn")


@pulumi.output_type
class OriginEndpointStreamSelection(dict):
    """
    A StreamSelection configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxVideoBitsPerSecond":
            suggest = "max_video_bits_per_second"
        elif key == "minVideoBitsPerSecond":
            suggest = "min_video_bits_per_second"
        elif key == "streamOrder":
            suggest = "stream_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OriginEndpointStreamSelection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OriginEndpointStreamSelection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OriginEndpointStreamSelection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_video_bits_per_second: Optional[int] = None,
                 min_video_bits_per_second: Optional[int] = None,
                 stream_order: Optional['OriginEndpointStreamSelectionStreamOrder'] = None):
        """
        A StreamSelection configuration.
        :param int max_video_bits_per_second: The maximum video bitrate (bps) to include in output.
        :param int min_video_bits_per_second: The minimum video bitrate (bps) to include in output.
        :param 'OriginEndpointStreamSelectionStreamOrder' stream_order: A directive that determines the order of streams in the output.
        """
        if max_video_bits_per_second is not None:
            pulumi.set(__self__, "max_video_bits_per_second", max_video_bits_per_second)
        if min_video_bits_per_second is not None:
            pulumi.set(__self__, "min_video_bits_per_second", min_video_bits_per_second)
        if stream_order is not None:
            pulumi.set(__self__, "stream_order", stream_order)

    @property
    @pulumi.getter(name="maxVideoBitsPerSecond")
    def max_video_bits_per_second(self) -> Optional[int]:
        """
        The maximum video bitrate (bps) to include in output.
        """
        return pulumi.get(self, "max_video_bits_per_second")

    @property
    @pulumi.getter(name="minVideoBitsPerSecond")
    def min_video_bits_per_second(self) -> Optional[int]:
        """
        The minimum video bitrate (bps) to include in output.
        """
        return pulumi.get(self, "min_video_bits_per_second")

    @property
    @pulumi.getter(name="streamOrder")
    def stream_order(self) -> Optional['OriginEndpointStreamSelectionStreamOrder']:
        """
        A directive that determines the order of streams in the output.
        """
        return pulumi.get(self, "stream_order")


@pulumi.output_type
class OriginEndpointTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class PackagingConfigurationCmafEncryption(dict):
    """
    A CMAF encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spekeKeyProvider":
            suggest = "speke_key_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationCmafEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationCmafEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationCmafEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 speke_key_provider: 'outputs.PackagingConfigurationSpekeKeyProvider'):
        """
        A CMAF encryption configuration.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> 'outputs.PackagingConfigurationSpekeKeyProvider':
        return pulumi.get(self, "speke_key_provider")


@pulumi.output_type
class PackagingConfigurationCmafPackage(dict):
    """
    A CMAF packaging configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hlsManifests":
            suggest = "hls_manifests"
        elif key == "includeEncoderConfigurationInSegments":
            suggest = "include_encoder_configuration_in_segments"
        elif key == "segmentDurationSeconds":
            suggest = "segment_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationCmafPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationCmafPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationCmafPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hls_manifests: Sequence['outputs.PackagingConfigurationHlsManifest'],
                 encryption: Optional['outputs.PackagingConfigurationCmafEncryption'] = None,
                 include_encoder_configuration_in_segments: Optional[bool] = None,
                 segment_duration_seconds: Optional[int] = None):
        """
        A CMAF packaging configuration.
        :param Sequence['PackagingConfigurationHlsManifest'] hls_manifests: A list of HLS manifest configurations.
        :param bool include_encoder_configuration_in_segments: When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        """
        pulumi.set(__self__, "hls_manifests", hls_manifests)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if include_encoder_configuration_in_segments is not None:
            pulumi.set(__self__, "include_encoder_configuration_in_segments", include_encoder_configuration_in_segments)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)

    @property
    @pulumi.getter(name="hlsManifests")
    def hls_manifests(self) -> Sequence['outputs.PackagingConfigurationHlsManifest']:
        """
        A list of HLS manifest configurations.
        """
        return pulumi.get(self, "hls_manifests")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.PackagingConfigurationCmafEncryption']:
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="includeEncoderConfigurationInSegments")
    def include_encoder_configuration_in_segments(self) -> Optional[bool]:
        """
        When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        """
        return pulumi.get(self, "include_encoder_configuration_in_segments")

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[int]:
        return pulumi.get(self, "segment_duration_seconds")


@pulumi.output_type
class PackagingConfigurationDashEncryption(dict):
    """
    A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spekeKeyProvider":
            suggest = "speke_key_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationDashEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationDashEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationDashEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 speke_key_provider: 'outputs.PackagingConfigurationSpekeKeyProvider'):
        """
        A Dynamic Adaptive Streaming over HTTP (DASH) encryption configuration.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> 'outputs.PackagingConfigurationSpekeKeyProvider':
        return pulumi.get(self, "speke_key_provider")


@pulumi.output_type
class PackagingConfigurationDashManifest(dict):
    """
    A DASH manifest configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestLayout":
            suggest = "manifest_layout"
        elif key == "manifestName":
            suggest = "manifest_name"
        elif key == "minBufferTimeSeconds":
            suggest = "min_buffer_time_seconds"
        elif key == "streamSelection":
            suggest = "stream_selection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationDashManifest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationDashManifest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationDashManifest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_layout: Optional['PackagingConfigurationDashManifestManifestLayout'] = None,
                 manifest_name: Optional[str] = None,
                 min_buffer_time_seconds: Optional[int] = None,
                 profile: Optional['PackagingConfigurationDashManifestProfile'] = None,
                 stream_selection: Optional['outputs.PackagingConfigurationStreamSelection'] = None):
        """
        A DASH manifest configuration.
        :param 'PackagingConfigurationDashManifestManifestLayout' manifest_layout: Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        :param int min_buffer_time_seconds: Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        :param 'PackagingConfigurationDashManifestProfile' profile: The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        """
        if manifest_layout is not None:
            pulumi.set(__self__, "manifest_layout", manifest_layout)
        if manifest_name is not None:
            pulumi.set(__self__, "manifest_name", manifest_name)
        if min_buffer_time_seconds is not None:
            pulumi.set(__self__, "min_buffer_time_seconds", min_buffer_time_seconds)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)

    @property
    @pulumi.getter(name="manifestLayout")
    def manifest_layout(self) -> Optional['PackagingConfigurationDashManifestManifestLayout']:
        """
        Determines the position of some tags in the Media Presentation Description (MPD). When set to FULL, elements like SegmentTemplate and ContentProtection are included in each Representation. When set to COMPACT, duplicate elements are combined and presented at the AdaptationSet level.
        """
        return pulumi.get(self, "manifest_layout")

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> Optional[str]:
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="minBufferTimeSeconds")
    def min_buffer_time_seconds(self) -> Optional[int]:
        """
        Minimum duration (in seconds) that a player will buffer media before starting the presentation.
        """
        return pulumi.get(self, "min_buffer_time_seconds")

    @property
    @pulumi.getter
    def profile(self) -> Optional['PackagingConfigurationDashManifestProfile']:
        """
        The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant output is enabled.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional['outputs.PackagingConfigurationStreamSelection']:
        return pulumi.get(self, "stream_selection")


@pulumi.output_type
class PackagingConfigurationDashPackage(dict):
    """
    A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dashManifests":
            suggest = "dash_manifests"
        elif key == "includeEncoderConfigurationInSegments":
            suggest = "include_encoder_configuration_in_segments"
        elif key == "periodTriggers":
            suggest = "period_triggers"
        elif key == "segmentDurationSeconds":
            suggest = "segment_duration_seconds"
        elif key == "segmentTemplateFormat":
            suggest = "segment_template_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationDashPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationDashPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationDashPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dash_manifests: Sequence['outputs.PackagingConfigurationDashManifest'],
                 encryption: Optional['outputs.PackagingConfigurationDashEncryption'] = None,
                 include_encoder_configuration_in_segments: Optional[bool] = None,
                 period_triggers: Optional[Sequence['PackagingConfigurationDashPackagePeriodTriggersItem']] = None,
                 segment_duration_seconds: Optional[int] = None,
                 segment_template_format: Optional['PackagingConfigurationDashPackageSegmentTemplateFormat'] = None):
        """
        A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
        :param Sequence['PackagingConfigurationDashManifest'] dash_manifests: A list of DASH manifest configurations.
        :param bool include_encoder_configuration_in_segments: When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        :param Sequence['PackagingConfigurationDashPackagePeriodTriggersItem'] period_triggers: A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into more than one period. If the list contains "ADS", new periods will be created where the Asset contains SCTE-35 ad markers.
        :param 'PackagingConfigurationDashPackageSegmentTemplateFormat' segment_template_format: Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        """
        pulumi.set(__self__, "dash_manifests", dash_manifests)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if include_encoder_configuration_in_segments is not None:
            pulumi.set(__self__, "include_encoder_configuration_in_segments", include_encoder_configuration_in_segments)
        if period_triggers is not None:
            pulumi.set(__self__, "period_triggers", period_triggers)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if segment_template_format is not None:
            pulumi.set(__self__, "segment_template_format", segment_template_format)

    @property
    @pulumi.getter(name="dashManifests")
    def dash_manifests(self) -> Sequence['outputs.PackagingConfigurationDashManifest']:
        """
        A list of DASH manifest configurations.
        """
        return pulumi.get(self, "dash_manifests")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.PackagingConfigurationDashEncryption']:
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="includeEncoderConfigurationInSegments")
    def include_encoder_configuration_in_segments(self) -> Optional[bool]:
        """
        When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment. This lets you use different SPS/PPS/VPS settings for your assets during content playback.
        """
        return pulumi.get(self, "include_encoder_configuration_in_segments")

    @property
    @pulumi.getter(name="periodTriggers")
    def period_triggers(self) -> Optional[Sequence['PackagingConfigurationDashPackagePeriodTriggersItem']]:
        """
        A list of triggers that controls when the outgoing Dynamic Adaptive Streaming over HTTP (DASH) Media Presentation Description (MPD) will be partitioned into multiple periods. If empty, the content will not be partitioned into more than one period. If the list contains "ADS", new periods will be created where the Asset contains SCTE-35 ad markers.
        """
        return pulumi.get(self, "period_triggers")

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[int]:
        return pulumi.get(self, "segment_duration_seconds")

    @property
    @pulumi.getter(name="segmentTemplateFormat")
    def segment_template_format(self) -> Optional['PackagingConfigurationDashPackageSegmentTemplateFormat']:
        """
        Determines the type of SegmentTemplate included in the Media Presentation Description (MPD). When set to NUMBER_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When set to TIME_WITH_TIMELINE, a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to NUMBER_WITH_DURATION, only a duration is included in each SegmentTemplate, with $Number$ media URLs.
        """
        return pulumi.get(self, "segment_template_format")


@pulumi.output_type
class PackagingConfigurationHlsEncryption(dict):
    """
    An HTTP Live Streaming (HLS) encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spekeKeyProvider":
            suggest = "speke_key_provider"
        elif key == "constantInitializationVector":
            suggest = "constant_initialization_vector"
        elif key == "encryptionMethod":
            suggest = "encryption_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationHlsEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationHlsEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationHlsEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 speke_key_provider: 'outputs.PackagingConfigurationSpekeKeyProvider',
                 constant_initialization_vector: Optional[str] = None,
                 encryption_method: Optional['PackagingConfigurationHlsEncryptionEncryptionMethod'] = None):
        """
        An HTTP Live Streaming (HLS) encryption configuration.
        :param str constant_initialization_vector: An HTTP Live Streaming (HLS) encryption configuration.
        :param 'PackagingConfigurationHlsEncryptionEncryptionMethod' encryption_method: The encryption method to use.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)
        if constant_initialization_vector is not None:
            pulumi.set(__self__, "constant_initialization_vector", constant_initialization_vector)
        if encryption_method is not None:
            pulumi.set(__self__, "encryption_method", encryption_method)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> 'outputs.PackagingConfigurationSpekeKeyProvider':
        return pulumi.get(self, "speke_key_provider")

    @property
    @pulumi.getter(name="constantInitializationVector")
    def constant_initialization_vector(self) -> Optional[str]:
        """
        An HTTP Live Streaming (HLS) encryption configuration.
        """
        return pulumi.get(self, "constant_initialization_vector")

    @property
    @pulumi.getter(name="encryptionMethod")
    def encryption_method(self) -> Optional['PackagingConfigurationHlsEncryptionEncryptionMethod']:
        """
        The encryption method to use.
        """
        return pulumi.get(self, "encryption_method")


@pulumi.output_type
class PackagingConfigurationHlsManifest(dict):
    """
    An HTTP Live Streaming (HLS) manifest configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adMarkers":
            suggest = "ad_markers"
        elif key == "includeIframeOnlyStream":
            suggest = "include_iframe_only_stream"
        elif key == "manifestName":
            suggest = "manifest_name"
        elif key == "programDateTimeIntervalSeconds":
            suggest = "program_date_time_interval_seconds"
        elif key == "repeatExtXKey":
            suggest = "repeat_ext_x_key"
        elif key == "streamSelection":
            suggest = "stream_selection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationHlsManifest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationHlsManifest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationHlsManifest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ad_markers: Optional['PackagingConfigurationHlsManifestAdMarkers'] = None,
                 include_iframe_only_stream: Optional[bool] = None,
                 manifest_name: Optional[str] = None,
                 program_date_time_interval_seconds: Optional[int] = None,
                 repeat_ext_x_key: Optional[bool] = None,
                 stream_selection: Optional['outputs.PackagingConfigurationStreamSelection'] = None):
        """
        An HTTP Live Streaming (HLS) manifest configuration.
        :param 'PackagingConfigurationHlsManifestAdMarkers' ad_markers: This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source.
        :param bool include_iframe_only_stream: When enabled, an I-Frame only stream will be included in the output.
        :param int program_date_time_interval_seconds: The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        :param bool repeat_ext_x_key: When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        """
        if ad_markers is not None:
            pulumi.set(__self__, "ad_markers", ad_markers)
        if include_iframe_only_stream is not None:
            pulumi.set(__self__, "include_iframe_only_stream", include_iframe_only_stream)
        if manifest_name is not None:
            pulumi.set(__self__, "manifest_name", manifest_name)
        if program_date_time_interval_seconds is not None:
            pulumi.set(__self__, "program_date_time_interval_seconds", program_date_time_interval_seconds)
        if repeat_ext_x_key is not None:
            pulumi.set(__self__, "repeat_ext_x_key", repeat_ext_x_key)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)

    @property
    @pulumi.getter(name="adMarkers")
    def ad_markers(self) -> Optional['PackagingConfigurationHlsManifestAdMarkers']:
        """
        This setting controls how ad markers are included in the packaged OriginEndpoint. "NONE" will omit all SCTE-35 ad markers from the output. "PASSTHROUGH" causes the manifest to contain a copy of the SCTE-35 ad markers (comments) taken directly from the input HTTP Live Streaming (HLS) manifest. "SCTE35_ENHANCED" generates ad markers and blackout tags based on SCTE-35 messages in the input source.
        """
        return pulumi.get(self, "ad_markers")

    @property
    @pulumi.getter(name="includeIframeOnlyStream")
    def include_iframe_only_stream(self) -> Optional[bool]:
        """
        When enabled, an I-Frame only stream will be included in the output.
        """
        return pulumi.get(self, "include_iframe_only_stream")

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> Optional[str]:
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="programDateTimeIntervalSeconds")
    def program_date_time_interval_seconds(self) -> Optional[int]:
        """
        The interval (in seconds) between each EXT-X-PROGRAM-DATE-TIME tag inserted into manifests. Additionally, when an interval is specified ID3Timed Metadata messages will be generated every 5 seconds using the ingest time of the content. If the interval is not specified, or set to 0, then no EXT-X-PROGRAM-DATE-TIME tags will be inserted into manifests and no ID3Timed Metadata messages will be generated. Note that irrespective of this parameter, if any ID3 Timed Metadata is found in HTTP Live Streaming (HLS) input, it will be passed through to HLS output.
        """
        return pulumi.get(self, "program_date_time_interval_seconds")

    @property
    @pulumi.getter(name="repeatExtXKey")
    def repeat_ext_x_key(self) -> Optional[bool]:
        """
        When enabled, the EXT-X-KEY tag will be repeated in output manifests.
        """
        return pulumi.get(self, "repeat_ext_x_key")

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional['outputs.PackagingConfigurationStreamSelection']:
        return pulumi.get(self, "stream_selection")


@pulumi.output_type
class PackagingConfigurationHlsPackage(dict):
    """
    An HTTP Live Streaming (HLS) packaging configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hlsManifests":
            suggest = "hls_manifests"
        elif key == "segmentDurationSeconds":
            suggest = "segment_duration_seconds"
        elif key == "useAudioRenditionGroup":
            suggest = "use_audio_rendition_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationHlsPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationHlsPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationHlsPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hls_manifests: Sequence['outputs.PackagingConfigurationHlsManifest'],
                 encryption: Optional['outputs.PackagingConfigurationHlsEncryption'] = None,
                 segment_duration_seconds: Optional[int] = None,
                 use_audio_rendition_group: Optional[bool] = None):
        """
        An HTTP Live Streaming (HLS) packaging configuration.
        :param Sequence['PackagingConfigurationHlsManifest'] hls_manifests: A list of HLS manifest configurations.
        :param bool use_audio_rendition_group: When enabled, audio streams will be placed in rendition groups in the output.
        """
        pulumi.set(__self__, "hls_manifests", hls_manifests)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)
        if use_audio_rendition_group is not None:
            pulumi.set(__self__, "use_audio_rendition_group", use_audio_rendition_group)

    @property
    @pulumi.getter(name="hlsManifests")
    def hls_manifests(self) -> Sequence['outputs.PackagingConfigurationHlsManifest']:
        """
        A list of HLS manifest configurations.
        """
        return pulumi.get(self, "hls_manifests")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.PackagingConfigurationHlsEncryption']:
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[int]:
        return pulumi.get(self, "segment_duration_seconds")

    @property
    @pulumi.getter(name="useAudioRenditionGroup")
    def use_audio_rendition_group(self) -> Optional[bool]:
        """
        When enabled, audio streams will be placed in rendition groups in the output.
        """
        return pulumi.get(self, "use_audio_rendition_group")


@pulumi.output_type
class PackagingConfigurationMssEncryption(dict):
    """
    A CMAF encryption configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "spekeKeyProvider":
            suggest = "speke_key_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationMssEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationMssEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationMssEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 speke_key_provider: 'outputs.PackagingConfigurationSpekeKeyProvider'):
        """
        A CMAF encryption configuration.
        """
        pulumi.set(__self__, "speke_key_provider", speke_key_provider)

    @property
    @pulumi.getter(name="spekeKeyProvider")
    def speke_key_provider(self) -> 'outputs.PackagingConfigurationSpekeKeyProvider':
        return pulumi.get(self, "speke_key_provider")


@pulumi.output_type
class PackagingConfigurationMssManifest(dict):
    """
    A Microsoft Smooth Streaming (MSS) manifest configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manifestName":
            suggest = "manifest_name"
        elif key == "streamSelection":
            suggest = "stream_selection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationMssManifest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationMssManifest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationMssManifest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manifest_name: Optional[str] = None,
                 stream_selection: Optional['outputs.PackagingConfigurationStreamSelection'] = None):
        """
        A Microsoft Smooth Streaming (MSS) manifest configuration.
        """
        if manifest_name is not None:
            pulumi.set(__self__, "manifest_name", manifest_name)
        if stream_selection is not None:
            pulumi.set(__self__, "stream_selection", stream_selection)

    @property
    @pulumi.getter(name="manifestName")
    def manifest_name(self) -> Optional[str]:
        return pulumi.get(self, "manifest_name")

    @property
    @pulumi.getter(name="streamSelection")
    def stream_selection(self) -> Optional['outputs.PackagingConfigurationStreamSelection']:
        return pulumi.get(self, "stream_selection")


@pulumi.output_type
class PackagingConfigurationMssPackage(dict):
    """
    A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mssManifests":
            suggest = "mss_manifests"
        elif key == "segmentDurationSeconds":
            suggest = "segment_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationMssPackage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationMssPackage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationMssPackage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mss_manifests: Sequence['outputs.PackagingConfigurationMssManifest'],
                 encryption: Optional['outputs.PackagingConfigurationMssEncryption'] = None,
                 segment_duration_seconds: Optional[int] = None):
        """
        A Microsoft Smooth Streaming (MSS) PackagingConfiguration.
        :param Sequence['PackagingConfigurationMssManifest'] mss_manifests: A list of MSS manifest configurations.
        """
        pulumi.set(__self__, "mss_manifests", mss_manifests)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if segment_duration_seconds is not None:
            pulumi.set(__self__, "segment_duration_seconds", segment_duration_seconds)

    @property
    @pulumi.getter(name="mssManifests")
    def mss_manifests(self) -> Sequence['outputs.PackagingConfigurationMssManifest']:
        """
        A list of MSS manifest configurations.
        """
        return pulumi.get(self, "mss_manifests")

    @property
    @pulumi.getter
    def encryption(self) -> Optional['outputs.PackagingConfigurationMssEncryption']:
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="segmentDurationSeconds")
    def segment_duration_seconds(self) -> Optional[int]:
        return pulumi.get(self, "segment_duration_seconds")


@pulumi.output_type
class PackagingConfigurationSpekeKeyProvider(dict):
    """
    A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "systemIds":
            suggest = "system_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationSpekeKeyProvider. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationSpekeKeyProvider.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationSpekeKeyProvider.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role_arn: str,
                 system_ids: Sequence[str],
                 url: str):
        """
        A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that will provide encryption keys.
        :param Sequence[str] system_ids: The system IDs to include in key requests.
        :param str url: The URL of the external key provider service.
        """
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "system_ids", system_ids)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="systemIds")
    def system_ids(self) -> Sequence[str]:
        """
        The system IDs to include in key requests.
        """
        return pulumi.get(self, "system_ids")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL of the external key provider service.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class PackagingConfigurationStreamSelection(dict):
    """
    A StreamSelection configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxVideoBitsPerSecond":
            suggest = "max_video_bits_per_second"
        elif key == "minVideoBitsPerSecond":
            suggest = "min_video_bits_per_second"
        elif key == "streamOrder":
            suggest = "stream_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingConfigurationStreamSelection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingConfigurationStreamSelection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingConfigurationStreamSelection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_video_bits_per_second: Optional[int] = None,
                 min_video_bits_per_second: Optional[int] = None,
                 stream_order: Optional['PackagingConfigurationStreamSelectionStreamOrder'] = None):
        """
        A StreamSelection configuration.
        :param int max_video_bits_per_second: The maximum video bitrate (bps) to include in output.
        :param int min_video_bits_per_second: The minimum video bitrate (bps) to include in output.
        :param 'PackagingConfigurationStreamSelectionStreamOrder' stream_order: A directive that determines the order of streams in the output.
        """
        if max_video_bits_per_second is not None:
            pulumi.set(__self__, "max_video_bits_per_second", max_video_bits_per_second)
        if min_video_bits_per_second is not None:
            pulumi.set(__self__, "min_video_bits_per_second", min_video_bits_per_second)
        if stream_order is not None:
            pulumi.set(__self__, "stream_order", stream_order)

    @property
    @pulumi.getter(name="maxVideoBitsPerSecond")
    def max_video_bits_per_second(self) -> Optional[int]:
        """
        The maximum video bitrate (bps) to include in output.
        """
        return pulumi.get(self, "max_video_bits_per_second")

    @property
    @pulumi.getter(name="minVideoBitsPerSecond")
    def min_video_bits_per_second(self) -> Optional[int]:
        """
        The minimum video bitrate (bps) to include in output.
        """
        return pulumi.get(self, "min_video_bits_per_second")

    @property
    @pulumi.getter(name="streamOrder")
    def stream_order(self) -> Optional['PackagingConfigurationStreamSelectionStreamOrder']:
        """
        A directive that determines the order of streams in the output.
        """
        return pulumi.get(self, "stream_order")


@pulumi.output_type
class PackagingConfigurationTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class PackagingGroupAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cdnIdentifierSecret":
            suggest = "cdn_identifier_secret"
        elif key == "secretsRoleArn":
            suggest = "secrets_role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingGroupAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingGroupAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingGroupAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cdn_identifier_secret: str,
                 secrets_role_arn: str):
        """
        :param str cdn_identifier_secret: The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN authorization.
        :param str secrets_role_arn: The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        """
        pulumi.set(__self__, "cdn_identifier_secret", cdn_identifier_secret)
        pulumi.set(__self__, "secrets_role_arn", secrets_role_arn)

    @property
    @pulumi.getter(name="cdnIdentifierSecret")
    def cdn_identifier_secret(self) -> str:
        """
        The Amazon Resource Name (ARN) for the secret in AWS Secrets Manager that is used for CDN authorization.
        """
        return pulumi.get(self, "cdn_identifier_secret")

    @property
    @pulumi.getter(name="secretsRoleArn")
    def secrets_role_arn(self) -> str:
        """
        The Amazon Resource Name (ARN) for the IAM role that allows MediaPackage to communicate with AWS Secrets Manager.
        """
        return pulumi.get(self, "secrets_role_arn")


@pulumi.output_type
class PackagingGroupLogConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logGroupName":
            suggest = "log_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackagingGroupLogConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackagingGroupLogConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackagingGroupLogConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_group_name: Optional[str] = None):
        """
        :param str log_group_name: Sets a custom AWS CloudWatch log group name for egress logs. If a log group name isn't specified, the default name is used: /aws/MediaPackage/VodEgressAccessLogs.
        """
        if log_group_name is not None:
            pulumi.set(__self__, "log_group_name", log_group_name)

    @property
    @pulumi.getter(name="logGroupName")
    def log_group_name(self) -> Optional[str]:
        """
        Sets a custom AWS CloudWatch log group name for egress logs. If a log group name isn't specified, the default name is used: /aws/MediaPackage/VodEgressAccessLogs.
        """
        return pulumi.get(self, "log_group_name")


@pulumi.output_type
class PackagingGroupTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


