/**
 * The different types of data manipulation that Mito supports.
 */
export var StepType;
(function (StepType) {
    StepType["Initialize"] = "initialize";
    StepType["AddColumn"] = "add_column";
    StepType["DeleteColumn"] = "delete_column";
    StepType["RenameColumn"] = "rename_column";
    StepType["ReorderColumn"] = "reorder_column";
    StepType["FilterColumn"] = "filter_column";
    StepType["SetColumnFormula"] = "set_column_formula";
    StepType["DataframeDelete"] = "dataframe_delete";
    StepType["DataframeDuplicate"] = "dataframe_duplicate";
    StepType["DataframeRename"] = "dataframe_rename";
    StepType["SimpleImport"] = "simple_import";
    StepType["Sort"] = "sort";
    StepType["Pivot"] = "pivot";
    StepType["Merge"] = "merge";
    StepType["Concat"] = "concat";
    StepType["DropDuplicates"] = "drop_duplicates";
    StepType["ChangeColumnDtype"] = "change_column_dtype";
    StepType["ChangeColumnFormat"] = "change_column_format";
    StepType["SetCellValue"] = "set_cell_value";
    StepType["BulkOldRename"] = "bulk_old_rename";
    StepType["ExcelImport"] = "excel_import";
    StepType["Graph"] = "graph";
    StepType["GraphDuplicate"] = "graph_duplicate";
    StepType["GraphDelete"] = "graph_delete";
    StepType["GraphRename"] = "graph_rename";
})(StepType || (StepType = {}));
/**
 * The original location of a specific dataframe.
 */
export var DFSource;
(function (DFSource) {
    DFSource["Passed"] = "passed";
    DFSource["Imported"] = "imported";
    DFSource["Pivoted"] = "pivoted";
    DFSource["Merged"] = "merged";
    DFSource["Duplicated"] = "duplicated";
})(DFSource || (DFSource = {}));
// NOTE: these aggregation functions need to be supported
// in mitosheet/steps/pivot.py as well
export var AggregationType;
(function (AggregationType) {
    AggregationType["COUNT"] = "count";
    AggregationType["COUNT_UNIQUE"] = "count unique";
    AggregationType["SUM"] = "sum";
    AggregationType["MEAN"] = "mean";
    AggregationType["MEDIAN"] = "median";
    AggregationType["STD"] = "std";
    AggregationType["MIN"] = "min";
    AggregationType["MAX"] = "max";
})(AggregationType || (AggregationType = {}));
/**
 * The type of data that is in this current Mito analysis.
 *
 * @remark this should be the same as the file in the Python code
 * which is in data_in_mito.py
 */
export var DataTypeInMito;
(function (DataTypeInMito) {
    DataTypeInMito["NONE"] = "none";
    DataTypeInMito["PROVIDED"] = "provided";
    DataTypeInMito["TUTORIAL"] = "tutorial";
    DataTypeInMito["PERSONAL"] = "personal";
})(DataTypeInMito || (DataTypeInMito = {}));
export var FormatType;
(function (FormatType) {
    FormatType["DEFAULT"] = "default";
    FormatType["PLAIN_TEXT"] = "plain text";
    FormatType["PERCENTAGE"] = "percentage";
    FormatType["CURRENCY"] = "currency";
    FormatType["ACCOUNTING"] = "accounting";
    FormatType["ROUND_DECIMALS"] = "round decimals";
    FormatType["K_M_B"] = "k_m_b";
    FormatType["SCIENTIFIC_NOTATION"] = "scientific notation";
})(FormatType || (FormatType = {}));
/*
    ActionEnum is used to identify a specific action.

    Listed in alphabetical order: first by non-spreadsheet functions,
    then by spreadsheet functions
*/
export var ActionEnum;
(function (ActionEnum) {
    ActionEnum["Add_Column"] = "add column";
    ActionEnum["Clear"] = "clear";
    ActionEnum["Change_Dtype"] = "change dtype";
    ActionEnum["Column_Summary"] = "column summary";
    ActionEnum["Delete_Column"] = "delete column";
    ActionEnum["Delete_Sheet"] = "delete sheet";
    ActionEnum["Drop_Duplicates"] = "drop duplicates";
    ActionEnum["Duplicate_Sheet"] = "duplicate sheet";
    ActionEnum["Docs"] = "docs";
    ActionEnum["Export"] = "export";
    ActionEnum["Filter"] = "filter";
    ActionEnum["Format"] = "format";
    ActionEnum["Fullscreen"] = "fullscreen";
    ActionEnum["Graph"] = "graph";
    ActionEnum["Help"] = "help";
    ActionEnum["Import"] = "import";
    ActionEnum["Merge"] = "merge";
    ActionEnum["Concat_Sheets"] = "concat_sheets";
    ActionEnum["Pivot"] = "pivot";
    ActionEnum["Redo"] = "redo";
    ActionEnum["Rename_Column"] = "rename column";
    ActionEnum["Rename_Sheet"] = "rename sheet";
    ActionEnum["See_All_Functionality"] = "see all functionality";
    //Search = 'search',
    ActionEnum["Set_Cell_Value"] = "set cell value";
    ActionEnum["Set_Column_Formula"] = "set column formula";
    ActionEnum["Sort"] = "sort";
    ActionEnum["Steps"] = "steps";
    ActionEnum["Undo"] = "undo";
    ActionEnum["Unique_Values"] = "unique values";
    /* Spreadsheet Formulas Section */
    ActionEnum["ABS"] = "abs";
    ActionEnum["AND"] = "and";
    ActionEnum["AVG"] = "avg";
    ActionEnum["BOOL"] = "bool";
    ActionEnum["CLEAN"] = "clean";
    ActionEnum["CONCAT"] = "concat";
    ActionEnum["CORR"] = "corr";
    ActionEnum["DATEVALUE"] = "datevalue";
    ActionEnum["DAY"] = "day";
    ActionEnum["ENDOFBUSINESSMONTH"] = "endofbusinessmonth";
    ActionEnum["ENDOFMONTH"] = "endofmonth";
    ActionEnum["EXP"] = "exp";
    ActionEnum["FILLNAN"] = "fillnan";
    ActionEnum["FIND"] = "find";
    ActionEnum["HOUR"] = "hour";
    ActionEnum["IF"] = "if";
    ActionEnum["KURT"] = "kurt";
    ActionEnum["LEFT"] = "left";
    ActionEnum["LEN"] = "len";
    ActionEnum["LOWER"] = "lower";
    ActionEnum["MAX"] = "max";
    ActionEnum["MID"] = "mid";
    ActionEnum["MIN"] = "min";
    ActionEnum["MINUTE"] = "minute";
    ActionEnum["MONTH"] = "month";
    ActionEnum["MULTIPLY"] = "multiply";
    ActionEnum["OR"] = "or";
    ActionEnum["POWER"] = "power";
    ActionEnum["PROPER"] = "proper";
    ActionEnum["QUARTER"] = "quarter";
    ActionEnum["RIGHT"] = "right";
    ActionEnum["ROUND"] = "round";
    ActionEnum["SECOND"] = "second";
    ActionEnum["SKEW"] = "skew";
    ActionEnum["STARTOFBUSINESSMONTH"] = "startofbusinessmonth";
    ActionEnum["STARTOFMONTH"] = "startofmonth";
    ActionEnum["STRIPTIMETOMINUTES"] = "striptimetominutes";
    ActionEnum["STRIPTIMETOHOURS"] = "striptimetohours";
    ActionEnum["STRIPTIMETODAYS"] = "striptimetodays";
    ActionEnum["STRIPTIMETOMONTHS"] = "striptimetomonths";
    ActionEnum["STRIPTIMETOYEARS"] = "striptimetoyears";
    ActionEnum["SUBSTITUTE"] = "substitute";
    ActionEnum["SUM"] = "sum";
    ActionEnum["TEXT"] = "text";
    ActionEnum["TRIM"] = "trim";
    ActionEnum["TYPE"] = "type";
    ActionEnum["UPPER"] = "upper";
    ActionEnum["VALUE"] = "value";
    ActionEnum["VAR"] = "var";
    ActionEnum["WEEK"] = "week";
    ActionEnum["WEEEKDAY"] = "weekday";
    ActionEnum["YEAR"] = "year";
})(ActionEnum || (ActionEnum = {}));
export var GraphSidebarTab;
(function (GraphSidebarTab) {
    GraphSidebarTab["Setup"] = "setup";
    GraphSidebarTab["Style"] = "style";
    GraphSidebarTab["Export"] = "export";
})(GraphSidebarTab || (GraphSidebarTab = {}));
//# sourceMappingURL=types.js.map