// Copyright (c) Mito
import React, { useState } from 'react';
import Dropdown from './Dropdown';
//import { getWidthAsNumber, Width } from './sizes.d';
import SelectDropdownIcon from '../icons/SelectDropdownIcon';
import { classNames } from '../../utils/classNames';
// import css
import '../../../css/elements/Select.css';
import '../../../css/elements/Dropdown.css';
/**
 * The Select component. If open, the select dropdown automatically
 * closes when the user clicks.
 */
const Select = (props) => {
    const [displayDropdown, setDisplayDropdown] = useState(false);
    const width = props.width || 'block';
    const widthClass = `element-width-${width}`;
    const dropdownActiveClass = displayDropdown ? 'select-dropdown-active' : '';
    /*
        To get the value to display, we first see if any of the dropdown items
        have ids, and then take the title of the id that matches the value.

        If not, we just display the value that is passed.
    */
    let displayValue = props.value;
    const children = React.Children.map((props.children), (child) => {
        const { id, title } = child.props;
        // If an id is provided, we set that as the value, and otherwise we use the title
        if (id === props.value) {
            displayValue = title;
        }
        // If ids are given, we also use them as the value that we call with the onChange 
        // with - allowing you to store a different value than you display
        const valueForOnChange = id !== undefined ? id : title;
        /*
            If onChange function was provided, set it as the onClick property of the child
            Sometimes the onChange is not provided to the select because its handled by the DropdownItems themselves.

            In particular, we do this when the dropdownItem that is selected is not easily identifiable by a single string
            because selects return a string identifier for what was selected.
        */
        const onChangeFunc = props.onChange;
        if (onChangeFunc === undefined) {
            return child;
        }
        else {
            const finalChild = React.cloneElement(child, {
                onClick: () => {
                    onChangeFunc(valueForOnChange);
                }
            });
            return finalChild;
        }
    });
    return (React.createElement("div", { className: classNames('select-container', 'text-body-2', widthClass, dropdownActiveClass, { 'select-disabled': props.disabled }), onClick: () => {
            // If the select is disabled, then don't do anything
            if (props.disabled) {
                return;
            }
            setDisplayDropdown((prevDisplayDropdown) => {
                /*
                    Only change the visibility of the dropdown if the button is
                    not already open because the dropdown handles closing itself
                */
                if (!prevDisplayDropdown) {
                    return true;
                }
                return prevDisplayDropdown;
            });
        } },
        React.createElement("p", { className: 'select-text' }, displayValue),
        React.createElement("div", { className: 'select-dropdown-icon-container' },
            React.createElement(SelectDropdownIcon, { purpleOrDarkOrWhite: 'white' })),
        displayDropdown &&
            React.createElement(Dropdown, { closeDropdown: () => setDisplayDropdown(false), searchable: props.searchable, width: props.dropdownWidth }, children)));
};
export default Select;
//# sourceMappingURL=Select.js.map