"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApi = exports.CorsHttpMethod = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const route_1 = require("./route");
const stage_1 = require("./stage");
const vpc_link_1 = require("./vpc-link");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
const base_1 = require("../common/base");
/**
 * Supported CORS HTTP methods
 */
var CorsHttpMethod;
(function (CorsHttpMethod) {
    /** HTTP ANY */
    CorsHttpMethod["ANY"] = "*";
    /** HTTP DELETE */
    CorsHttpMethod["DELETE"] = "DELETE";
    /** HTTP GET */
    CorsHttpMethod["GET"] = "GET";
    /** HTTP HEAD */
    CorsHttpMethod["HEAD"] = "HEAD";
    /** HTTP OPTIONS */
    CorsHttpMethod["OPTIONS"] = "OPTIONS";
    /** HTTP PATCH */
    CorsHttpMethod["PATCH"] = "PATCH";
    /** HTTP POST */
    CorsHttpMethod["POST"] = "POST";
    /** HTTP PUT */
    CorsHttpMethod["PUT"] = "PUT";
})(CorsHttpMethod || (exports.CorsHttpMethod = CorsHttpMethod = {}));
class HttpApiBase extends base_1.ApiBase {
    constructor() {
        super(...arguments);
        this.vpcLinks = {};
    }
    metricClientError(props) {
        return this.metric('4xx', { statistic: 'Sum', ...props });
    }
    metricServerError(props) {
        return this.metric('5xx', { statistic: 'Sum', ...props });
    }
    metricDataProcessed(props) {
        return this.metric('DataProcessed', { statistic: 'Sum', ...props });
    }
    metricCount(props) {
        return this.metric('Count', { statistic: 'SampleCount', ...props });
    }
    metricIntegrationLatency(props) {
        return this.metric('IntegrationLatency', props);
    }
    metricLatency(props) {
        return this.metric('Latency', props);
    }
    addVpcLink(options) {
        const { vpcId } = options.vpc;
        if (vpcId in this.vpcLinks) {
            return this.vpcLinks[vpcId];
        }
        const count = Object.keys(this.vpcLinks).length + 1;
        const vpcLink = new vpc_link_1.VpcLink(this, `VpcLink-${count}`, options);
        this.vpcLinks[vpcId] = vpcLink;
        return vpcLink;
    }
}
/**
 * Create a new API Gateway HTTP API endpoint.
 * @resource AWS::ApiGatewayV2::Api
 */
class HttpApi extends HttpApiBase {
    /**
     * Import an existing HTTP API into this CDK app.
     */
    static fromHttpApiAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpApiAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromHttpApiAttributes);
            }
            throw error;
        }
        class Import extends HttpApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.httpApiId;
                this.httpApiId = attrs.httpApiId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported HttpApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpApiProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpApi);
            }
            throw error;
        }
        this.httpApiName = props?.apiName ?? id;
        this.disableExecuteApiEndpoint = props?.disableExecuteApiEndpoint;
        let corsConfiguration;
        if (props?.corsPreflight) {
            const cors = props.corsPreflight;
            if (cors.allowOrigins && cors.allowOrigins.includes('*') && cors.allowCredentials) {
                throw new Error("CORS preflight - allowCredentials is not supported when allowOrigin is '*'");
            }
            const { allowCredentials, allowHeaders, allowMethods, allowOrigins, exposeHeaders, maxAge, } = props.corsPreflight;
            corsConfiguration = {
                allowCredentials,
                allowHeaders,
                allowMethods,
                allowOrigins,
                exposeHeaders,
                maxAge: maxAge?.toSeconds(),
            };
        }
        const apiProps = {
            name: this.httpApiName,
            protocolType: 'HTTP',
            corsConfiguration,
            description: props?.description,
            disableExecuteApiEndpoint: this.disableExecuteApiEndpoint,
        };
        const resource = new aws_apigatewayv2_1.CfnApi(this, 'Resource', apiProps);
        this.apiId = resource.ref;
        this.httpApiId = resource.ref;
        this._apiEndpoint = resource.attrApiEndpoint;
        this.defaultAuthorizer = props?.defaultAuthorizer;
        this.defaultAuthorizationScopes = props?.defaultAuthorizationScopes;
        if (props?.defaultIntegration) {
            new route_1.HttpRoute(this, 'DefaultRoute', {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.DEFAULT,
                integration: props.defaultIntegration,
                authorizer: props.defaultAuthorizer,
                authorizationScopes: props.defaultAuthorizationScopes,
            });
        }
        if (props?.createDefaultStage === undefined || props.createDefaultStage === true) {
            this.defaultStage = new stage_1.HttpStage(this, 'DefaultStage', {
                httpApi: this,
                autoDeploy: true,
                domainMapping: props?.defaultDomainMapping,
            });
            // to ensure the domain is ready before creating the default stage
            if (props?.defaultDomainMapping) {
                this.defaultStage.node.addDependency(props.defaultDomainMapping.domainName);
            }
        }
        if (props?.createDefaultStage === false && props.defaultDomainMapping) {
            throw new Error('defaultDomainMapping not supported with createDefaultStage disabled');
        }
    }
    /**
     * Get the default endpoint for this API.
     */
    get apiEndpoint() {
        if (this.disableExecuteApiEndpoint) {
            throw new Error('apiEndpoint is not accessible when disableExecuteApiEndpoint is set to true.');
        }
        return this._apiEndpoint;
    }
    /**
     * Get the URL to the default stage of this API.
     * Returns `undefined` if `createDefaultStage` is unset.
     */
    get url() {
        return this.defaultStage ? this.defaultStage.url : undefined;
    }
    /**
     * Add a new stage.
     */
    addStage(id, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_HttpStageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addStage);
            }
            throw error;
        }
        const stage = new stage_1.HttpStage(this, id, {
            httpApi: this,
            ...options,
        });
        return stage;
    }
    /**
     * Add multiple routes that uses the same configuration. The routes all go to the same path, but for different
     * methods.
     */
    addRoutes(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_AddRoutesOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addRoutes);
            }
            throw error;
        }
        const methods = options.methods ?? [route_1.HttpMethod.ANY];
        return methods.map((method) => {
            const authorizationScopes = options.authorizationScopes ?? this.defaultAuthorizationScopes;
            return new route_1.HttpRoute(this, `${method}${options.path}`, {
                httpApi: this,
                routeKey: route_1.HttpRouteKey.with(options.path, method),
                integration: options.integration,
                authorizer: options.authorizer ?? this.defaultAuthorizer,
                authorizationScopes,
            });
        });
    }
}
exports.HttpApi = HttpApi;
_a = JSII_RTTI_SYMBOL_1;
HttpApi[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.HttpApi", version: "2.108.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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