"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainName = exports.EndpointType = exports.SecurityPolicy = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("aws-cdk-lib/core");
const aws_apigatewayv2_1 = require("aws-cdk-lib/aws-apigatewayv2");
/**
 * The minimum version of the SSL protocol that you want API Gateway to use for HTTPS connections.
 */
var SecurityPolicy;
(function (SecurityPolicy) {
    /** Cipher suite TLS 1.0 */
    SecurityPolicy["TLS_1_0"] = "TLS_1_0";
    /** Cipher suite TLS 1.2 */
    SecurityPolicy["TLS_1_2"] = "TLS_1_2";
})(SecurityPolicy || (exports.SecurityPolicy = SecurityPolicy = {}));
/**
 * Endpoint type for a domain name.
 */
var EndpointType;
(function (EndpointType) {
    /**
     * For an edge-optimized custom domain name.
     */
    EndpointType["EDGE"] = "EDGE";
    /**
     * For a regional custom domain name.
     */
    EndpointType["REGIONAL"] = "REGIONAL";
})(EndpointType || (exports.EndpointType = EndpointType = {}));
/**
 * Custom domain resource for the API
 */
class DomainName extends core_1.Resource {
    /**
     * Import from attributes
     */
    static fromDomainNameAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_DomainNameAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromDomainNameAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.regionalDomainName = attrs.regionalDomainName;
                this.regionalHostedZoneId = attrs.regionalHostedZoneId;
                this.name = attrs.name;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        this.domainNameConfigurations = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_DomainNameProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DomainName);
            }
            throw error;
        }
        if (props.domainName === '') {
            throw new Error('empty string for domainName not allowed');
        }
        // validation for ownership certificate
        if (props.ownershipCertificate && !props.mtls) {
            throw new Error('ownership certificate can only be used with mtls domains');
        }
        const mtlsConfig = this.configureMTLS(props.mtls);
        const domainNameProps = {
            domainName: props.domainName,
            domainNameConfigurations: core_1.Lazy.any({ produce: () => this.domainNameConfigurations }),
            mutualTlsAuthentication: mtlsConfig,
        };
        const resource = new aws_apigatewayv2_1.CfnDomainName(this, 'Resource', domainNameProps);
        this.name = resource.ref;
        this.regionalDomainName = core_1.Token.asString(resource.getAtt('RegionalDomainName'));
        this.regionalHostedZoneId = core_1.Token.asString(resource.getAtt('RegionalHostedZoneId'));
        if (props.certificate) {
            this.addEndpoint(props);
        }
    }
    configureMTLS(mtlsConfig) {
        if (!mtlsConfig)
            return undefined;
        return {
            truststoreUri: mtlsConfig.bucket.s3UrlForObject(mtlsConfig.key),
            truststoreVersion: mtlsConfig.version,
        };
    }
    /**
     * Adds an endpoint to a domain name.
     * @param options domain name endpoint properties to be set
     */
    addEndpoint(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_alpha_EndpointOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addEndpoint);
            }
            throw error;
        }
        const domainNameConfig = {
            certificateArn: options.certificate.certificateArn,
            certificateName: options.certificateName,
            endpointType: options.endpointType ? options.endpointType?.toString() : 'REGIONAL',
            ownershipVerificationCertificateArn: options.ownershipCertificate?.certificateArn,
            securityPolicy: options.securityPolicy?.toString(),
        };
        this.validateEndpointType(domainNameConfig.endpointType);
        this.domainNameConfigurations.push(domainNameConfig);
    }
    // validates that the new domain name configuration has a unique endpoint
    validateEndpointType(endpointType) {
        for (let config of this.domainNameConfigurations) {
            if (endpointType && endpointType == config.endpointType) {
                throw new Error(`an endpoint with type ${endpointType} already exists`);
            }
        }
    }
}
exports.DomainName = DomainName;
_a = JSII_RTTI_SYMBOL_1;
DomainName[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-alpha.DomainName", version: "2.108.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZG9tYWluLW5hbWUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJkb21haW4tbmFtZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFFQSwyQ0FBb0U7QUFFcEUsbUVBQWlGO0FBRWpGOztHQUVHO0FBQ0gsSUFBWSxjQU1YO0FBTkQsV0FBWSxjQUFjO0lBQ3hCLDJCQUEyQjtJQUMzQixxQ0FBbUIsQ0FBQTtJQUVuQiwyQkFBMkI7SUFDM0IscUNBQW1CLENBQUE7QUFDckIsQ0FBQyxFQU5XLGNBQWMsOEJBQWQsY0FBYyxRQU16QjtBQUVEOztHQUVHO0FBQ0gsSUFBWSxZQVNYO0FBVEQsV0FBWSxZQUFZO0lBQ3RCOztPQUVHO0lBQ0gsNkJBQWEsQ0FBQTtJQUNiOztPQUVHO0lBQ0gscUNBQXFCLENBQUE7QUFDdkIsQ0FBQyxFQVRXLFlBQVksNEJBQVosWUFBWSxRQVN2QjtBQXdIRDs7R0FFRztBQUNILE1BQWEsVUFBVyxTQUFRLGVBQVE7SUFDdEM7O09BRUc7SUFDSSxNQUFNLENBQUMsd0JBQXdCLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBMkI7Ozs7Ozs7Ozs7UUFDOUYsTUFBTSxNQUFPLFNBQVEsZUFBUTtZQUE3Qjs7Z0JBQ2tCLHVCQUFrQixHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQztnQkFDOUMseUJBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO2dCQUNsRCxTQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztZQUNwQyxDQUFDO1NBQUE7UUFDRCxPQUFPLElBQUksTUFBTSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztLQUM5QjtJQU9ELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBc0I7UUFDOUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUhGLDZCQUF3QixHQUFvRCxFQUFFLENBQUM7Ozs7OzsrQ0FoQnJGLFVBQVU7Ozs7UUFxQm5CLElBQUksS0FBSyxDQUFDLFVBQVUsS0FBSyxFQUFFLEVBQUU7WUFDM0IsTUFBTSxJQUFJLEtBQUssQ0FBQyx5Q0FBeUMsQ0FBQyxDQUFDO1NBQzVEO1FBRUQsdUNBQXVDO1FBQ3ZDLElBQUksS0FBSyxDQUFDLG9CQUFvQixJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRTtZQUM3QyxNQUFNLElBQUksS0FBSyxDQUFDLDBEQUEwRCxDQUFDLENBQUM7U0FDN0U7UUFFRCxNQUFNLFVBQVUsR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNsRCxNQUFNLGVBQWUsR0FBdUI7WUFDMUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLHdCQUF3QixFQUFFLFdBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLHdCQUF3QixFQUFFLENBQUM7WUFDcEYsdUJBQXVCLEVBQUUsVUFBVTtTQUNwQyxDQUFDO1FBQ0YsTUFBTSxRQUFRLEdBQUcsSUFBSSxnQ0FBYSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUUsZUFBZSxDQUFDLENBQUM7UUFDdEUsSUFBSSxDQUFDLElBQUksR0FBRyxRQUFRLENBQUMsR0FBRyxDQUFDO1FBQ3pCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxZQUFLLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO1FBQ2hGLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxZQUFLLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxDQUFDO1FBRXBGLElBQUksS0FBSyxDQUFDLFdBQVcsRUFBRTtZQUNyQixJQUFJLENBQUMsV0FBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQ3pCO0tBQ0Y7SUFFTyxhQUFhLENBQUMsVUFBdUI7UUFDM0MsSUFBSSxDQUFDLFVBQVU7WUFBRSxPQUFPLFNBQVMsQ0FBQztRQUNsQyxPQUFPO1lBQ0wsYUFBYSxFQUFFLFVBQVUsQ0FBQyxNQUFNLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUM7WUFDL0QsaUJBQWlCLEVBQUUsVUFBVSxDQUFDLE9BQU87U0FDdEMsQ0FBQztLQUNIO0lBRUQ7OztPQUdHO0lBQ0ksV0FBVyxDQUFDLE9BQXdCOzs7Ozs7Ozs7O1FBQ3pDLE1BQU0sZ0JBQWdCLEdBQWtEO1lBQ3RFLGNBQWMsRUFBRSxPQUFPLENBQUMsV0FBVyxDQUFDLGNBQWM7WUFDbEQsZUFBZSxFQUFFLE9BQU8sQ0FBQyxlQUFlO1lBQ3hDLFlBQVksRUFBRSxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLFFBQVEsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVO1lBQ2xGLG1DQUFtQyxFQUFFLE9BQU8sQ0FBQyxvQkFBb0IsRUFBRSxjQUFjO1lBQ2pGLGNBQWMsRUFBRSxPQUFPLENBQUMsY0FBYyxFQUFFLFFBQVEsRUFBRTtTQUNuRCxDQUFDO1FBRUYsSUFBSSxDQUFDLG9CQUFvQixDQUFDLGdCQUFnQixDQUFDLFlBQVksQ0FBQyxDQUFDO1FBQ3pELElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztLQUN0RDtJQUVELHlFQUF5RTtJQUNqRSxvQkFBb0IsQ0FBQyxZQUFnQztRQUMzRCxLQUFLLElBQUksTUFBTSxJQUFJLElBQUksQ0FBQyx3QkFBd0IsRUFBRTtZQUNoRCxJQUFJLFlBQVksSUFBSSxZQUFZLElBQUksTUFBTSxDQUFDLFlBQVksRUFBRTtnQkFDdkQsTUFBTSxJQUFJLEtBQUssQ0FBQyx5QkFBeUIsWUFBWSxpQkFBaUIsQ0FBQyxDQUFDO2FBQ3pFO1NBQ0Y7S0FDRjs7QUE5RUgsZ0NBK0VDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSUNlcnRpZmljYXRlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWNlcnRpZmljYXRlbWFuYWdlcic7XG5pbXBvcnQgeyBJQnVja2V0IH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLXMzJztcbmltcG9ydCB7IElSZXNvdXJjZSwgTGF6eSwgUmVzb3VyY2UsIFRva2VuIH0gZnJvbSAnYXdzLWNkay1saWIvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmbkRvbWFpbk5hbWUsIENmbkRvbWFpbk5hbWVQcm9wcyB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hcGlnYXRld2F5djInO1xuXG4vKipcbiAqIFRoZSBtaW5pbXVtIHZlcnNpb24gb2YgdGhlIFNTTCBwcm90b2NvbCB0aGF0IHlvdSB3YW50IEFQSSBHYXRld2F5IHRvIHVzZSBmb3IgSFRUUFMgY29ubmVjdGlvbnMuXG4gKi9cbmV4cG9ydCBlbnVtIFNlY3VyaXR5UG9saWN5IHtcbiAgLyoqIENpcGhlciBzdWl0ZSBUTFMgMS4wICovXG4gIFRMU18xXzAgPSAnVExTXzFfMCcsXG5cbiAgLyoqIENpcGhlciBzdWl0ZSBUTFMgMS4yICovXG4gIFRMU18xXzIgPSAnVExTXzFfMicsXG59XG5cbi8qKlxuICogRW5kcG9pbnQgdHlwZSBmb3IgYSBkb21haW4gbmFtZS5cbiAqL1xuZXhwb3J0IGVudW0gRW5kcG9pbnRUeXBlIHtcbiAgLyoqXG4gICAqIEZvciBhbiBlZGdlLW9wdGltaXplZCBjdXN0b20gZG9tYWluIG5hbWUuXG4gICAqL1xuICBFREdFID0gJ0VER0UnLFxuICAvKipcbiAgICogRm9yIGEgcmVnaW9uYWwgY3VzdG9tIGRvbWFpbiBuYW1lLlxuICAgKi9cbiAgUkVHSU9OQUwgPSAnUkVHSU9OQUwnLFxufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgYW4gQVBJR2F0ZXdheVYyIERvbWFpbk5hbWVcbiAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWFwaWdhdGV3YXl2Mi1kb21haW5uYW1lLmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJRG9tYWluTmFtZSBleHRlbmRzIElSZXNvdXJjZSB7XG4gIC8qKlxuICAgKiBUaGUgY3VzdG9tIGRvbWFpbiBuYW1lXG4gICAqIEBhdHRyaWJ1dGVcbiAgICovXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIGRvbWFpbiBuYW1lIGFzc29jaWF0ZWQgd2l0aCB0aGUgcmVnaW9uYWwgZW5kcG9pbnQgZm9yIHRoaXMgY3VzdG9tIGRvbWFpbiBuYW1lLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSByZWdpb25hbERvbWFpbk5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHJlZ2lvbi1zcGVjaWZpYyBBbWF6b24gUm91dGUgNTMgSG9zdGVkIFpvbmUgSUQgb2YgdGhlIHJlZ2lvbmFsIGVuZHBvaW50LlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSByZWdpb25hbEhvc3RlZFpvbmVJZDogc3RyaW5nO1xufVxuXG4vKipcbiAqIGN1c3RvbSBkb21haW4gbmFtZSBhdHRyaWJ1dGVzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRG9tYWluTmFtZUF0dHJpYnV0ZXMge1xuICAvKipcbiAgICogZG9tYWluIG5hbWUgc3RyaW5nXG4gICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBkb21haW4gbmFtZSBhc3NvY2lhdGVkIHdpdGggdGhlIHJlZ2lvbmFsIGVuZHBvaW50IGZvciB0aGlzIGN1c3RvbSBkb21haW4gbmFtZS5cbiAgICovXG4gIHJlYWRvbmx5IHJlZ2lvbmFsRG9tYWluTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcmVnaW9uLXNwZWNpZmljIEFtYXpvbiBSb3V0ZSA1MyBIb3N0ZWQgWm9uZSBJRCBvZiB0aGUgcmVnaW9uYWwgZW5kcG9pbnQuXG4gICAqL1xuICByZWFkb25seSByZWdpb25hbEhvc3RlZFpvbmVJZDogc3RyaW5nO1xufVxuXG4vKipcbiAqIHByb3BlcnRpZXMgdXNlZCBmb3IgY3JlYXRpbmcgdGhlIERvbWFpbk5hbWVcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEb21haW5OYW1lUHJvcHMgZXh0ZW5kcyBFbmRwb2ludE9wdGlvbnMge1xuICAvKipcbiAgICogVGhlIGN1c3RvbSBkb21haW4gbmFtZVxuICAgKi9cbiAgcmVhZG9ubHkgZG9tYWluTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgbXV0dWFsIFRMUyBhdXRoZW50aWNhdGlvbiBjb25maWd1cmF0aW9uIGZvciBhIGN1c3RvbSBkb21haW4gbmFtZS5cbiAgICogQGRlZmF1bHQgLSBtVExTIGlzIG5vdCBjb25maWd1cmVkLlxuICAgKi9cbiAgcmVhZG9ubHkgbXRscz86IE1UTFNDb25maWc7XG59XG5cbi8qKlxuICogcHJvcGVydGllcyBmb3IgY3JlYXRpbmcgYSBkb21haW4gbmFtZSBlbmRwb2ludFxuICovXG5leHBvcnQgaW50ZXJmYWNlIEVuZHBvaW50T3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgQUNNIGNlcnRpZmljYXRlIGZvciB0aGlzIGRvbWFpbiBuYW1lLlxuICAgKiBDZXJ0aWZpY2F0ZSBjYW4gYmUgYm90aCBBQ00gaXNzdWVkIG9yIGltcG9ydGVkLlxuICAgKi9cbiAgcmVhZG9ubHkgY2VydGlmaWNhdGU6IElDZXJ0aWZpY2F0ZTtcblxuICAvKipcbiAgICogVGhlIHVzZXItZnJpZW5kbHkgbmFtZSBvZiB0aGUgY2VydGlmaWNhdGUgdGhhdCB3aWxsIGJlIHVzZWQgYnkgdGhlIGVuZHBvaW50IGZvciB0aGlzIGRvbWFpbiBuYW1lLlxuICAgKiBAZGVmYXVsdCAtIE5vIGZyaWVuZGx5IGNlcnRpZmljYXRlIG5hbWVcbiAgICovXG4gIHJlYWRvbmx5IGNlcnRpZmljYXRlTmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHR5cGUgb2YgZW5kcG9pbnQgZm9yIHRoaXMgRG9tYWluTmFtZS5cbiAgICogQGRlZmF1bHQgRW5kcG9pbnRUeXBlLlJFR0lPTkFMXG4gICAqL1xuICByZWFkb25seSBlbmRwb2ludFR5cGU/OiBFbmRwb2ludFR5cGU7XG5cbiAgLyoqXG4gICAqIFRoZSBUcmFuc3BvcnQgTGF5ZXIgU2VjdXJpdHkgKFRMUykgdmVyc2lvbiArIGNpcGhlciBzdWl0ZSBmb3IgdGhpcyBkb21haW4gbmFtZS5cbiAgICogQGRlZmF1bHQgU2VjdXJpdHlQb2xpY3kuVExTXzFfMlxuICAgKi9cbiAgcmVhZG9ubHkgc2VjdXJpdHlQb2xpY3k/OiBTZWN1cml0eVBvbGljeTtcblxuICAvKipcbiAgICogQSBwdWJsaWMgY2VydGlmaWNhdGUgaXNzdWVkIGJ5IEFDTSB0byB2YWxpZGF0ZSB0aGF0IHlvdSBvd24gYSBjdXN0b20gZG9tYWluLiBUaGlzIHBhcmFtZXRlciBpcyByZXF1aXJlZFxuICAgKiBvbmx5IHdoZW4geW91IGNvbmZpZ3VyZSBtdXR1YWwgVExTIGF1dGhlbnRpY2F0aW9uIGFuZCB5b3Ugc3BlY2lmeSBhbiBBQ00gaW1wb3J0ZWQgb3IgcHJpdmF0ZSBDQSBjZXJ0aWZpY2F0ZVxuICAgKiBmb3IgYGNlcnRpZmljYXRlYC4gVGhlIG93bmVyc2hpcCBjZXJ0aWZpY2F0ZSB2YWxpZGF0ZXMgdGhhdCB5b3UgaGF2ZSBwZXJtaXNzaW9ucyB0byB1c2UgdGhlIGRvbWFpbiBuYW1lLlxuICAgKiBAZGVmYXVsdCAtIG9ubHkgcmVxdWlyZWQgd2hlbiBjb25maWd1cmluZyBtVExTXG4gICAqL1xuICByZWFkb25seSBvd25lcnNoaXBDZXJ0aWZpY2F0ZT86IElDZXJ0aWZpY2F0ZTtcbn1cblxuLyoqXG4gKiBUaGUgbVRMUyBhdXRoZW50aWNhdGlvbiBjb25maWd1cmF0aW9uIGZvciBhIGN1c3RvbSBkb21haW4gbmFtZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBNVExTQ29uZmlnIHtcbiAgLyoqXG4gICAqIFRoZSBidWNrZXQgdGhhdCB0aGUgdHJ1c3Qgc3RvcmUgaXMgaG9zdGVkIGluLlxuICAgKi9cbiAgcmVhZG9ubHkgYnVja2V0OiBJQnVja2V0O1xuICAvKipcbiAgICogVGhlIGtleSBpbiBTMyB0byBsb29rIGF0IGZvciB0aGUgdHJ1c3Qgc3RvcmVcbiAgICovXG4gIHJlYWRvbmx5IGtleTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiAgVGhlIHZlcnNpb24gb2YgdGhlIFMzIG9iamVjdCB0aGF0IGNvbnRhaW5zIHlvdXIgdHJ1c3RzdG9yZS5cbiAgICogIFRvIHNwZWNpZnkgYSB2ZXJzaW9uLCB5b3UgbXVzdCBoYXZlIHZlcnNpb25pbmcgZW5hYmxlZCBmb3IgdGhlIFMzIGJ1Y2tldC5cbiAgICogIEBkZWZhdWx0IC0gbGF0ZXN0IHZlcnNpb25cbiAgICovXG4gIHJlYWRvbmx5IHZlcnNpb24/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogQ3VzdG9tIGRvbWFpbiByZXNvdXJjZSBmb3IgdGhlIEFQSVxuICovXG5leHBvcnQgY2xhc3MgRG9tYWluTmFtZSBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSURvbWFpbk5hbWUge1xuICAvKipcbiAgICogSW1wb3J0IGZyb20gYXR0cmlidXRlc1xuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tRG9tYWluTmFtZUF0dHJpYnV0ZXMoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYXR0cnM6IERvbWFpbk5hbWVBdHRyaWJ1dGVzKTogSURvbWFpbk5hbWUge1xuICAgIGNsYXNzIEltcG9ydCBleHRlbmRzIFJlc291cmNlIGltcGxlbWVudHMgSURvbWFpbk5hbWUge1xuICAgICAgcHVibGljIHJlYWRvbmx5IHJlZ2lvbmFsRG9tYWluTmFtZSA9IGF0dHJzLnJlZ2lvbmFsRG9tYWluTmFtZTtcbiAgICAgIHB1YmxpYyByZWFkb25seSByZWdpb25hbEhvc3RlZFpvbmVJZCA9IGF0dHJzLnJlZ2lvbmFsSG9zdGVkWm9uZUlkO1xuICAgICAgcHVibGljIHJlYWRvbmx5IG5hbWUgPSBhdHRycy5uYW1lO1xuICAgIH1cbiAgICByZXR1cm4gbmV3IEltcG9ydChzY29wZSwgaWQpO1xuICB9XG5cbiAgcHVibGljIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHJlZ2lvbmFsRG9tYWluTmFtZTogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgcmVnaW9uYWxIb3N0ZWRab25lSWQ6IHN0cmluZztcbiAgcHJpdmF0ZSByZWFkb25seSBkb21haW5OYW1lQ29uZmlndXJhdGlvbnM6IENmbkRvbWFpbk5hbWUuRG9tYWluTmFtZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eVtdID0gW107XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERvbWFpbk5hbWVQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBpZiAocHJvcHMuZG9tYWluTmFtZSA9PT0gJycpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignZW1wdHkgc3RyaW5nIGZvciBkb21haW5OYW1lIG5vdCBhbGxvd2VkJyk7XG4gICAgfVxuXG4gICAgLy8gdmFsaWRhdGlvbiBmb3Igb3duZXJzaGlwIGNlcnRpZmljYXRlXG4gICAgaWYgKHByb3BzLm93bmVyc2hpcENlcnRpZmljYXRlICYmICFwcm9wcy5tdGxzKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ293bmVyc2hpcCBjZXJ0aWZpY2F0ZSBjYW4gb25seSBiZSB1c2VkIHdpdGggbXRscyBkb21haW5zJyk7XG4gICAgfVxuXG4gICAgY29uc3QgbXRsc0NvbmZpZyA9IHRoaXMuY29uZmlndXJlTVRMUyhwcm9wcy5tdGxzKTtcbiAgICBjb25zdCBkb21haW5OYW1lUHJvcHM6IENmbkRvbWFpbk5hbWVQcm9wcyA9IHtcbiAgICAgIGRvbWFpbk5hbWU6IHByb3BzLmRvbWFpbk5hbWUsXG4gICAgICBkb21haW5OYW1lQ29uZmlndXJhdGlvbnM6IExhenkuYW55KHsgcHJvZHVjZTogKCkgPT4gdGhpcy5kb21haW5OYW1lQ29uZmlndXJhdGlvbnMgfSksXG4gICAgICBtdXR1YWxUbHNBdXRoZW50aWNhdGlvbjogbXRsc0NvbmZpZyxcbiAgICB9O1xuICAgIGNvbnN0IHJlc291cmNlID0gbmV3IENmbkRvbWFpbk5hbWUodGhpcywgJ1Jlc291cmNlJywgZG9tYWluTmFtZVByb3BzKTtcbiAgICB0aGlzLm5hbWUgPSByZXNvdXJjZS5yZWY7XG4gICAgdGhpcy5yZWdpb25hbERvbWFpbk5hbWUgPSBUb2tlbi5hc1N0cmluZyhyZXNvdXJjZS5nZXRBdHQoJ1JlZ2lvbmFsRG9tYWluTmFtZScpKTtcbiAgICB0aGlzLnJlZ2lvbmFsSG9zdGVkWm9uZUlkID0gVG9rZW4uYXNTdHJpbmcocmVzb3VyY2UuZ2V0QXR0KCdSZWdpb25hbEhvc3RlZFpvbmVJZCcpKTtcblxuICAgIGlmIChwcm9wcy5jZXJ0aWZpY2F0ZSkge1xuICAgICAgdGhpcy5hZGRFbmRwb2ludChwcm9wcyk7XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSBjb25maWd1cmVNVExTKG10bHNDb25maWc/OiBNVExTQ29uZmlnKTogQ2ZuRG9tYWluTmFtZS5NdXR1YWxUbHNBdXRoZW50aWNhdGlvblByb3BlcnR5IHwgdW5kZWZpbmVkIHtcbiAgICBpZiAoIW10bHNDb25maWcpIHJldHVybiB1bmRlZmluZWQ7XG4gICAgcmV0dXJuIHtcbiAgICAgIHRydXN0c3RvcmVVcmk6IG10bHNDb25maWcuYnVja2V0LnMzVXJsRm9yT2JqZWN0KG10bHNDb25maWcua2V5KSxcbiAgICAgIHRydXN0c3RvcmVWZXJzaW9uOiBtdGxzQ29uZmlnLnZlcnNpb24sXG4gICAgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGFuIGVuZHBvaW50IHRvIGEgZG9tYWluIG5hbWUuXG4gICAqIEBwYXJhbSBvcHRpb25zIGRvbWFpbiBuYW1lIGVuZHBvaW50IHByb3BlcnRpZXMgdG8gYmUgc2V0XG4gICAqL1xuICBwdWJsaWMgYWRkRW5kcG9pbnQob3B0aW9uczogRW5kcG9pbnRPcHRpb25zKSA6IHZvaWQge1xuICAgIGNvbnN0IGRvbWFpbk5hbWVDb25maWc6IENmbkRvbWFpbk5hbWUuRG9tYWluTmFtZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eSA9IHtcbiAgICAgIGNlcnRpZmljYXRlQXJuOiBvcHRpb25zLmNlcnRpZmljYXRlLmNlcnRpZmljYXRlQXJuLFxuICAgICAgY2VydGlmaWNhdGVOYW1lOiBvcHRpb25zLmNlcnRpZmljYXRlTmFtZSxcbiAgICAgIGVuZHBvaW50VHlwZTogb3B0aW9ucy5lbmRwb2ludFR5cGUgPyBvcHRpb25zLmVuZHBvaW50VHlwZT8udG9TdHJpbmcoKSA6ICdSRUdJT05BTCcsXG4gICAgICBvd25lcnNoaXBWZXJpZmljYXRpb25DZXJ0aWZpY2F0ZUFybjogb3B0aW9ucy5vd25lcnNoaXBDZXJ0aWZpY2F0ZT8uY2VydGlmaWNhdGVBcm4sXG4gICAgICBzZWN1cml0eVBvbGljeTogb3B0aW9ucy5zZWN1cml0eVBvbGljeT8udG9TdHJpbmcoKSxcbiAgICB9O1xuXG4gICAgdGhpcy52YWxpZGF0ZUVuZHBvaW50VHlwZShkb21haW5OYW1lQ29uZmlnLmVuZHBvaW50VHlwZSk7XG4gICAgdGhpcy5kb21haW5OYW1lQ29uZmlndXJhdGlvbnMucHVzaChkb21haW5OYW1lQ29uZmlnKTtcbiAgfVxuXG4gIC8vIHZhbGlkYXRlcyB0aGF0IHRoZSBuZXcgZG9tYWluIG5hbWUgY29uZmlndXJhdGlvbiBoYXMgYSB1bmlxdWUgZW5kcG9pbnRcbiAgcHJpdmF0ZSB2YWxpZGF0ZUVuZHBvaW50VHlwZShlbmRwb2ludFR5cGU6IHN0cmluZyB8IHVuZGVmaW5lZCkgOiB2b2lkIHtcbiAgICBmb3IgKGxldCBjb25maWcgb2YgdGhpcy5kb21haW5OYW1lQ29uZmlndXJhdGlvbnMpIHtcbiAgICAgIGlmIChlbmRwb2ludFR5cGUgJiYgZW5kcG9pbnRUeXBlID09IGNvbmZpZy5lbmRwb2ludFR5cGUpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBhbiBlbmRwb2ludCB3aXRoIHR5cGUgJHtlbmRwb2ludFR5cGV9IGFscmVhZHkgZXhpc3RzYCk7XG4gICAgICB9XG4gICAgfVxuICB9XG59XG4iXX0=