"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongDataplaneService = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const aws_elasticloadbalancingv2_1 = require("aws-cdk-lib/aws-elasticloadbalancingv2");
class KongDataplaneService extends aws_ecs_1.FargateService {
    constructor(scope, id, props) {
        super(scope, id, props.kongServiceProps);
        const dataPlanePort = 8000;
        const dataPlaneListener = new aws_elasticloadbalancingv2_1.NetworkListener(this, 'KongDataPlaneListener', {
            port: 80,
            protocol: aws_elasticloadbalancingv2_1.Protocol.TCP,
            loadBalancer: props.nlb,
        });
        this.registerLoadBalancerTargets({
            containerName: props.kongServiceProps.taskDefinition.defaultContainer?.containerName ?? '',
            containerPort: dataPlanePort,
            newTargetGroupId: 'kong-data-plane',
            listener: aws_ecs_1.ListenerConfig.networkListener(dataPlaneListener, {
                deregistrationDelay: aws_cdk_lib_1.Duration.seconds(600),
                port: 80,
                healthCheck: {
                    port: dataPlanePort.toString(),
                },
                preserveClientIp: false,
                proxyProtocolV2: false,
                protocol: aws_elasticloadbalancingv2_1.Protocol.TCP,
            }),
        });
        this.connections.allowFrom(aws_ec2_1.Peer.ipv4(this.cluster.vpc.vpcCidrBlock), aws_ec2_1.Port.tcp(dataPlanePort));
        new aws_cdk_lib_1.CfnOutput(this, 'KongDataPlaneDnsName', {
            value: props.nlb.loadBalancerDnsName,
            exportName: 'KongDataPlaneDnsName',
        });
    }
}
exports.KongDataplaneService = KongDataplaneService;
//# sourceMappingURL=data:application/json;base64,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