"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEcsDataPlane = void 0;
const aws_ecs_1 = require("aws-cdk-lib/aws-ecs");
const secretManager = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("constructs");
const kong_dataplane_service_1 = require("./kong-dataplane-service");
const kong_dataplane_taskdefinition_1 = require("./kong-dataplane-taskdefinition");
class KongEcsDataPlane extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let secrets = {};
        if (props.licenseSecret) {
            const licenseSecret = secretManager.Secret.fromSecretNameV2(this, 'KongDPLicense', props.licenseSecret ?? '');
            secrets.KONG_LICENSE_DATA = aws_ecs_1.Secret.fromSecretsManager(licenseSecret, 'license');
        }
        const kongDataPlaneTaskDefinition = new kong_dataplane_taskdefinition_1.KongDataplaneTaskdefinition(scope, 'KongDPTaskDefinition', {
            cluster: props.cluster,
            image: props.image,
            cluster_dns: props.clusterDns,
            telemetry_dns: props.telemeteryDns,
            certificates: props.certificates,
            kongTaskProps: props.kongTaskProps,
            secrets: secrets,
        });
        new kong_dataplane_service_1.KongDataplaneService(scope, 'KongDPFargateService', {
            kongServiceProps: {
                cluster: props.cluster,
                taskDefinition: kongDataPlaneTaskDefinition,
                desiredCount: props.desiredCount,
            },
            nlb: props.nlb,
        });
    }
}
exports.KongEcsDataPlane = KongEcsDataPlane;
//# sourceMappingURL=data:application/json;base64,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