"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KongEks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
// import * as kong_core from '../../kong-core';
const kong_core = require("kong-core");
const index_1 = require("./resources/eks/helm-charts/kong/index");
/**
 * @summary The KongEks class.
 */
class KongEks extends constructs_1.Construct {
    //   public readonly rdsCluster: rds.DatabaseInstance;
    //   public readonly eksCluster: eks.Cluster;
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope, id, props) {
        super(scope, id);
        //TODO : Modularize this further
        // const kong_namespace = 'kong-dp';
        const data_plane_secretskey = new aws_cdk_lib_1.aws_kms.Key(this, 'DPSecretsKey', {
            enableKeyRotation: true,
        });
        // const data_plane_secretskey = new kms.Key(this, 'DataPlaneSecretsKey');
        // const artifactoryBucket = new s3.Bucket(this, 'ArtifactoryBucket');
        const data_plane = new aws_cdk_lib_1.aws_eks.Cluster(this, 'DP', {
            ...props.dataPlaneClusterProps,
            secretsEncryptionKey: data_plane_secretskey,
            defaultCapacity: 0,
            albController: {
                version: aws_cdk_lib_1.aws_eks.AlbControllerVersion.V2_4_1,
            },
        });
        const dp_nodegroup = data_plane.addNodegroupCapacity('DpASG', props.dataPlaneNodeProps);
        dp_nodegroup.role.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonSSMManagedInstanceCore'));
        // new EksNodeHandler(this, 'NodeHandler', {
        //   cluster: data_plane,
        //   nodegroup: dp_nodegroup,
        // });
        // TODO : Make a new construct class for all helm charts
        // new ElastiCacheStack(this, 'KongCache', {
        //   numberofnodegroups: 3,
        //   vpc: data_plane.vpc,
        // });
        const kong_pre_requisites_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongPreReqsStack');
        new kong_core.AwsCertManager(kong_pre_requisites_nested_stack, 'AwsCertManager', {
            cluster: data_plane,
            clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            privateCaArn: props.privateCaArn,
            email: props.emailForCertRenewal,
            hostedZoneName: props.dnsProps.hostedZoneName,
        });
        new kong_core.ExternalDns(kong_pre_requisites_nested_stack, 'ExtDns', {
            cluster: data_plane,
            hostedZoneName: props.dnsProps.hostedZoneName,
        });
        new kong_core.SecretsManager(kong_pre_requisites_nested_stack, 'SecretsCsi', {
            cluster: data_plane,
        });
        //TODO : Error: kong-dp/KongEksDp/KongPreReqsStack/AutoScalar/KarpenterNodeRole should be defined in the scope of the kong-dp stack to prevent circular dependencies
        new kong_core.AutoScalar(this, 'AutoScalar', {
            cluster: data_plane,
            nodegroup: dp_nodegroup,
        });
        new kong_core.MetricsServer(kong_pre_requisites_nested_stack, 'MetricsServer', {
            cluster: data_plane,
        });
        const telemetry_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongTelemetryStack');
        new kong_core.Telemetry(telemetry_nested_stack, 'KongLogging', {
            createPrometheusWorkspace: props.kongTelemetryOptions.createPrometheusWorkspace,
            prometheusEndpoint: props.kongTelemetryOptions.prometheusEndpoint,
            cluster: data_plane,
            namespace: kong_core.Namespace.TELEMETRY,
        });
        telemetry_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
        const kong_data_plane_nested_stack = new aws_cdk_lib_1.NestedStack(this, 'KongDpStack');
        new index_1.KongEksDataPlane(kong_data_plane_nested_stack, 'KongDPHelmInstall', {
            cluster: data_plane,
            namespace: kong_core.Namespace.KONG_DATA_PLANE,
            // nodegroup: dp_nodegroup,
            license_secret_name: props.licenseSecretsName,
            // cacertname: kong_core.Tls.KONG_DP_CERTNAME,
            // clusterIssuerName: kong_core.Tls.KONG_DP_CLUSTER_ISSUER_NAME,
            endpoints: props.dnsProps,
            HelmOptions: props.kongHelmOptions,
        });
        kong_data_plane_nested_stack.node.addDependency(kong_pre_requisites_nested_stack);
    }
}
exports.KongEks = KongEks;
_a = JSII_RTTI_SYMBOL_1;
KongEks[_a] = { fqn: "kong-data-plane.KongEks", version: "3.0.0-dev.5" };
//# sourceMappingURL=data:application/json;base64,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