import { aws_eks } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { DnsProps } from './resources/eks/interfaces/dns-props';
export interface KongEksDataPlaneProps {
    /**
       * @summary Control Plane EKS Cluster properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.ClusterProps.html
       */
    readonly dataPlaneClusterProps: aws_eks.ClusterProps;
    /**
       * @summary Data Plane EKS Cluster properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.ClusterProps.html
       */
    /**
       * @summary Kong Data Plane EKS Nodes properties
       * @see https://docs.aws.amazon.com/cdk/api/latest/docs/@aws-cdk_aws-eks.AutoScalingGroupCapacityOptions.html
       */
    /**
      * @summary Name of the Secret in AWS Secrets Manager
      */
    readonly licenseSecretsName: string;
    readonly dataPlaneNodeProps: aws_eks.NodegroupOptions;
    readonly dnsProps: DnsProps;
    readonly privateCaArn: string;
    readonly kongTelemetryOptions: DataPlaneTelemetryProps;
    readonly kongHelmOptions?: aws_eks.HelmChartOptions;
    readonly emailForCertRenewal: string;
}
export interface DataPlaneTelemetryProps {
    readonly createPrometheusWorkspace: Boolean;
    readonly prometheusEndpoint?: string;
}
/**
 * @summary The KongEks class.
 */
export declare class KongEks extends Construct {
    /**
       * @summary Constructs a new instance of the KongEks class.
       * @param {cdk.App} scope - represents the scope for all the resources.
       * @param {string} id - this is a a scope-unique id.
       * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
       * @since 0.1.0
       * @access public
       */
    constructor(scope: Construct, id: string, props: KongEksDataPlaneProps);
}
