import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
declare module "./topic-base" {
    /**
     * Represents an SNS topic.
     *
     * @stability stable
     */
    interface ITopic {
        /**
         * Return the given named metric for this Topic.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * Metric for the size of messages published through this topic.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricPublishSize(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages published to your Amazon SNS topics.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfMessagesPublished(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages successfully delivered from your Amazon SNS topics to subscribing endpoints.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfNotificationsDelivered(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages that Amazon SNS failed to deliver.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfNotificationsFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages that were rejected by subscription filter policies.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfNotificationsFilteredOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages that were rejected by subscription filter policies because the messages have no attributes.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfNotificationsFilteredOutNoMessageAttributes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages that were rejected by subscription filter policies because the messages' attributes are invalid.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfNotificationsFilteredOutInvalidAttributes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The charges you have accrued since the start of the current calendar month for sending SMS messages.
         *
         * Maximum over 5 minutes
         *
         * @stability stable
         */
        metricSMSMonthToDateSpentUSD(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The rate of successful SMS message deliveries.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricSMSSuccessRate(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    /**
     * Either a new or imported Topic.
     *
     * @stability stable
     */
    interface TopicBase {
        /**
         * Return the given named metric for this Topic.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * Metric for the size of messages published through this topic.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricPublishSize(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages published to your Amazon SNS topics.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfMessagesPublished(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages successfully delivered from your Amazon SNS topics to subscribing endpoints.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfNotificationsDelivered(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages that Amazon SNS failed to deliver.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfNotificationsFailed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages that were rejected by subscription filter policies.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfNotificationsFilteredOut(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages that were rejected by subscription filter policies because the messages have no attributes.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfNotificationsFilteredOutNoMessageAttributes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages that were rejected by subscription filter policies because the messages' attributes are invalid.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfNotificationsFilteredOutInvalidAttributes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The charges you have accrued since the start of the current calendar month for sending SMS messages.
         *
         * Maximum over 5 minutes
         *
         * @stability stable
         */
        metricSMSMonthToDateSpentUSD(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The rate of successful SMS message deliveries.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricSMSSuccessRate(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
