##
#     Project: PyZendesk
# Description: API for Zendesk
#      Author: Fabio Castelli (Muflone) <muflone@muflone.com>
#   Copyright: 2021 Fabio Castelli
#     License: GPL-3+
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <https://www.gnu.org/licenses/>.
##

from .api import Api


class SupportTickets(Api):
    def get(self, ticket_id: int) -> dict:
        return self.request_get(path=f'tickets/{ticket_id}.json')

    def count(self, criteria_list: list) -> dict:
        criteria = ' '.join(criteria_list)
        return self.request_get(
            path=f'search/count?query=type:ticket {criteria}')

    def search(self, criteria_list: list) -> dict:
        criteria = ' '.join(criteria_list)
        return self.request_get(
            path=f'search?query=type:ticket {criteria}')

    def add_private_comment(self, ticket_id: int, text: str) -> dict:
        return self.request_put(path=f'tickets/{ticket_id}.json',
                                data={
                                    'ticket': {
                                        'comment': {
                                            'public': False,
                                            'body': text
                                        }
                                    }
                                })

    def add_public_comment(self, ticket_id: int, text: str) -> dict:
        return self.request_put(path=f'tickets/{ticket_id}.json',
                                data={
                                    'ticket': {
                                        'comment': {
                                            'public': True,
                                            'body': text
                                        }
                                    }
                                })

    def update_custom_fields(self, ticket_id: int, fields: list[dict]) -> dict:
        return self.request_put(path=f'tickets/{ticket_id}.json',
                                data={
                                    'ticket': {
                                        'custom_fields': fields
                                    }
                                })
