import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WorkerConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description for the worker.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/worker#description Worker#description}
    */
    readonly description?: string;
    /**
    * The name for the worker.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/worker#name Worker#name}
    */
    readonly name?: string;
    /**
    * The scope for the worker.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/worker#scope_id Worker#scope_id}
    */
    readonly scopeId: string;
    /**
    * The worker authentication token required to register the worker for the worker-led authentication flow. Leaving this blank will result in a controller generated token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/boundary/r/worker#worker_generated_auth_token Worker#worker_generated_auth_token}
    */
    readonly workerGeneratedAuthToken?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/boundary/r/worker boundary_worker}
*/
export declare class Worker extends cdktf.TerraformResource {
    static readonly tfResourceType = "boundary_worker";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/boundary/r/worker boundary_worker} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WorkerConfig
    */
    constructor(scope: Construct, id: string, config: WorkerConfig);
    get address(): string;
    get authorizedActions(): string[];
    get controllerGeneratedActivationToken(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get releaseVersion(): number;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    private _workerGeneratedAuthToken?;
    get workerGeneratedAuthToken(): string;
    set workerGeneratedAuthToken(value: string);
    resetWorkerGeneratedAuthToken(): void;
    get workerGeneratedAuthTokenInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
