# Generated by Paul on 2024-12-02 15:09

from django.db import migrations
from django.db.models import F


def fix_routine_performance_metrics(apps, schema):
    UsageMetrics = apps.get_model("workforce", "UsageMetrics")

    UsageMetrics.objects.filter(
        count_name="rolling_1_month_routine_performance"
    ).update(
        count_name="rolling_one_month_routine_performance",
        stat_count=F("stat_count") / 100,
    )

    UsageMetrics.objects.filter(
        count_name="rolling_12_month_routine_performance"
    ).update(
        count_name="rolling_twelve_month_routine_performance",
        stat_count=F("stat_count") / 100,
    )


class Migration(migrations.Migration):
    dependencies = [
        ("workforce", "0017_benchmark_delete_benchmarkdatapoint"),
    ]

    operations = [
        migrations.RunPython(code=fix_routine_performance_metrics, elidable=True),
    ]
