# Generated by Django 3.2.16 on 2023-01-21 02:47

import django.contrib.postgres.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("workforce", "0001_schema"),
    ]

    operations = [
        migrations.CreateModel(
            name="ConstanceSetting",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("slug", models.CharField(max_length=100)),
                ("setting_name", models.TextField()),
                ("setting_value", models.TextField(null=True)),
                ("last_reported", models.DateTimeField()),
            ],
            options={
                "db_table": 'workforce"."constance_summary',
                "managed": True,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="ExtensionSummary",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("tenant", models.CharField(db_index=True, max_length=200)),
                ("name", models.CharField(max_length=100)),
                ("is_enabled", models.BooleanField(db_index=True)),
            ],
            options={
                "db_table": 'workforce"."extension_summary',
                "managed": True,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="FeatureFlagSummary",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("tenant", models.CharField(db_index=True, max_length=200)),
                ("name", models.CharField(max_length=100)),
                ("is_enabled", models.BooleanField(db_index=True)),
            ],
            options={
                "db_table": 'workforce"."featureflag_summary',
                "managed": True,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="OnboardingActionRow",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("tenant", models.CharField(db_index=True, max_length=200)),
                ("last_synced", models.DateTimeField(db_index=True)),
                ("is_active", models.BooleanField(db_index=True)),
                ("name", models.CharField(max_length=150)),
                ("description", models.TextField(blank=True, default="")),
                ("due_date", models.DateField(blank=True, null=True)),
                ("completed_date", models.DateField(blank=True, null=True)),
                ("responsibility", models.CharField(max_length=100)),
                (
                    "assigned_to",
                    models.CharField(blank=True, default="", max_length=100),
                ),
                ("progress", models.IntegerField(blank=True, null=True)),
                ("effort", models.IntegerField(blank=True, null=True)),
                ("group", models.CharField(max_length=100)),
            ],
            options={
                "db_table": 'workforce"."customer_onboarding_actions',
                "managed": True,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="ServerUsage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("tenant", models.CharField(max_length=200)),
                ("staff_licenses_total", models.IntegerField()),
                ("staff_licenses_used", models.IntegerField()),
                ("staff_licenses_additional", models.IntegerField()),
                ("desk_licenses_used", models.IntegerField()),
                ("field_licenses_used", models.IntegerField()),
                ("contractor_licenses_used", models.IntegerField()),
                ("customer_licenses_used", models.IntegerField()),
                ("api_licenses_used", models.IntegerField()),
                ("reporting_licenses_used", models.IntegerField()),
                ("timesheet_licenses_used", models.IntegerField()),
                ("last_synced", models.DateTimeField()),
                ("for_date", models.DateField()),
            ],
            options={
                "db_table": 'workforce"."licensing_usage',
                "managed": True,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="TemplateChangeRequestSummary",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("tenant", models.CharField(db_index=True, max_length=200)),
                ("tcr_pk", models.PositiveIntegerField()),
                ("created", models.DateTimeField()),
                ("currency", models.CharField(blank=True, max_length=3, null=True)),
                (
                    "requested_changes",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=100),
                        blank=True,
                        default=list,
                        size=None,
                        verbose_name="Requested modifications",
                    ),
                ),
                ("status", models.CharField(db_index=True, max_length=20)),
                ("status_changed_requested", models.DateTimeField(null=True)),
                ("status_changed_approved", models.DateTimeField(null=True)),
                ("status_changed_completed", models.DateTimeField(null=True)),
                ("template_key", models.CharField(max_length=200)),
                ("template_name", models.CharField(max_length=200)),
                ("template_content_type_model", models.CharField(max_length=200)),
                ("estimated_price", models.PositiveIntegerField()),
                (
                    "estimated_hours",
                    models.DecimalField(decimal_places=4, max_digits=11),
                ),
            ],
            options={
                "db_table": 'workforce"."templates_template_change_request_summary',
                "managed": True,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="UsageMetrics",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("tenant", models.CharField(db_index=True, max_length=200)),
                ("count_name", models.CharField(db_index=True, max_length=200)),
                ("stat_count", models.BigIntegerField()),
                ("as_of", models.DateTimeField(db_index=True)),
            ],
            options={
                "db_table": 'workforce"."usage_metrics',
                "managed": True,
            },
        ),
        migrations.CreateModel(
            name="UserSummaryRow",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("last_synced", models.DateTimeField(db_index=True)),
                ("tenant", models.CharField(db_index=True, max_length=200)),
                ("user_pk", models.PositiveIntegerField(db_index=True)),
                ("email", models.CharField(db_index=True, max_length=255)),
                ("name", models.CharField(max_length=255)),
                ("license", models.CharField(db_index=True, max_length=10)),
                ("is_active", models.BooleanField(db_index=True)),
                ("is_superuser", models.BooleanField(db_index=True)),
                ("created", models.DateTimeField(db_index=True)),
                (
                    "last_access",
                    models.DateTimeField(blank=True, db_index=True, null=True),
                ),
                (
                    "groups",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(max_length=150),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
            ],
            options={
                "db_table": 'workforce"."customer_all_users',
                "managed": True,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="WorkforceAddressSummary",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("tenant", models.CharField(db_index=True, max_length=200)),
                ("last_synced", models.DateTimeField(null=True)),
                ("prop_status", models.CharField(blank=True, max_length=30)),
                ("prop_id", models.IntegerField()),
                ("prop_created", models.DateTimeField(null=True)),
                (
                    "address",
                    models.CharField(
                        blank=True,
                        help_text="Exact and validated registered postal address.",
                        max_length=1000,
                    ),
                ),
                (
                    "display",
                    models.TextField(
                        help_text="Address that will be used for display purposes.",
                        max_length=1000,
                    ),
                ),
                (
                    "country",
                    models.CharField(
                        blank=True,
                        choices=[("AU", "Australia"), ("NZ", "New Zealand")],
                        default="AU",
                        max_length=2,
                    ),
                ),
                ("gnaf_id", models.CharField(blank=True, default="", max_length=30)),
                (
                    "state",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=50,
                        verbose_name="State or Region",
                    ),
                ),
                (
                    "postal_code",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=15,
                        verbose_name="Postal or Zip code",
                    ),
                ),
                ("coords", models.CharField(blank=True, max_length=40)),
            ],
            options={
                "db_table": 'workforce"."address_summary',
                "managed": True,
                "default_permissions": (),
            },
        ),
        migrations.AddIndex(
            model_name="usagemetrics",
            index=models.Index(
                fields=["tenant", "count_name", "-as_of"],
                name="usage_metrics_latest_btree",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="serverusage",
            unique_together={("tenant", "for_date")},
        ),
    ]
