"use strict";
const assert_1 = require("@aws-cdk/assert");
const iam = require("@aws-cdk/aws-iam");
const eks = require("../lib");
const util_1 = require("./util");
module.exports = {
    'add Service Account': {
        'defaults should have default namespace and lowercase unique id'(test) {
            // GIVEN
            const { stack, cluster } = util_1.testFixtureCluster();
            // WHEN
            new eks.ServiceAccount(stack, 'MyServiceAccount', { cluster });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource(eks.KubernetesResource.RESOURCE_TYPE, {
                ServiceToken: {
                    'Fn::GetAtt': [
                        'awscdkawseksKubectlProviderNestedStackawscdkawseksKubectlProviderNestedStackResourceA7AEBA6B',
                        'Outputs.StackawscdkawseksKubectlProviderframeworkonEvent8897FD9BArn',
                    ],
                },
                Manifest: {
                    'Fn::Join': [
                        '',
                        [
                            '[{\"apiVersion\":\"v1\",\"kind\":\"ServiceAccount\",\"metadata\":{\"name\":\"stackmyserviceaccount58b9529e\",\"namespace\":\"default\",\"labels\":{\"app.kubernetes.io/name\":\"stackmyserviceaccount58b9529e\"},\"annotations\":{\"eks.amazonaws.com/role-arn\":\"',
                            {
                                'Fn::GetAtt': [
                                    'MyServiceAccountRoleB41709FF',
                                    'Arn',
                                ],
                            },
                            '\"}}}]',
                        ],
                    ],
                },
            }));
            assert_1.expect(stack).to(assert_1.haveResource(iam.CfnRole.CFN_RESOURCE_TYPE_NAME, {
                AssumeRolePolicyDocument: {
                    Statement: [
                        {
                            Action: 'sts:AssumeRoleWithWebIdentity',
                            Effect: 'Allow',
                            Principal: {
                                Federated: {
                                    Ref: 'ClusterOpenIdConnectProviderE7EB0530',
                                },
                            },
                        },
                    ],
                    Version: '2012-10-17',
                },
            }));
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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