"""LICENSE
Copyright 2019 Hermann Krumrey <hermann@krumreyh.com>

This file is part of puffotter.

puffotter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

puffotter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with puffotter.  If not, see <http://www.gnu.org/licenses/>.
LICENSE"""

from setuptools import setup, find_packages

if __name__ == "__main__":

    setup(
        name="puffotter",
        version=open("version", "r").read(),
        description="Convenience library for python",
        long_description=open("README.md", "r").read(),
        long_description_content_type="text/markdown",
        author="Hermann Krumrey",
        author_email="hermann@krumreyh.com",
        classifiers=[
            "License :: OSI Approved :: GNU General Public License v3 (GPLv3)"
        ],
        url="https://gitlab.namibsun.net/namibsun/python/puffotter",
        license="GNU GPL3",
        packages=find_packages(),
        install_requires=[
            "sentry-sdk",
            "requests",
            "colorama"
        ],
        extras_require={
            "flask": [
                "flask",
                "flask-sqlalchemy",
                "flask-login",
                "cheroot",
                "werkzeug",
                "sentry-sdk[flask]",
                "blinker"
            ],
            "crypto": [
                "bcrypt"
            ]
        },
        test_suite='nose.collector',
        tests_require=['nose'],
        include_package_data=True,
        zip_safe=False
    )
