<h1>maxmods</h1>
<p dir="auto"><a href="https://github.com/maxwellewxam/maxmods/">maxmods</a> is a collection of tools for user authentication and data management. The library is released under the MIT License and the documentation is generated by an AI trained by OpenAI.</p>
<h1>maxmods.auth</h1><p>The <code>maxmods.auth</code> module provides a simple way to handle user authentication and data storage on a remote server. The <code>AuthSesh</code> class allows users to sign up, log in, and manage their data on the server.</p><h2>Usage</h2><p>To use the <code>AuthSesh</code> class, you first need to create an instance of the class and set the username and password:</p><pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python"><span class="hljs-keyword">from</span> maxmods.auth <span class="hljs-keyword">import</span> AuthSesh
auth = AuthSesh()
auth.set_vals(<span class="hljs-string">"username"</span>, <span class="hljs-string">"password"</span>)
</code></div></div></pre><p>Once the username and password are set, you can use the <code>login()</code> method to log in to the server:</p><pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">auth.login()
</code></div></div></pre><p>If the login is successful, you can use the <code>save()</code> and <code>load()</code> methods to save and load data from the server. For example:</p><pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">auth.save(<span class="hljs-string">"user_data/profile"</span>, {<span class="hljs-string">"name"</span>: <span class="hljs-string">"John Doe"</span>, <span class="hljs-string">"email"</span>: <span class="hljs-string">"johndoe@example.com"</span>})
user_data = auth.load(<span class="hljs-string">"user_data/profile"</span>)</code></div></div></pre><p>When you are done with the instance, you have to use the <code>terminate()</code> method to end the connention with the server:</p><pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python">auth.terminate()</code></div></div></pre><p>Note: If you do not do this, nothing you do on the server will save.

The <code>AuthSesh</code> class also provides methods for signing up new users, removing users, and terminating the session. For more details and examples, see the <a href="https://github.com/maxwellewxam/maxmods/blob/main/maxmods/auth/auth.py" target="_new">AuthSesh class documentation</a>.</p><h3>Context Manager</h3><p>The <code>AuthSesh</code> class can be used as a context manager to automatically log out and terminate the session when the context ends:</p><pre><div class="bg-black mb-4 rounded-md"><div class="flex items-center relative text-gray-200 bg-gray-800 px-4 py-2 text-xs font-sans"></div><div class="p-4"><code class="!whitespace-pre-wrap hljs language-python"><span class="hljs-keyword">from</span> maxmods.auth <span class="hljs-keyword">import</span> AuthSesh

<span class="hljs-keyword">with</span> AuthSesh() <span class="hljs-keyword">as</span> auth:
</span>    auth.set_vals(<span class="hljs-string">"username"</span>, <span class="hljs-string">"password"</span>)
</span>    auth.login()
    <span class="hljs-comment">    # ...</span>
</code></div></div></pre><h2>Exceptions</h2><p>The <code>AuthSesh</code> class raises the following exceptions:</p><ul><li><code>AuthenticationError</code>: Raised if there is an error authenticating the user.</li><li><code>DataError</code>: Raised if there is an error accessing or modifying the data on the server.</li><li><code>LocationError</code>: Raised if the specified location does not exist on the server.</li><li><code>PasswordError</code>: Raised if the password is incorrect or invalid.</li><li><code>UsernameError</code>: Raised if the username is invalid or already in use.</li></ul>
<h2>Installation</h2>
<div class="snippet-clipboard-content notranslate position-relative overflow-auto"><pre lang="terminal" class="notranslate"><code>$ pip install maxmods
</code></pre>
<h2>License and Disclaimer</h2>
<p dir="auto">The <a href="https://github.com/maxwellewxam/maxmods/">maxmods</a> library is licensed under the MIT License, which means it is free to use and distribute for both personal and commercial purposes. The documentation for the library has been generated by an AI trained by OpenAI, and may not be entirely accurate or up-to-date. It is recommended to consult the source code for the library for the most accurate information.</p>
<h2>Authors</h2>
<ul dir="auto">
<li><a href="https://www.github.com/maxwellewxam">@maxwellewxam</a></li>
<li><a href="https://www.github.com/3008362">@3008362</a></li>
