[![DOI](https://zenodo.org/badge/394667513.svg)](https://zenodo.org/badge/latestdoi/394667513)
[![License: CC0-1.0](https://img.shields.io/badge/License-CC0_1.0-lightgrey.svg)](http://creativecommons.org/publicdomain/zero/1.0/)

<div align="center"><br>
  <img width="250" src="https://dunstan.becht.network/permanent/mines.svg" alt="Mines Saint-Etienne">
</div>

# Line Profile Analysis - X-Ray Diffraction

This project is related to the analysis of crystals containing dislocations by X-ray diffraction. It was developed and used for a study conducted during a research internship at the laboratory of material and structural sciences of the *École Nationale Supérieure des Mines de Saint-Étienne*. This repository contains the distribution of one of the three published python packages that have been proposed to conduct line profile analyses based on simulation results:
* [`lpa-input`](https://github.com/DunstanBecht/lpa-input) (line profile analysis input generator)
* [`lpa-xrd`](https://github.com/DunstanBecht/lpa-xrd) (line profile analysis x-ray diffraction simulation program)
* [`lpa-output`](https://github.com/DunstanBecht/lpa-output) (line profile analysis output analyzer)

The repository [`lpa-workspace`](https://github.com/DunstanBecht/lpa-workspace) contains the parameters and the scripts for the generation of the data used in the study. You can then easily replicate the results obtained or use it as inspiration to take the code in hand and conduct your own calculations. The software is placed in the public domain and you can use it as you wish. However, users are encouraged to contribute to the development and report issues.

# Features

The package `lpa.xrd` can be used to:
* make a local copy of the X-ray diffraction simulator code
* automate the tasks of compilations and executions

# Installation

The package is indexed on [PyPI](https://pypi.org/project/lpa-xrd/) and installable directly via pip:
```bash
pip install -U lpa-xrd
```

# Examples

### Output data files
```
   1.0.0 # v: lpa-xrd version
5.00e+13 # d: dislocation density [m^-2]
 1 -1 -2 # z: direction of 'l' (line vector) [uvw]
 1  1  0 # b: Burgers vector direction [uvw]
 2  0  0 # g: diffraction vector direction (hkl)
0.266310 # C: contrast coefficient [1]
0.404940 # a: cell parameter [nm]
    1600 # s: radius of the region of interest [nm]
0.345000 # nu: Poisson's number [1]
     402 # nd: number of dislocations in the input file
  200000 # np: number of random points
#    L                   cos1       err_cos1                   sin1       err_sin1                   cos2       err_cos2                   sin2       err_sin2                   cos3       err_cos3                   sin3       err_sin3                   cos4       err_cos4                   sin4       err_sin4                   cos5       err_cos5                   sin5       err_sin5                   eps2       nrpo
  11.8  9.691773883865256E-01  2.2128697E-04  3.548573950558385E-02  4.9821012E-04  8.981966908658684E-01  4.6467430E-04  6.440531511835489E-02  8.5414040E-04  8.039565591713508E-01  7.1534065E-04  8.433187204823500E-02  1.1049916E-03  6.998830398491644E-01  9.4436811E-04  9.398330820534732E-02  1.2707619E-03  5.951457168994917E-01  1.1361201E-03  9.393006672176032E-02  1.3762779E-03  5.279758286973477E-03          0
  23.6  8.966182359366608E-01  4.7074247E-04  6.430266632036827E-02  8.5913378E-04  6.964874673091421E-01  9.5428468E-04  9.275125489106480E-02  1.2731321E-03  4.935653318237136E-01  1.2891659E-03  8.562874536165226E-02  1.4433901E-03  3.344514627598760E-01  1.4580819E-03  5.648006069528611E-02  1.5161730E-03  2.237613188696568E-01  1.5302258E-03  2.203279887123107E-02  1.5510190E-03  2.529614395176134E-03          0
  35.4  7.995267730884241E-01  7.2959669E-04  8.294124298792621E-02  1.1122437E-03  4.914095890449063E-01  1.2916810E-03  8.398918247803124E-02  1.4452996E-03  2.707633256750224E-01  1.5042156E-03  3.793836959220092E-02  1.5373998E-03  1.503394047307585E-01  1.5618955E-03 -7.971333125686080E-03  1.5643463E-03  8.685076575789313E-02  1.5814098E-03 -3.136764652509575E-02  1.5673330E-03  1.605193078086523E-03          0
  47.2  6.921181780049125E-01  9.6279465E-04  9.070888260694561E-02  1.2793596E-03  3.288427078106518E-01  1.4635770E-03  5.371236726003588E-02  1.5175151E-03  1.490960769894547E-01  1.5620066E-03 -9.132507813276795E-03  1.5647986E-03  7.309378837198512E-02  1.5835047E-03 -3.651648518763794E-02  1.5681700E-03  3.675406839202990E-02  1.5870028E-03 -3.964683495114327E-02  1.5706156E-03  1.104029393154493E-03          0
  59.0  5.840878857790123E-01  1.1573671E-03  8.902838402197788E-02  1.3838810E-03  2.181087356365769E-01  1.5337497E-03  1.796594776533478E-02  1.5518415E-03  8.769698774200350E-02  1.5807306E-03 -3.394576452983837E-02  1.5675298E-03  3.608403575158121E-02  1.5876824E-03 -4.101029129247049E-02  1.5698471E-03  1.919762821220127E-02  1.5825821E-03 -3.091664543267597E-02  1.5776207E-03  8.360835214626308E-04          2
  70.8  4.832728850662605E-01  1.3059344E-03  7.963188342191242E-02  1.4474604E-03  1.492776048081230E-01  1.5611165E-03 -1.199991740951274E-02  1.5655268E-03  5.032816037354927E-02  1.5902893E-03 -4.200691674607025E-02  1.5651172E-03  1.938195115226149E-02  1.5824081E-03 -3.449219771929993E-02  1.5774212E-03  1.655313054424410E-02  1.5823158E-03 -2.366876313077357E-02  1.5786721E-03  6.718857597028556E-04          3
  82.6  3.945229906156520E-01  1.4103930E-03  6.521899540612391E-02  1.4870733E-03  1.069602227117538E-01  1.5751734E-03 -3.016312204133309E-02  1.5675461E-03  2.975159417463052E-02  1.5884527E-03 -4.009596048287382E-02  1.5698658E-03  1.532462856621969E-02  1.5807939E-03 -2.907935145123633E-02  1.5798143E-03  1.593357304302691E-02  1.5787681E-03 -1.734605604721803E-02  1.5826694E-03  5.566396193181975E-04          4
  94.4  3.201728183667767E-01  1.4756492E-03  4.759581128013269E-02  1.5161510E-03  7.601136589965189E-02  1.5835879E-03 -3.807116137645236E-02  1.5672468E-03  2.126235995769968E-02  1.5825234E-03 -3.519367940543306E-02  1.5771227E-03  1.462565526536811E-02  1.5810700E-03 -2.215509381873277E-02  1.5801404E-03  1.615331714937047E-02  1.5780078E-03 -1.569618349524832E-02  1.5835103E-03  4.742033058980942E-04          5
 106.2  2.601319495629381E-01  1.5134285E-03  2.938763387311302E-02  1.5385401E-03  5.147780332276126E-02  1.5901326E-03 -4.110584147335464E-02  1.5652568E-03  1.790816108372411E-02  1.5828502E-03 -3.036863927232478E-02  1.5775361E-03  1.665802679087950E-02  1.5783909E-03 -1.558387726063497E-02  1.5831394E-03  1.116722902890220E-02  1.5819240E-03 -1.517237590581016E-02  1.5798708E-03  4.102739348096619E-04          9
 118.0  2.126806003034781E-01  1.5352457E-03  1.292920540363307E-02  1.5544472E-03  3.320126639740145E-02  1.5925721E-03 -4.149574060187155E-02  1.5652131E-03  1.577207958419712E-02  1.5824574E-03 -2.648911954585361E-02  1.5784094E-03  1.665814852807336E-02  1.5794401E-03 -1.456999880400672E-02  1.5821567E-03  5.422406775106916E-03  1.5824833E-03 -1.045296044477967E-02  1.5796687E-03  3.576164936773084E-04         11
 129.8  1.755840172820011E-01  1.5508349E-03 -3.919905631821283E-04  1.5624178E-03  2.361804794962222E-02  1.5916243E-03 -3.946858371266279E-02  1.5673395E-03  1.529451359544332E-02  1.5800877E-03 -2.350953784016020E-02  1.5810723E-03  1.434178073697236E-02  1.5810558E-03 -1.465682319005111E-02  1.5806834E-03  2.270897612171184E-03  1.5846126E-03 -8.731489961345359E-03  1.5776552E-03  3.153709904466467E-04         15
 141.6  1.467437545055130E-01  1.5632023E-03 -1.016354572372348E-02  1.5648175E-03  2.042002061018760E-02  1.5883471E-03 -3.468223114328585E-02  1.5714654E-03  1.228026509533392E-02  1.5802412E-03 -1.708047060600700E-02  1.5814787E-03  9.881728198611200E-03  1.5844659E-03 -1.023618576419469E-02  1.5776266E-03 -4.489525589067670E-04  1.5849804E-03 -7.873182836595377E-03  1.5773320E-03  2.816099561991873E-04         17
 153.4  1.237571773712377E-01  1.5723334E-03 -1.637480115338964E-02  1.5653955E-03  1.940099039631398E-02  1.5840890E-03 -2.973062258255061E-02  1.5763835E-03  8.838945322935079E-03  1.5810383E-03 -1.300334435637568E-02  1.5810461E-03  4.362465187132901E-03  1.5875801E-03 -5.948876074465396E-03  1.5747833E-03 -2.396376516726243E-03  1.5849326E-03 -4.967718854427622E-03  1.5774858E-03  2.541105579107383E-04         24
 165.2  1.047741927073791E-01  1.5759205E-03 -1.971697569202953E-02  1.5685690E-03  1.521149764000534E-02  1.5789863E-03 -2.585450154054665E-02  1.5821117E-03  6.448824093954678E-03  1.5825867E-03 -9.353880215743647E-03  1.5797306E-03 -2.412726573059556E-03  1.5870061E-03 -6.536068803747373E-03  1.5754187E-03  4.585754786336312E-04  1.5821126E-03 -2.484359234150717E-03  1.5803996E-03  2.320367544030688E-04         30
 177.0  8.754180705962947E-02  1.5761199E-03 -2.204234913856768E-02  1.5735363E-03  8.804930263241395E-03  1.5779313E-03 -2.536540838359405E-02  1.5834938E-03  4.984917691965816E-03  1.5798490E-03 -7.050895856344947E-03  1.5826021E-03 -4.082358584894804E-03  1.5835105E-03 -7.011319632422461E-03  1.5789524E-03 -1.083597518048387E-03  1.5803721E-03  6.444444622518797E-03  1.5821301E-03  2.127158340870026E-04         36
 188.8  7.161213039862305E-02  1.5753980E-03 -2.470939826503265E-02  1.5781620E-03  2.774824957517644E-03  1.5789631E-03 -2.617016425831372E-02  1.5825887E-03  4.438812648202551E-03  1.5808505E-03 -3.047775508884982E-03  1.5817528E-03 -2.969138964747313E-03  1.5852489E-03 -7.736624610477162E-04  1.5773757E-03  5.714226307282296E-05  1.5776103E-03  1.170981519775473E-02  1.5848139E-03  1.947747782050475E-04         46
 200.6  5.718294006352832E-02  1.5769575E-03 -2.832867646785684E-02  1.5792998E-03  9.891794850168465E-04  1.5790199E-03 -2.436634051688234E-02  1.5827420E-03  2.635143303797348E-03  1.5876855E-03  5.714397589286234E-04  1.5749822E-03 -2.945819926387934E-03  1.5835735E-03  4.566556578307106E-03  1.5790812E-03 -8.006821870383196E-04  1.5725102E-03  1.136059800570184E-02  1.5899413E-03  1.792110128784938E-04         53
 212.4  4.461774570669071E-02  1.5808356E-03 -3.322341574304026E-02  1.5770484E-03  3.278138292524734E-03  1.5777264E-03 -1.889572911043606E-02  1.5844685E-03 -1.513522668749889E-03  1.5907716E-03  2.172691087783018E-05  1.5719525E-03 -4.608865492930787E-03  1.5791747E-03  7.430822199709916E-03  1.5834852E-03 -1.392499539390984E-03  1.5729574E-03  9.348749768154186E-03  1.5896411E-03  1.657619032846209E-04         63
```

# Abbreviations

Some abbreviations are used in the column names:

* `cos<j>` estimator of the mean cos coefficients of the Fourier transform, harmonic `<j>`
* `cos<j>` estimator of the mean sin coefficients of the Fourier transform, harmonic `<j>`
* `err_cos<j>` estimator of the standard deviation of the cos coefficients mean (standard error), harmonic `<j>`
* `err_sin<j>` estimator of the standard deviation of the sin coefficients mean (standard error), harmonic `<j>`
* `eps2` estimator of the mean square strain
* `nrpo` number of random points outside the region of interest for the current value of `L`

# User guide

It is necessary to install the [NVIDIA CUDA Toolkit](https://developer.nvidia.com/cuda-downloads) to compile the OpenCL code on NVIDIA GPUs.

The directory `tests/` contains several examples of package module usage. The docstrings are carefully written and it is recommended to refer to the documentation with the `help()` python command.

The installation from PyPI does not allow the modification of the code. To edit the package and contribute to the development use the following commands in your working directory.
```bash
pip uninstall lpa-xrd
git clone https://github.com/DunstanBecht/lpa-xrd.git
pip install -e lpa-xrd
cd lpa-xrd
git branch <name_of_your_new_branch>
```
