"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FUTURE_FLAGS = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0;
// --------------------------------------------------------------------------------
// This file defines context keys that enable certain features that are
// implemented behind a flag in order to preserve backwards compatibility for
// existing apps. When a new app is initialized through `cdk init`, the CLI will
// automatically add enable these features by adding them to the generated
// `cdk.json` file. In the next major release of the CDK, these feature flags
// will be removed and will become the default behavior.
// See https://github.com/aws/aws-cdk-rfcs/blob/master/text/0055-feature-flags.md
// --------------------------------------------------------------------------------
/**
 * If this is set, multiple stacks can use the same stack name (e.g. deployed to
 * different environments). This means that the name of the synthesized template
 * file will be based on the construct path and not on the defined `stackName`
 * of the stack.
 *
 * This is a "future flag": the feature is disabled by default for backwards
 * compatibility, but new projects created using `cdk init` will have this
 * enabled through the generated `cdk.json`.
 */
exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = '@aws-cdk/core:enableStackNameDuplicates';
/**
 * IF this is set, `cdk diff` will always exit with 0.
 *
 * Use `cdk diff --fail` to exit with 1 if there's a diff.
 */
exports.ENABLE_DIFF_NO_FAIL_CONTEXT = 'aws-cdk:enableDiffNoFail';
/** @deprecated use `ENABLE_DIFF_NO_FAIL_CONTEXT` */
exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT;
/**
 * Switch to new stack synthesis method which enable CI/CD
 */
exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = '@aws-cdk/core:newStyleStackSynthesis';
/**
 * This map includes context keys and values for feature flags that enable
 * capabilities "from the future", which we could not introduce as the default
 * behavior due to backwards compatibility for existing projects.
 *
 * New projects generated through `cdk init` will include these flags in their
 * generated `cdk.json` file.
 *
 * When we release the next major version of the CDK, we will flip the logic of
 * these features and clean up the `cdk.json` generated by `cdk init`.
 *
 * Tests must cover the default (disabled) case and the future (enabled) case.
 */
exports.FUTURE_FLAGS = {
    [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: 'true',
    [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: 'true',
};
//# sourceMappingURL=data:application/json;base64,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