import { CfnResource } from './cfn-resource';
import { CfnTag } from './cfn-tag';
import { ICfnFinder } from './from-cfn';
import { IResolvable } from './resolvable';
import { Mapper, Validator } from './runtime';
/**
 * This class contains static methods called when going from
 * translated values received from {@link CfnParser.parseValue}
 * to the actual L1 properties -
 * things like changing IResolvable to the appropriate type
 * (string, string array, or number), etc.
 *
 * While this file not exported from the module
 * (to not make it part of the public API),
 * it is directly referenced in the generated L1 code.
 *
 * @experimental
 */
export declare class FromCloudFormation {
    static getAny(value: any): any;
    static getBoolean(value: any): boolean | IResolvable;
    static getDate(value: any): Date | IResolvable;
    static getString(value: any): string;
    static getNumber(value: any): number;
    static getStringArray(value: any): string[];
    static getArray<T>(mapper: (arg: any) => T): (x: any) => T[];
    static getMap<T>(mapper: (arg: any) => T): (x: any) => {
        [key: string]: T;
    };
    static getCfnTag(tag: any): CfnTag;
    /**
     * Return a function that, when applied to a value, will return the first validly deserialized one
     */
    static getTypeUnion(validators: Validator[], mappers: Mapper[]): (x: any) => any;
}
/**
 * The context in which the parsing is taking place.
 *
 * Some fragments of CloudFormation templates behave differently than others
 * (for example, the 'Conditions' sections treats { "Condition": "NameOfCond" }
 * differently than the 'Resources' section).
 * This enum can be used to change the created {@link CfnParser} behavior,
 * based on the template context.
 */
export declare enum CfnParsingContext {
    /** We're currently parsing the 'Conditions' section. */
    CONDITIONS = 0
}
/**
 * The options for {@link FromCloudFormation.parseValue}.
 */
export interface ParseCfnOptions {
    /**
     * The finder interface used to resolve references in the template.
     */
    readonly finder: ICfnFinder;
    /**
     * The context we're parsing the template in.
     *
     * @default - the default context (no special behavior)
     */
    readonly context?: CfnParsingContext;
}
/**
 * This class contains methods for translating from a pure CFN value
 * (like a JS object { "Ref": "Bucket" })
 * to a form CDK understands
 * (like Fn.ref('Bucket')).
 *
 * While this file not exported from the module
 * (to not make it part of the public API),
 * it is directly referenced in the generated L1 code,
 * so any renames of it need to be reflected in cfn2ts/codegen.ts as well.
 *
 * @experimental
 */
export declare class CfnParser {
    private readonly options;
    constructor(options: ParseCfnOptions);
    handleAttributes(resource: CfnResource, resourceAttributes: any, logicalId: string): void;
    private parseCreationPolicy;
    private parseUpdatePolicy;
    private parseDeletionPolicy;
    parseValue(cfnValue: any): any;
    private parseIfCfnIntrinsic;
    private looksLikeCfnIntrinsic;
    private parseFnSubString;
}
