import { AssetOptions } from './assets';
import { FingerprintOptions } from './fs';
import { Construct } from './construct-compat';
/**
 * Initialization properties for `AssetStaging`.
 */
export interface AssetStagingProps extends FingerprintOptions, AssetOptions {
    /**
     * The source file or directory to copy from.
     */
    readonly sourcePath: string;
}
/**
 * Stages a file or directory from a location on the file system into a staging
 * directory.
 *
 * This is controlled by the context key 'aws:cdk:asset-staging' and enabled
 * by the CLI by default in order to ensure that when the CDK app exists, all
 * assets are available for deployment. Otherwise, if an app references assets
 * in temporary locations, those will not be available when it exists (see
 * https://github.com/aws/aws-cdk/issues/1716).
 *
 * The `stagedPath` property is a stringified token that represents the location
 * of the file or directory after staging. It will be resolved only during the
 * "prepare" stage and may be either the original path or the staged path
 * depending on the context setting.
 *
 * The file/directory are staged based on their content hash (fingerprint). This
 * means that only if content was changed, copy will happen.
 */
export declare class AssetStaging extends Construct {
    /**
     * The directory inside the bundling container into which the asset sources will be mounted.
     * @experimental
     */
    static readonly BUNDLING_INPUT_DIR = "/asset-input";
    /**
     * The directory inside the bundling container into which the bundled output should be written.
     * @experimental
     */
    static readonly BUNDLING_OUTPUT_DIR = "/asset-output";
    /**
     * The path to the asset (stringinfied token).
     *
     * If asset staging is disabled, this will just be the original path.
     * If asset staging is enabled it will be the staged path.
     */
    readonly stagedPath: string;
    /**
     * The path of the asset as it was referenced by the user.
     */
    readonly sourcePath: string;
    /**
     * A cryptographic hash of the asset.
     *
     * @deprecated see `assetHash`.
     */
    readonly sourceHash: string;
    /**
     * A cryptographic hash of the asset.
     */
    readonly assetHash: string;
    private readonly fingerprintOptions;
    private readonly relativePath?;
    private readonly bundleDir?;
    constructor(scope: Construct, id: string, props: AssetStagingProps);
    private stageAsset;
    private bundle;
    private calculateHash;
}
