"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerTarget = void 0;
/**
 * Use an ELBv2 as an alias record target
 */
class LoadBalancerTarget {
    constructor(loadBalancer) {
        this.loadBalancer = loadBalancer;
    }
    bind(_record) {
        return {
            hostedZoneId: this.loadBalancer.loadBalancerCanonicalHostedZoneId,
            dnsName: `dualstack.${this.loadBalancer.loadBalancerDnsName}`,
        };
    }
}
exports.LoadBalancerTarget = LoadBalancerTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9hZC1iYWxhbmNlci10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb2FkLWJhbGFuY2VyLXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQTs7R0FFRztBQUNILE1BQWEsa0JBQWtCO0lBQzNCLFlBQTZCLFlBQW1DO1FBQW5DLGlCQUFZLEdBQVosWUFBWSxDQUF1QjtJQUNoRSxDQUFDO0lBQ00sSUFBSSxDQUFDLE9BQTJCO1FBQ25DLE9BQU87WUFDSCxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxpQ0FBaUM7WUFDakUsT0FBTyxFQUFFLGFBQWEsSUFBSSxDQUFDLFlBQVksQ0FBQyxtQkFBbUIsRUFBRTtTQUNoRSxDQUFDO0lBQ04sQ0FBQztDQUNKO0FBVEQsZ0RBU0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlbGJ2MiBmcm9tIFwiLi4vLi4vYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5ndjJcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyJ1xuaW1wb3J0ICogYXMgcm91dGU1MyBmcm9tIFwiLi4vLi4vYXdzLXJvdXRlNTNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1yb3V0ZTUzJ1xuLyoqXG4gKiBVc2UgYW4gRUxCdjIgYXMgYW4gYWxpYXMgcmVjb3JkIHRhcmdldFxuICovXG5leHBvcnQgY2xhc3MgTG9hZEJhbGFuY2VyVGFyZ2V0IGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgbG9hZEJhbGFuY2VyOiBlbGJ2Mi5JTG9hZEJhbGFuY2VyVjIpIHtcbiAgICB9XG4gICAgcHVibGljIGJpbmQoX3JlY29yZDogcm91dGU1My5JUmVjb3JkU2V0KTogcm91dGU1My5BbGlhc1JlY29yZFRhcmdldENvbmZpZyB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBob3N0ZWRab25lSWQ6IHRoaXMubG9hZEJhbGFuY2VyLmxvYWRCYWxhbmNlckNhbm9uaWNhbEhvc3RlZFpvbmVJZCxcbiAgICAgICAgICAgIGRuc05hbWU6IGBkdWFsc3RhY2suJHt0aGlzLmxvYWRCYWxhbmNlci5sb2FkQmFsYW5jZXJEbnNOYW1lfWAsXG4gICAgICAgIH07XG4gICAgfVxufVxuIl19