"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bundle = void 0;
const fs = require("fs");
const path = require("path");
const lambda = require("../../aws-lambda"); // Automatically re-written from '@aws-cdk/aws-lambda'
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Produce bundled Lambda asset code
 */
function bundle(options) {
    let installer = options.runtime === lambda.Runtime.PYTHON_2_7 ? Installer.PIP : Installer.PIP3;
    let hasRequirements = fs.existsSync(path.join(options.entry, 'requirements.txt'));
    let depsCommand = chain([
        hasRequirements ? `${installer} install -r requirements.txt -t ${cdk.AssetStaging.BUNDLING_OUTPUT_DIR}` : '',
        `cp -au . ${cdk.AssetStaging.BUNDLING_OUTPUT_DIR}`,
    ]);
    return lambda.Code.fromAsset(options.entry, {
        bundling: {
            image: options.runtime.bundlingDockerImage,
            command: ['bash', '-c', depsCommand],
        },
    });
}
exports.bundle = bundle;
var Installer;
(function (Installer) {
    Installer["PIP"] = "pip";
    Installer["PIP3"] = "pip3";
})(Installer || (Installer = {}));
function chain(commands) {
    return commands.filter(c => !!c).join(' && ');
}
//# sourceMappingURL=data:application/json;base64,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