"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnFileSystem = void 0;
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2020-08-07T19:23:57.200Z","fingerprint":"tjDMPAXKHphDu7WCod2XxWTHYkXJWlrkEQdwPFwhUWk="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const cfn_parse = require("../../core/lib/cfn-parse"); // Automatically re-written from '@aws-cdk/core/lib/cfn-parse'
/**
 * Determine whether the given properties match those of a `CfnFileSystemProps`
 *
 * @param properties - the TypeScript properties of a `CfnFileSystemProps`
 *
 * @returns the result of the validation.
 */
function CfnFileSystemPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('backupId', cdk.validateString)(properties.backupId));
    errors.collect(cdk.propertyValidator('fileSystemType', cdk.requiredValidator)(properties.fileSystemType));
    errors.collect(cdk.propertyValidator('fileSystemType', cdk.validateString)(properties.fileSystemType));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('lustreConfiguration', CfnFileSystem_LustreConfigurationPropertyValidator)(properties.lustreConfiguration));
    errors.collect(cdk.propertyValidator('securityGroupIds', cdk.listValidator(cdk.validateString))(properties.securityGroupIds));
    errors.collect(cdk.propertyValidator('storageCapacity', cdk.validateNumber)(properties.storageCapacity));
    errors.collect(cdk.propertyValidator('storageType', cdk.validateString)(properties.storageType));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('windowsConfiguration', CfnFileSystem_WindowsConfigurationPropertyValidator)(properties.windowsConfiguration));
    return errors.wrap('supplied properties not correct for "CfnFileSystemProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem` resource
 *
 * @param properties - the TypeScript properties of a `CfnFileSystemProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystemPropsValidator(properties).assertSuccess();
    return {
        FileSystemType: cdk.stringToCloudFormation(properties.fileSystemType),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        BackupId: cdk.stringToCloudFormation(properties.backupId),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        LustreConfiguration: cfnFileSystemLustreConfigurationPropertyToCloudFormation(properties.lustreConfiguration),
        SecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),
        StorageCapacity: cdk.numberToCloudFormation(properties.storageCapacity),
        StorageType: cdk.stringToCloudFormation(properties.storageType),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        WindowsConfiguration: cfnFileSystemWindowsConfigurationPropertyToCloudFormation(properties.windowsConfiguration),
    };
}
// @ts-ignore TS6133
function CfnFileSystemPropsFromCloudFormation(properties) {
    properties = properties || {};
    return {
        fileSystemType: cfn_parse.FromCloudFormation.getString(properties.FileSystemType),
        subnetIds: cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds),
        backupId: properties.BackupId != null ? cfn_parse.FromCloudFormation.getString(properties.BackupId) : undefined,
        kmsKeyId: properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined,
        lustreConfiguration: properties.LustreConfiguration != null ? CfnFileSystemLustreConfigurationPropertyFromCloudFormation(properties.LustreConfiguration) : undefined,
        securityGroupIds: properties.SecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds) : undefined,
        storageCapacity: properties.StorageCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.StorageCapacity) : undefined,
        storageType: properties.StorageType != null ? cfn_parse.FromCloudFormation.getString(properties.StorageType) : undefined,
        tags: properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined,
        windowsConfiguration: properties.WindowsConfiguration != null ? CfnFileSystemWindowsConfigurationPropertyFromCloudFormation(properties.WindowsConfiguration) : undefined,
    };
}
/**
 * A CloudFormation `AWS::FSx::FileSystem`
 *
 * @cloudformationResource AWS::FSx::FileSystem
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fsx-filesystem.html
 */
class CfnFileSystem extends cdk.CfnResource {
    /**
     * Create a new `AWS::FSx::FileSystem`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnFileSystem.CFN_RESOURCE_TYPE_NAME, properties: props });
        cdk.requireProperty(props, 'fileSystemType', this);
        cdk.requireProperty(props, 'subnetIds', this);
        this.attrLustreMountName = cdk.Token.asString(this.getAtt('LustreMountName'));
        this.fileSystemType = props.fileSystemType;
        this.subnetIds = props.subnetIds;
        this.backupId = props.backupId;
        this.kmsKeyId = props.kmsKeyId;
        this.lustreConfiguration = props.lustreConfiguration;
        this.securityGroupIds = props.securityGroupIds;
        this.storageCapacity = props.storageCapacity;
        this.storageType = props.storageType;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::FSx::FileSystem", props.tags, { tagPropertyName: 'tags' });
        this.windowsConfiguration = props.windowsConfiguration;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const cfnParser = new cfn_parse.CfnParser({
            finder: options.finder,
        });
        const resourceProperties = cfnParser.parseValue(resourceAttributes.Properties);
        const props = CfnFileSystemPropsFromCloudFormation(resourceProperties);
        const ret = new CfnFileSystem(scope, id, props);
        cfnParser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnFileSystem.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            fileSystemType: this.fileSystemType,
            subnetIds: this.subnetIds,
            backupId: this.backupId,
            kmsKeyId: this.kmsKeyId,
            lustreConfiguration: this.lustreConfiguration,
            securityGroupIds: this.securityGroupIds,
            storageCapacity: this.storageCapacity,
            storageType: this.storageType,
            tags: this.tags.renderTags(),
            windowsConfiguration: this.windowsConfiguration,
        };
    }
    renderProperties(props) {
        return cfnFileSystemPropsToCloudFormation(props);
    }
}
exports.CfnFileSystem = CfnFileSystem;
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnFileSystem.CFN_RESOURCE_TYPE_NAME = "AWS::FSx::FileSystem";
/**
 * Determine whether the given properties match those of a `LustreConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LustreConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_LustreConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('automaticBackupRetentionDays', cdk.validateNumber)(properties.automaticBackupRetentionDays));
    errors.collect(cdk.propertyValidator('copyTagsToBackups', cdk.validateBoolean)(properties.copyTagsToBackups));
    errors.collect(cdk.propertyValidator('dailyAutomaticBackupStartTime', cdk.validateString)(properties.dailyAutomaticBackupStartTime));
    errors.collect(cdk.propertyValidator('deploymentType', cdk.validateString)(properties.deploymentType));
    errors.collect(cdk.propertyValidator('exportPath', cdk.validateString)(properties.exportPath));
    errors.collect(cdk.propertyValidator('importPath', cdk.validateString)(properties.importPath));
    errors.collect(cdk.propertyValidator('importedFileChunkSize', cdk.validateNumber)(properties.importedFileChunkSize));
    errors.collect(cdk.propertyValidator('perUnitStorageThroughput', cdk.validateNumber)(properties.perUnitStorageThroughput));
    errors.collect(cdk.propertyValidator('weeklyMaintenanceStartTime', cdk.validateString)(properties.weeklyMaintenanceStartTime));
    return errors.wrap('supplied properties not correct for "LustreConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.LustreConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LustreConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.LustreConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemLustreConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_LustreConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AutomaticBackupRetentionDays: cdk.numberToCloudFormation(properties.automaticBackupRetentionDays),
        CopyTagsToBackups: cdk.booleanToCloudFormation(properties.copyTagsToBackups),
        DailyAutomaticBackupStartTime: cdk.stringToCloudFormation(properties.dailyAutomaticBackupStartTime),
        DeploymentType: cdk.stringToCloudFormation(properties.deploymentType),
        ExportPath: cdk.stringToCloudFormation(properties.exportPath),
        ImportPath: cdk.stringToCloudFormation(properties.importPath),
        ImportedFileChunkSize: cdk.numberToCloudFormation(properties.importedFileChunkSize),
        PerUnitStorageThroughput: cdk.numberToCloudFormation(properties.perUnitStorageThroughput),
        WeeklyMaintenanceStartTime: cdk.stringToCloudFormation(properties.weeklyMaintenanceStartTime),
    };
}
// @ts-ignore TS6133
function CfnFileSystemLustreConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        automaticBackupRetentionDays: properties.AutomaticBackupRetentionDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.AutomaticBackupRetentionDays) : undefined,
        copyTagsToBackups: properties.CopyTagsToBackups != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToBackups) : undefined,
        dailyAutomaticBackupStartTime: properties.DailyAutomaticBackupStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.DailyAutomaticBackupStartTime) : undefined,
        deploymentType: properties.DeploymentType != null ? cfn_parse.FromCloudFormation.getString(properties.DeploymentType) : undefined,
        exportPath: properties.ExportPath != null ? cfn_parse.FromCloudFormation.getString(properties.ExportPath) : undefined,
        importPath: properties.ImportPath != null ? cfn_parse.FromCloudFormation.getString(properties.ImportPath) : undefined,
        importedFileChunkSize: properties.ImportedFileChunkSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.ImportedFileChunkSize) : undefined,
        perUnitStorageThroughput: properties.PerUnitStorageThroughput != null ? cfn_parse.FromCloudFormation.getNumber(properties.PerUnitStorageThroughput) : undefined,
        weeklyMaintenanceStartTime: properties.WeeklyMaintenanceStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.WeeklyMaintenanceStartTime) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `SelfManagedActiveDirectoryConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `SelfManagedActiveDirectoryConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_SelfManagedActiveDirectoryConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('dnsIps', cdk.listValidator(cdk.validateString))(properties.dnsIps));
    errors.collect(cdk.propertyValidator('domainName', cdk.validateString)(properties.domainName));
    errors.collect(cdk.propertyValidator('fileSystemAdministratorsGroup', cdk.validateString)(properties.fileSystemAdministratorsGroup));
    errors.collect(cdk.propertyValidator('organizationalUnitDistinguishedName', cdk.validateString)(properties.organizationalUnitDistinguishedName));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('userName', cdk.validateString)(properties.userName));
    return errors.wrap('supplied properties not correct for "SelfManagedActiveDirectoryConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.SelfManagedActiveDirectoryConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `SelfManagedActiveDirectoryConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.SelfManagedActiveDirectoryConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemSelfManagedActiveDirectoryConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_SelfManagedActiveDirectoryConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DnsIps: cdk.listMapper(cdk.stringToCloudFormation)(properties.dnsIps),
        DomainName: cdk.stringToCloudFormation(properties.domainName),
        FileSystemAdministratorsGroup: cdk.stringToCloudFormation(properties.fileSystemAdministratorsGroup),
        OrganizationalUnitDistinguishedName: cdk.stringToCloudFormation(properties.organizationalUnitDistinguishedName),
        Password: cdk.stringToCloudFormation(properties.password),
        UserName: cdk.stringToCloudFormation(properties.userName),
    };
}
// @ts-ignore TS6133
function CfnFileSystemSelfManagedActiveDirectoryConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        dnsIps: properties.DnsIps != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DnsIps) : undefined,
        domainName: properties.DomainName != null ? cfn_parse.FromCloudFormation.getString(properties.DomainName) : undefined,
        fileSystemAdministratorsGroup: properties.FileSystemAdministratorsGroup != null ? cfn_parse.FromCloudFormation.getString(properties.FileSystemAdministratorsGroup) : undefined,
        organizationalUnitDistinguishedName: properties.OrganizationalUnitDistinguishedName != null ? cfn_parse.FromCloudFormation.getString(properties.OrganizationalUnitDistinguishedName) : undefined,
        password: properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined,
        userName: properties.UserName != null ? cfn_parse.FromCloudFormation.getString(properties.UserName) : undefined,
    };
}
/**
 * Determine whether the given properties match those of a `WindowsConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `WindowsConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnFileSystem_WindowsConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    errors.collect(cdk.propertyValidator('activeDirectoryId', cdk.validateString)(properties.activeDirectoryId));
    errors.collect(cdk.propertyValidator('automaticBackupRetentionDays', cdk.validateNumber)(properties.automaticBackupRetentionDays));
    errors.collect(cdk.propertyValidator('copyTagsToBackups', cdk.validateBoolean)(properties.copyTagsToBackups));
    errors.collect(cdk.propertyValidator('dailyAutomaticBackupStartTime', cdk.validateString)(properties.dailyAutomaticBackupStartTime));
    errors.collect(cdk.propertyValidator('deploymentType', cdk.validateString)(properties.deploymentType));
    errors.collect(cdk.propertyValidator('preferredSubnetId', cdk.validateString)(properties.preferredSubnetId));
    errors.collect(cdk.propertyValidator('selfManagedActiveDirectoryConfiguration', CfnFileSystem_SelfManagedActiveDirectoryConfigurationPropertyValidator)(properties.selfManagedActiveDirectoryConfiguration));
    errors.collect(cdk.propertyValidator('throughputCapacity', cdk.validateNumber)(properties.throughputCapacity));
    errors.collect(cdk.propertyValidator('weeklyMaintenanceStartTime', cdk.validateString)(properties.weeklyMaintenanceStartTime));
    return errors.wrap('supplied properties not correct for "WindowsConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FSx::FileSystem.WindowsConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `WindowsConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FSx::FileSystem.WindowsConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnFileSystemWindowsConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFileSystem_WindowsConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ActiveDirectoryId: cdk.stringToCloudFormation(properties.activeDirectoryId),
        AutomaticBackupRetentionDays: cdk.numberToCloudFormation(properties.automaticBackupRetentionDays),
        CopyTagsToBackups: cdk.booleanToCloudFormation(properties.copyTagsToBackups),
        DailyAutomaticBackupStartTime: cdk.stringToCloudFormation(properties.dailyAutomaticBackupStartTime),
        DeploymentType: cdk.stringToCloudFormation(properties.deploymentType),
        PreferredSubnetId: cdk.stringToCloudFormation(properties.preferredSubnetId),
        SelfManagedActiveDirectoryConfiguration: cfnFileSystemSelfManagedActiveDirectoryConfigurationPropertyToCloudFormation(properties.selfManagedActiveDirectoryConfiguration),
        ThroughputCapacity: cdk.numberToCloudFormation(properties.throughputCapacity),
        WeeklyMaintenanceStartTime: cdk.stringToCloudFormation(properties.weeklyMaintenanceStartTime),
    };
}
// @ts-ignore TS6133
function CfnFileSystemWindowsConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return properties;
    }
    properties = properties || {};
    return {
        activeDirectoryId: properties.ActiveDirectoryId != null ? cfn_parse.FromCloudFormation.getString(properties.ActiveDirectoryId) : undefined,
        automaticBackupRetentionDays: properties.AutomaticBackupRetentionDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.AutomaticBackupRetentionDays) : undefined,
        copyTagsToBackups: properties.CopyTagsToBackups != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CopyTagsToBackups) : undefined,
        dailyAutomaticBackupStartTime: properties.DailyAutomaticBackupStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.DailyAutomaticBackupStartTime) : undefined,
        deploymentType: properties.DeploymentType != null ? cfn_parse.FromCloudFormation.getString(properties.DeploymentType) : undefined,
        preferredSubnetId: properties.PreferredSubnetId != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredSubnetId) : undefined,
        selfManagedActiveDirectoryConfiguration: properties.SelfManagedActiveDirectoryConfiguration != null ? CfnFileSystemSelfManagedActiveDirectoryConfigurationPropertyFromCloudFormation(properties.SelfManagedActiveDirectoryConfiguration) : undefined,
        throughputCapacity: properties.ThroughputCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.ThroughputCapacity) : undefined,
        weeklyMaintenanceStartTime: properties.WeeklyMaintenanceStartTime != null ? cfn_parse.FromCloudFormation.getString(properties.WeeklyMaintenanceStartTime) : undefined,
    };
}
//# sourceMappingURL=data:application/json;base64,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