"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitBucketSourceAction = void 0;
const codepipeline = require("../../../aws-codepipeline"); // Automatically re-written from '@aws-cdk/aws-codepipeline'
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const action_1 = require("../action");
const common_1 = require("../common");
/**
 * A CodePipeline source action for BitBucket.
 *
 * @experimental
 */
class BitBucketSourceAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.SOURCE,
            owner: 'AWS',
            provider: 'CodeStarSourceConnection',
            artifactBounds: common_1.sourceArtifactBounds(),
            outputs: [props.output],
        });
        this.props = props;
    }
    bound(_scope, _stage, options) {
        var _a;
        // https://docs.aws.amazon.com/codepipeline/latest/userguide/security-iam.html#how-to-update-role-new-services
        options.role.addToPolicy(new iam.PolicyStatement({
            actions: [
                'codestar-connections:UseConnection',
            ],
            resources: [
                this.props.connectionArn,
            ],
        }));
        // the action needs to write the output to the pipeline bucket
        options.bucket.grantReadWrite(options.role);
        // if codeBuildCloneOutput is true,
        // save the connectionArn in the Artifact instance
        // to be read by the CodeBuildAction later
        if (this.props.codeBuildCloneOutput === true) {
            this.props.output.setMetadata(BitBucketSourceAction._CONNECTION_ARN_PROPERTY, this.props.connectionArn);
        }
        return {
            configuration: {
                ConnectionArn: this.props.connectionArn,
                FullRepositoryId: `${this.props.owner}/${this.props.repo}`,
                BranchName: (_a = this.props.branch) !== null && _a !== void 0 ? _a : 'master',
                OutputArtifactFormat: this.props.codeBuildCloneOutput === true
                    ? 'CODEBUILD_CLONE_REF'
                    : undefined,
            },
        };
    }
}
exports.BitBucketSourceAction = BitBucketSourceAction;
/**
 * The name of the property that holds the ARN of the CodeStar Connection
 * inside of the CodePipeline Artifact's metadata.
 *
 * @internal
 */
BitBucketSourceAction._CONNECTION_ARN_PROPERTY = 'CodeStarConnectionArnProperty';
//# sourceMappingURL=data:application/json;base64,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