import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::CodeBuild::Project`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 */
export interface CfnProjectProps {
    /**
     * `AWS::CodeBuild::Project.Artifacts`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-artifacts
     */
    readonly artifacts: CfnProject.ArtifactsProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.Environment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment
     */
    readonly environment: CfnProject.EnvironmentProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.ServiceRole`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-servicerole
     */
    readonly serviceRole: string;
    /**
     * `AWS::CodeBuild::Project.Source`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-source
     */
    readonly source: CfnProject.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.BadgeEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-badgeenabled
     */
    readonly badgeEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.Cache`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-cache
     */
    readonly cache?: CfnProject.ProjectCacheProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-description
     */
    readonly description?: string;
    /**
     * `AWS::CodeBuild::Project.EncryptionKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-encryptionkey
     */
    readonly encryptionKey?: string;
    /**
     * `AWS::CodeBuild::Project.FileSystemLocations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-filesystemlocations
     */
    readonly fileSystemLocations?: Array<CfnProject.ProjectFileSystemLocationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.LogsConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-logsconfig
     */
    readonly logsConfig?: CfnProject.LogsConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-name
     */
    readonly name?: string;
    /**
     * `AWS::CodeBuild::Project.QueuedTimeoutInMinutes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-queuedtimeoutinminutes
     */
    readonly queuedTimeoutInMinutes?: number;
    /**
     * `AWS::CodeBuild::Project.SecondaryArtifacts`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondaryartifacts
     */
    readonly secondaryArtifacts?: Array<CfnProject.ArtifactsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.SecondarySources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysources
     */
    readonly secondarySources?: Array<CfnProject.SourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.SecondarySourceVersions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysourceversions
     */
    readonly secondarySourceVersions?: Array<CfnProject.ProjectSourceVersionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.SourceVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-sourceversion
     */
    readonly sourceVersion?: string;
    /**
     * `AWS::CodeBuild::Project.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CodeBuild::Project.TimeoutInMinutes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-timeoutinminutes
     */
    readonly timeoutInMinutes?: number;
    /**
     * `AWS::CodeBuild::Project.Triggers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-triggers
     */
    readonly triggers?: CfnProject.ProjectTriggersProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-vpcconfig
     */
    readonly vpcConfig?: CfnProject.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CodeBuild::Project`
 *
 * @cloudformationResource AWS::CodeBuild::Project
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html
 */
export declare class CfnProject extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeBuild::Project";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnProject;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CodeBuild::Project.Artifacts`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-artifacts
     */
    artifacts: CfnProject.ArtifactsProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.Environment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-environment
     */
    environment: CfnProject.EnvironmentProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.ServiceRole`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-servicerole
     */
    serviceRole: string;
    /**
     * `AWS::CodeBuild::Project.Source`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-source
     */
    source: CfnProject.SourceProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::Project.BadgeEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-badgeenabled
     */
    badgeEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.Cache`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-cache
     */
    cache: CfnProject.ProjectCacheProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-description
     */
    description: string | undefined;
    /**
     * `AWS::CodeBuild::Project.EncryptionKey`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-encryptionkey
     */
    encryptionKey: string | undefined;
    /**
     * `AWS::CodeBuild::Project.FileSystemLocations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-filesystemlocations
     */
    fileSystemLocations: Array<CfnProject.ProjectFileSystemLocationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.LogsConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-logsconfig
     */
    logsConfig: CfnProject.LogsConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-name
     */
    name: string | undefined;
    /**
     * `AWS::CodeBuild::Project.QueuedTimeoutInMinutes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-queuedtimeoutinminutes
     */
    queuedTimeoutInMinutes: number | undefined;
    /**
     * `AWS::CodeBuild::Project.SecondaryArtifacts`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondaryartifacts
     */
    secondaryArtifacts: Array<CfnProject.ArtifactsProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.SecondarySources`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysources
     */
    secondarySources: Array<CfnProject.SourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.SecondarySourceVersions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-secondarysourceversions
     */
    secondarySourceVersions: Array<CfnProject.ProjectSourceVersionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.SourceVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-sourceversion
     */
    sourceVersion: string | undefined;
    /**
     * `AWS::CodeBuild::Project.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CodeBuild::Project.TimeoutInMinutes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-timeoutinminutes
     */
    timeoutInMinutes: number | undefined;
    /**
     * `AWS::CodeBuild::Project.Triggers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-triggers
     */
    triggers: CfnProject.ProjectTriggersProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeBuild::Project.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-project.html#cfn-codebuild-project-vpcconfig
     */
    vpcConfig: CfnProject.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::CodeBuild::Project`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProjectProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html
     */
    interface ArtifactsProperty {
        /**
         * `CfnProject.ArtifactsProperty.ArtifactIdentifier`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-artifactidentifier
         */
        readonly artifactIdentifier?: string;
        /**
         * `CfnProject.ArtifactsProperty.EncryptionDisabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-encryptiondisabled
         */
        readonly encryptionDisabled?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.ArtifactsProperty.Location`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-location
         */
        readonly location?: string;
        /**
         * `CfnProject.ArtifactsProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-name
         */
        readonly name?: string;
        /**
         * `CfnProject.ArtifactsProperty.NamespaceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-namespacetype
         */
        readonly namespaceType?: string;
        /**
         * `CfnProject.ArtifactsProperty.OverrideArtifactName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-overrideartifactname
         */
        readonly overrideArtifactName?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.ArtifactsProperty.Packaging`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-packaging
         */
        readonly packaging?: string;
        /**
         * `CfnProject.ArtifactsProperty.Path`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-path
         */
        readonly path?: string;
        /**
         * `CfnProject.ArtifactsProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-artifacts.html#cfn-codebuild-project-artifacts-type
         */
        readonly type: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-buildstatusconfig.html
     */
    interface BuildStatusConfigProperty {
        /**
         * `CfnProject.BuildStatusConfigProperty.Context`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-buildstatusconfig.html#cfn-codebuild-project-buildstatusconfig-context
         */
        readonly context?: string;
        /**
         * `CfnProject.BuildStatusConfigProperty.TargetUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-buildstatusconfig.html#cfn-codebuild-project-buildstatusconfig-targeturl
         */
        readonly targetUrl?: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html
     */
    interface CloudWatchLogsConfigProperty {
        /**
         * `CfnProject.CloudWatchLogsConfigProperty.GroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-groupname
         */
        readonly groupName?: string;
        /**
         * `CfnProject.CloudWatchLogsConfigProperty.Status`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-status
         */
        readonly status: string;
        /**
         * `CfnProject.CloudWatchLogsConfigProperty.StreamName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-cloudwatchlogsconfig.html#cfn-codebuild-project-cloudwatchlogsconfig-streamname
         */
        readonly streamName?: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html
     */
    interface EnvironmentProperty {
        /**
         * `CfnProject.EnvironmentProperty.Certificate`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-certificate
         */
        readonly certificate?: string;
        /**
         * `CfnProject.EnvironmentProperty.ComputeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-computetype
         */
        readonly computeType: string;
        /**
         * `CfnProject.EnvironmentProperty.EnvironmentVariables`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-environmentvariables
         */
        readonly environmentVariables?: Array<CfnProject.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnProject.EnvironmentProperty.Image`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-image
         */
        readonly image: string;
        /**
         * `CfnProject.EnvironmentProperty.ImagePullCredentialsType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-imagepullcredentialstype
         */
        readonly imagePullCredentialsType?: string;
        /**
         * `CfnProject.EnvironmentProperty.PrivilegedMode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-privilegedmode
         */
        readonly privilegedMode?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.EnvironmentProperty.RegistryCredential`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-registrycredential
         */
        readonly registryCredential?: CfnProject.RegistryCredentialProperty | cdk.IResolvable;
        /**
         * `CfnProject.EnvironmentProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environment.html#cfn-codebuild-project-environment-type
         */
        readonly type: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html
     */
    interface EnvironmentVariableProperty {
        /**
         * `CfnProject.EnvironmentVariableProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-name
         */
        readonly name: string;
        /**
         * `CfnProject.EnvironmentVariableProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-type
         */
        readonly type?: string;
        /**
         * `CfnProject.EnvironmentVariableProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-environmentvariable.html#cfn-codebuild-project-environmentvariable-value
         */
        readonly value: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-gitsubmodulesconfig.html
     */
    interface GitSubmodulesConfigProperty {
        /**
         * `CfnProject.GitSubmodulesConfigProperty.FetchSubmodules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-gitsubmodulesconfig.html#cfn-codebuild-project-gitsubmodulesconfig-fetchsubmodules
         */
        readonly fetchSubmodules: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html
     */
    interface LogsConfigProperty {
        /**
         * `CfnProject.LogsConfigProperty.CloudWatchLogs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-cloudwatchlogs
         */
        readonly cloudWatchLogs?: CfnProject.CloudWatchLogsConfigProperty | cdk.IResolvable;
        /**
         * `CfnProject.LogsConfigProperty.S3Logs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-logsconfig.html#cfn-codebuild-project-logsconfig-s3logs
         */
        readonly s3Logs?: CfnProject.S3LogsConfigProperty | cdk.IResolvable;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html
     */
    interface ProjectCacheProperty {
        /**
         * `CfnProject.ProjectCacheProperty.Location`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-location
         */
        readonly location?: string;
        /**
         * `CfnProject.ProjectCacheProperty.Modes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-modes
         */
        readonly modes?: string[];
        /**
         * `CfnProject.ProjectCacheProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectcache.html#cfn-codebuild-project-projectcache-type
         */
        readonly type: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html
     */
    interface ProjectFileSystemLocationProperty {
        /**
         * `CfnProject.ProjectFileSystemLocationProperty.Identifier`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-identifier
         */
        readonly identifier: string;
        /**
         * `CfnProject.ProjectFileSystemLocationProperty.Location`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-location
         */
        readonly location: string;
        /**
         * `CfnProject.ProjectFileSystemLocationProperty.MountOptions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-mountoptions
         */
        readonly mountOptions?: string;
        /**
         * `CfnProject.ProjectFileSystemLocationProperty.MountPoint`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-mountpoint
         */
        readonly mountPoint: string;
        /**
         * `CfnProject.ProjectFileSystemLocationProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectfilesystemlocation.html#cfn-codebuild-project-projectfilesystemlocation-type
         */
        readonly type: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectsourceversion.html
     */
    interface ProjectSourceVersionProperty {
        /**
         * `CfnProject.ProjectSourceVersionProperty.SourceIdentifier`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectsourceversion.html#cfn-codebuild-project-projectsourceversion-sourceidentifier
         */
        readonly sourceIdentifier: string;
        /**
         * `CfnProject.ProjectSourceVersionProperty.SourceVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projectsourceversion.html#cfn-codebuild-project-projectsourceversion-sourceversion
         */
        readonly sourceVersion?: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html
     */
    interface ProjectTriggersProperty {
        /**
         * `CfnProject.ProjectTriggersProperty.FilterGroups`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-filtergroups
         */
        readonly filterGroups?: Array<Array<CfnProject.WebhookFilterProperty | cdk.IResolvable> | cdk.IResolvable | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnProject.ProjectTriggersProperty.Webhook`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-projecttriggers.html#cfn-codebuild-project-projecttriggers-webhook
         */
        readonly webhook?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-registrycredential.html
     */
    interface RegistryCredentialProperty {
        /**
         * `CfnProject.RegistryCredentialProperty.Credential`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-registrycredential.html#cfn-codebuild-project-registrycredential-credential
         */
        readonly credential: string;
        /**
         * `CfnProject.RegistryCredentialProperty.CredentialProvider`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-registrycredential.html#cfn-codebuild-project-registrycredential-credentialprovider
         */
        readonly credentialProvider: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html
     */
    interface S3LogsConfigProperty {
        /**
         * `CfnProject.S3LogsConfigProperty.EncryptionDisabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-encryptiondisabled
         */
        readonly encryptionDisabled?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.S3LogsConfigProperty.Location`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-location
         */
        readonly location?: string;
        /**
         * `CfnProject.S3LogsConfigProperty.Status`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-s3logsconfig.html#cfn-codebuild-project-s3logsconfig-status
         */
        readonly status: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html
     */
    interface SourceProperty {
        /**
         * `CfnProject.SourceProperty.Auth`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-auth
         */
        readonly auth?: CfnProject.SourceAuthProperty | cdk.IResolvable;
        /**
         * `CfnProject.SourceProperty.BuildSpec`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildspec
         */
        readonly buildSpec?: string;
        /**
         * `CfnProject.SourceProperty.BuildStatusConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-buildstatusconfig
         */
        readonly buildStatusConfig?: CfnProject.BuildStatusConfigProperty | cdk.IResolvable;
        /**
         * `CfnProject.SourceProperty.GitCloneDepth`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitclonedepth
         */
        readonly gitCloneDepth?: number;
        /**
         * `CfnProject.SourceProperty.GitSubmodulesConfig`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-gitsubmodulesconfig
         */
        readonly gitSubmodulesConfig?: CfnProject.GitSubmodulesConfigProperty | cdk.IResolvable;
        /**
         * `CfnProject.SourceProperty.InsecureSsl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-insecuressl
         */
        readonly insecureSsl?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.SourceProperty.Location`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-location
         */
        readonly location?: string;
        /**
         * `CfnProject.SourceProperty.ReportBuildStatus`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-reportbuildstatus
         */
        readonly reportBuildStatus?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.SourceProperty.SourceIdentifier`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-sourceidentifier
         */
        readonly sourceIdentifier?: string;
        /**
         * `CfnProject.SourceProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-source.html#cfn-codebuild-project-source-type
         */
        readonly type: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html
     */
    interface SourceAuthProperty {
        /**
         * `CfnProject.SourceAuthProperty.Resource`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-resource
         */
        readonly resource?: string;
        /**
         * `CfnProject.SourceAuthProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-sourceauth.html#cfn-codebuild-project-sourceauth-type
         */
        readonly type: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnProject.VpcConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnProject.VpcConfigProperty.Subnets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-subnets
         */
        readonly subnets?: string[];
        /**
         * `CfnProject.VpcConfigProperty.VpcId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-vpcconfig.html#cfn-codebuild-project-vpcconfig-vpcid
         */
        readonly vpcId?: string;
    }
}
export declare namespace CfnProject {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html
     */
    interface WebhookFilterProperty {
        /**
         * `CfnProject.WebhookFilterProperty.ExcludeMatchedPattern`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html#cfn-codebuild-project-webhookfilter-excludematchedpattern
         */
        readonly excludeMatchedPattern?: boolean | cdk.IResolvable;
        /**
         * `CfnProject.WebhookFilterProperty.Pattern`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html#cfn-codebuild-project-webhookfilter-pattern
         */
        readonly pattern: string;
        /**
         * `CfnProject.WebhookFilterProperty.Type`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-project-webhookfilter.html#cfn-codebuild-project-webhookfilter-type
         */
        readonly type: string;
    }
}
/**
 * Properties for defining a `AWS::CodeBuild::ReportGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html
 */
export interface CfnReportGroupProps {
    /**
     * `AWS::CodeBuild::ReportGroup.ExportConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig
     */
    readonly exportConfig: CfnReportGroup.ReportExportConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::ReportGroup.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-type
     */
    readonly type: string;
    /**
     * `AWS::CodeBuild::ReportGroup.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-name
     */
    readonly name?: string;
    /**
     * `AWS::CodeBuild::ReportGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::CodeBuild::ReportGroup`
 *
 * @cloudformationResource AWS::CodeBuild::ReportGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html
 */
export declare class CfnReportGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeBuild::ReportGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnReportGroup;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::CodeBuild::ReportGroup.ExportConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig
     */
    exportConfig: CfnReportGroup.ReportExportConfigProperty | cdk.IResolvable;
    /**
     * `AWS::CodeBuild::ReportGroup.Type`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-type
     */
    type: string;
    /**
     * `AWS::CodeBuild::ReportGroup.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-name
     */
    name: string | undefined;
    /**
     * `AWS::CodeBuild::ReportGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::CodeBuild::ReportGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReportGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnReportGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html
     */
    interface ReportExportConfigProperty {
        /**
         * `CfnReportGroup.ReportExportConfigProperty.ExportConfigType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html#cfn-codebuild-reportgroup-reportexportconfig-exportconfigtype
         */
        readonly exportConfigType: string;
        /**
         * `CfnReportGroup.ReportExportConfigProperty.S3Destination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html#cfn-codebuild-reportgroup-reportexportconfig-s3destination
         */
        readonly s3Destination?: CfnReportGroup.S3ReportExportConfigProperty | cdk.IResolvable;
    }
}
export declare namespace CfnReportGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html
     */
    interface S3ReportExportConfigProperty {
        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-bucket
         */
        readonly bucket: string;
        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.EncryptionDisabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-encryptiondisabled
         */
        readonly encryptionDisabled?: boolean | cdk.IResolvable;
        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.EncryptionKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-encryptionkey
         */
        readonly encryptionKey?: string;
        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.Packaging`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-packaging
         */
        readonly packaging?: string;
        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.Path`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-path
         */
        readonly path?: string;
    }
}
/**
 * Properties for defining a `AWS::CodeBuild::SourceCredential`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html
 */
export interface CfnSourceCredentialProps {
    /**
     * `AWS::CodeBuild::SourceCredential.AuthType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-authtype
     */
    readonly authType: string;
    /**
     * `AWS::CodeBuild::SourceCredential.ServerType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-servertype
     */
    readonly serverType: string;
    /**
     * `AWS::CodeBuild::SourceCredential.Token`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-token
     */
    readonly token: string;
    /**
     * `AWS::CodeBuild::SourceCredential.Username`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-username
     */
    readonly username?: string;
}
/**
 * A CloudFormation `AWS::CodeBuild::SourceCredential`
 *
 * @cloudformationResource AWS::CodeBuild::SourceCredential
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html
 */
export declare class CfnSourceCredential extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeBuild::SourceCredential";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnSourceCredential;
    /**
     * `AWS::CodeBuild::SourceCredential.AuthType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-authtype
     */
    authType: string;
    /**
     * `AWS::CodeBuild::SourceCredential.ServerType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-servertype
     */
    serverType: string;
    /**
     * `AWS::CodeBuild::SourceCredential.Token`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-token
     */
    token: string;
    /**
     * `AWS::CodeBuild::SourceCredential.Username`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-sourcecredential.html#cfn-codebuild-sourcecredential-username
     */
    username: string | undefined;
    /**
     * Create a new `AWS::CodeBuild::SourceCredential`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSourceCredentialProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
