import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::AutoScaling::AutoScalingGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 */
export interface CfnAutoScalingGroupProps {
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MaxSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-maxsize
     */
    readonly maxSize: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MinSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-minsize
     */
    readonly minSize: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.AutoScalingGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-autoscalinggroupname
     */
    readonly autoScalingGroupName?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.AvailabilityZones`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-availabilityzones
     */
    readonly availabilityZones?: string[];
    /**
     * `AWS::AutoScaling::AutoScalingGroup.Cooldown`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-cooldown
     */
    readonly cooldown?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.DesiredCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity
     */
    readonly desiredCapacity?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.HealthCheckGracePeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-healthcheckgraceperiod
     */
    readonly healthCheckGracePeriod?: number;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.HealthCheckType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-healthchecktype
     */
    readonly healthCheckType?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-instanceid
     */
    readonly instanceId?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LaunchConfigurationName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-launchconfigurationname
     */
    readonly launchConfigurationName?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LaunchTemplate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-launchtemplate
     */
    readonly launchTemplate?: CfnAutoScalingGroup.LaunchTemplateSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecificationList`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecificationlist
     */
    readonly lifecycleHookSpecificationList?: Array<CfnAutoScalingGroup.LifecycleHookSpecificationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LoadBalancerNames`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-loadbalancernames
     */
    readonly loadBalancerNames?: string[];
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MaxInstanceLifetime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-maxinstancelifetime
     */
    readonly maxInstanceLifetime?: number;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MetricsCollection`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-metricscollection
     */
    readonly metricsCollection?: Array<CfnAutoScalingGroup.MetricsCollectionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-mixedinstancespolicy
     */
    readonly mixedInstancesPolicy?: CfnAutoScalingGroup.MixedInstancesPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.NewInstancesProtectedFromScaleIn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-newinstancesprotectedfromscalein
     */
    readonly newInstancesProtectedFromScaleIn?: boolean | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.NotificationConfigurations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations
     */
    readonly notificationConfigurations?: Array<CfnAutoScalingGroup.NotificationConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.PlacementGroup`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-placementgroup
     */
    readonly placementGroup?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.ServiceLinkedRoleARN`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-servicelinkedrolearn
     */
    readonly serviceLinkedRoleArn?: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-tags
     */
    readonly tags?: CfnAutoScalingGroup.TagPropertyProperty[];
    /**
     * `AWS::AutoScaling::AutoScalingGroup.TargetGroupARNs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-targetgrouparns
     */
    readonly targetGroupArns?: string[];
    /**
     * `AWS::AutoScaling::AutoScalingGroup.TerminationPolicies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-termpolicy
     */
    readonly terminationPolicies?: string[];
    /**
     * `AWS::AutoScaling::AutoScalingGroup.VPCZoneIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-vpczoneidentifier
     */
    readonly vpcZoneIdentifier?: string[];
}
/**
 * A CloudFormation `AWS::AutoScaling::AutoScalingGroup`
 *
 * @cloudformationResource AWS::AutoScaling::AutoScalingGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html
 */
export declare class CfnAutoScalingGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::AutoScalingGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnAutoScalingGroup;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MaxSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-maxsize
     */
    maxSize: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MinSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-minsize
     */
    minSize: string;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.AutoScalingGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-autoscalinggroupname
     */
    autoScalingGroupName: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.AvailabilityZones`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-availabilityzones
     */
    availabilityZones: string[] | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.Cooldown`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-cooldown
     */
    cooldown: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.DesiredCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-desiredcapacity
     */
    desiredCapacity: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.HealthCheckGracePeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-healthcheckgraceperiod
     */
    healthCheckGracePeriod: number | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.HealthCheckType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-healthchecktype
     */
    healthCheckType: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-instanceid
     */
    instanceId: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LaunchConfigurationName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-launchconfigurationname
     */
    launchConfigurationName: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LaunchTemplate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-launchtemplate
     */
    launchTemplate: CfnAutoScalingGroup.LaunchTemplateSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LifecycleHookSpecificationList`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecificationlist
     */
    lifecycleHookSpecificationList: Array<CfnAutoScalingGroup.LifecycleHookSpecificationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.LoadBalancerNames`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-loadbalancernames
     */
    loadBalancerNames: string[] | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MaxInstanceLifetime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-maxinstancelifetime
     */
    maxInstanceLifetime: number | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MetricsCollection`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-metricscollection
     */
    metricsCollection: Array<CfnAutoScalingGroup.MetricsCollectionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.MixedInstancesPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-mixedinstancespolicy
     */
    mixedInstancesPolicy: CfnAutoScalingGroup.MixedInstancesPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.NewInstancesProtectedFromScaleIn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-newinstancesprotectedfromscalein
     */
    newInstancesProtectedFromScaleIn: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.NotificationConfigurations`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-notificationconfigurations
     */
    notificationConfigurations: Array<CfnAutoScalingGroup.NotificationConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.PlacementGroup`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-placementgroup
     */
    placementGroup: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.ServiceLinkedRoleARN`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-autoscaling-autoscalinggroup-servicelinkedrolearn
     */
    serviceLinkedRoleArn: string | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.TargetGroupARNs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-targetgrouparns
     */
    targetGroupArns: string[] | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.TerminationPolicies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-termpolicy
     */
    terminationPolicies: string[] | undefined;
    /**
     * `AWS::AutoScaling::AutoScalingGroup.VPCZoneIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-group.html#cfn-as-group-vpczoneidentifier
     */
    vpcZoneIdentifier: string[] | undefined;
    /**
     * Create a new `AWS::AutoScaling::AutoScalingGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAutoScalingGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnAutoScalingGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html
     */
    interface InstancesDistributionProperty {
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.OnDemandAllocationStrategy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-ondemandallocationstrategy
         */
        readonly onDemandAllocationStrategy?: string;
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.OnDemandBaseCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-ondemandbasecapacity
         */
        readonly onDemandBaseCapacity?: number;
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.OnDemandPercentageAboveBaseCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-ondemandpercentageabovebasecapacity
         */
        readonly onDemandPercentageAboveBaseCapacity?: number;
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.SpotAllocationStrategy`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-spotallocationstrategy
         */
        readonly spotAllocationStrategy?: string;
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.SpotInstancePools`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-spotinstancepools
         */
        readonly spotInstancePools?: number;
        /**
         * `CfnAutoScalingGroup.InstancesDistributionProperty.SpotMaxPrice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-instancesdistribution.html#cfn-autoscaling-autoscalinggroup-instancesdistribution-spotmaxprice
         */
        readonly spotMaxPrice?: string;
    }
}
export declare namespace CfnAutoScalingGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplate.html
     */
    interface LaunchTemplateProperty {
        /**
         * `CfnAutoScalingGroup.LaunchTemplateProperty.LaunchTemplateSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplate.html#cfn-as-group-launchtemplate
         */
        readonly launchTemplateSpecification: CfnAutoScalingGroup.LaunchTemplateSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnAutoScalingGroup.LaunchTemplateProperty.Overrides`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplate.html#cfn-as-mixedinstancespolicy-overrides
         */
        readonly overrides?: Array<CfnAutoScalingGroup.LaunchTemplateOverridesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnAutoScalingGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplateoverrides.html
     */
    interface LaunchTemplateOverridesProperty {
        /**
         * `CfnAutoScalingGroup.LaunchTemplateOverridesProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplateoverrides.html#cfn-autoscaling-autoscalinggroup-launchtemplateoverrides-instancetype
         */
        readonly instanceType?: string;
        /**
         * `CfnAutoScalingGroup.LaunchTemplateOverridesProperty.WeightedCapacity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-mixedinstancespolicy-launchtemplateoverrides.html#cfn-autoscaling-autoscalinggroup-launchtemplateoverrides-weightedcapacity
         */
        readonly weightedCapacity?: string;
    }
}
export declare namespace CfnAutoScalingGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplatespecification.html
     */
    interface LaunchTemplateSpecificationProperty {
        /**
         * `CfnAutoScalingGroup.LaunchTemplateSpecificationProperty.LaunchTemplateId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplatespecification.html#cfn-autoscaling-autoscalinggroup-launchtemplatespecification-launchtemplateid
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnAutoScalingGroup.LaunchTemplateSpecificationProperty.LaunchTemplateName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplatespecification.html#cfn-autoscaling-autoscalinggroup-launchtemplatespecification-launchtemplatename
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnAutoScalingGroup.LaunchTemplateSpecificationProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-launchtemplatespecification.html#cfn-autoscaling-autoscalinggroup-launchtemplatespecification-version
         */
        readonly version: string;
    }
}
export declare namespace CfnAutoScalingGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html
     */
    interface LifecycleHookSpecificationProperty {
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.DefaultResult`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-defaultresult
         */
        readonly defaultResult?: string;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.HeartbeatTimeout`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-heartbeattimeout
         */
        readonly heartbeatTimeout?: number;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.LifecycleHookName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-lifecyclehookname
         */
        readonly lifecycleHookName: string;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.LifecycleTransition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-lifecycletransition
         */
        readonly lifecycleTransition: string;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.NotificationMetadata`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-notificationmetadata
         */
        readonly notificationMetadata?: string;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.NotificationTargetARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-notificationtargetarn
         */
        readonly notificationTargetArn?: string;
        /**
         * `CfnAutoScalingGroup.LifecycleHookSpecificationProperty.RoleARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-autoscalinggroup-lifecyclehookspecification.html#cfn-autoscaling-autoscalinggroup-lifecyclehookspecification-rolearn
         */
        readonly roleArn?: string;
    }
}
export declare namespace CfnAutoScalingGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-metricscollection.html
     */
    interface MetricsCollectionProperty {
        /**
         * `CfnAutoScalingGroup.MetricsCollectionProperty.Granularity`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-metricscollection.html#cfn-as-metricscollection-granularity
         */
        readonly granularity: string;
        /**
         * `CfnAutoScalingGroup.MetricsCollectionProperty.Metrics`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-metricscollection.html#cfn-as-metricscollection-metrics
         */
        readonly metrics?: string[];
    }
}
export declare namespace CfnAutoScalingGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-group-mixedinstancespolicy.html
     */
    interface MixedInstancesPolicyProperty {
        /**
         * `CfnAutoScalingGroup.MixedInstancesPolicyProperty.InstancesDistribution`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-group-mixedinstancespolicy.html#cfn-as-mixedinstancespolicy-instancesdistribution
         */
        readonly instancesDistribution?: CfnAutoScalingGroup.InstancesDistributionProperty | cdk.IResolvable;
        /**
         * `CfnAutoScalingGroup.MixedInstancesPolicyProperty.LaunchTemplate`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-as-group-mixedinstancespolicy.html#cfn-as-mixedinstancespolicy-launchtemplate
         */
        readonly launchTemplate: CfnAutoScalingGroup.LaunchTemplateProperty | cdk.IResolvable;
    }
}
export declare namespace CfnAutoScalingGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-notificationconfigurations.html
     */
    interface NotificationConfigurationProperty {
        /**
         * `CfnAutoScalingGroup.NotificationConfigurationProperty.NotificationTypes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-notificationconfigurations.html#cfn-as-group-notificationconfigurations-notificationtypes
         */
        readonly notificationTypes?: string[];
        /**
         * `CfnAutoScalingGroup.NotificationConfigurationProperty.TopicARN`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-notificationconfigurations.html#cfn-autoscaling-autoscalinggroup-notificationconfigurations-topicarn
         */
        readonly topicArn: string;
    }
}
export declare namespace CfnAutoScalingGroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-tags.html
     */
    interface TagPropertyProperty {
        /**
         * `CfnAutoScalingGroup.TagPropertyProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-tags.html#cfn-as-tags-Key
         */
        readonly key: string;
        /**
         * `CfnAutoScalingGroup.TagPropertyProperty.PropagateAtLaunch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-tags.html#cfn-as-tags-PropagateAtLaunch
         */
        readonly propagateAtLaunch: boolean | cdk.IResolvable;
        /**
         * `CfnAutoScalingGroup.TagPropertyProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-tags.html#cfn-as-tags-Value
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::AutoScaling::LaunchConfiguration`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html
 */
export interface CfnLaunchConfigurationProps {
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ImageId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-imageid
     */
    readonly imageId: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cf-as-launchconfig-associatepubip
     */
    readonly associatePublicIpAddress?: boolean | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-blockdevicemappings
     */
    readonly blockDeviceMappings?: Array<CfnLaunchConfiguration.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcid
     */
    readonly classicLinkVpcId?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCSecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcsecuritygroups
     */
    readonly classicLinkVpcSecurityGroups?: string[];
    /**
     * `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ebsoptimized
     */
    readonly ebsOptimized?: boolean | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.IamInstanceProfile`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-iaminstanceprofile
     */
    readonly iamInstanceProfile?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instanceid
     */
    readonly instanceId?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancemonitoring
     */
    readonly instanceMonitoring?: boolean | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.KernelId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-kernelid
     */
    readonly kernelId?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.KeyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-keyname
     */
    readonly keyName?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.LaunchConfigurationName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-autoscaling-launchconfig-launchconfigurationname
     */
    readonly launchConfigurationName?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.PlacementTenancy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-placementtenancy
     */
    readonly placementTenancy?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.RamDiskId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ramdiskid
     */
    readonly ramDiskId?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.SecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-securitygroups
     */
    readonly securityGroups?: string[];
    /**
     * `AWS::AutoScaling::LaunchConfiguration.SpotPrice`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-spotprice
     */
    readonly spotPrice?: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.UserData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-userdata
     */
    readonly userData?: string;
}
/**
 * A CloudFormation `AWS::AutoScaling::LaunchConfiguration`
 *
 * @cloudformationResource AWS::AutoScaling::LaunchConfiguration
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html
 */
export declare class CfnLaunchConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::LaunchConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnLaunchConfiguration;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ImageId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-imageid
     */
    imageId: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancetype
     */
    instanceType: string;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.AssociatePublicIpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cf-as-launchconfig-associatepubip
     */
    associatePublicIpAddress: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.BlockDeviceMappings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-blockdevicemappings
     */
    blockDeviceMappings: Array<CfnLaunchConfiguration.BlockDeviceMappingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcid
     */
    classicLinkVpcId: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.ClassicLinkVPCSecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-classiclinkvpcsecuritygroups
     */
    classicLinkVpcSecurityGroups: string[] | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.EbsOptimized`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ebsoptimized
     */
    ebsOptimized: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.IamInstanceProfile`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-iaminstanceprofile
     */
    iamInstanceProfile: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instanceid
     */
    instanceId: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.InstanceMonitoring`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-instancemonitoring
     */
    instanceMonitoring: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.KernelId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-kernelid
     */
    kernelId: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.KeyName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-keyname
     */
    keyName: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.LaunchConfigurationName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-autoscaling-launchconfig-launchconfigurationname
     */
    launchConfigurationName: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.PlacementTenancy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-placementtenancy
     */
    placementTenancy: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.RamDiskId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-ramdiskid
     */
    ramDiskId: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.SecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-securitygroups
     */
    securityGroups: string[] | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.SpotPrice`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-spotprice
     */
    spotPrice: string | undefined;
    /**
     * `AWS::AutoScaling::LaunchConfiguration.UserData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig.html#cfn-as-launchconfig-userdata
     */
    userData: string | undefined;
    /**
     * Create a new `AWS::AutoScaling::LaunchConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLaunchConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnLaunchConfiguration {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html
     */
    interface BlockDeviceProperty {
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.DeleteOnTermination`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-deleteonterm
         */
        readonly deleteOnTermination?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.Encrypted`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-encrypted
         */
        readonly encrypted?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.Iops`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-iops
         */
        readonly iops?: number;
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.SnapshotId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-snapshotid
         */
        readonly snapshotId?: string;
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.VolumeSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-volumesize
         */
        readonly volumeSize?: number;
        /**
         * `CfnLaunchConfiguration.BlockDeviceProperty.VolumeType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-template.html#cfn-as-launchconfig-blockdev-template-volumetype
         */
        readonly volumeType?: string;
    }
}
export declare namespace CfnLaunchConfiguration {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html
     */
    interface BlockDeviceMappingProperty {
        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.DeviceName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-devicename
         */
        readonly deviceName: string;
        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.Ebs`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-ebs
         */
        readonly ebs?: CfnLaunchConfiguration.BlockDeviceProperty | cdk.IResolvable;
        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.NoDevice`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-nodevice
         */
        readonly noDevice?: boolean | cdk.IResolvable;
        /**
         * `CfnLaunchConfiguration.BlockDeviceMappingProperty.VirtualName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-launchconfig-blockdev-mapping.html#cfn-as-launchconfig-blockdev-mapping-virtualname
         */
        readonly virtualName?: string;
    }
}
/**
 * Properties for defining a `AWS::AutoScaling::LifecycleHook`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html
 */
export interface CfnLifecycleHookProps {
    /**
     * `AWS::AutoScaling::LifecycleHook.AutoScalingGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-autoscalinggroupname
     */
    readonly autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.LifecycleTransition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-lifecycletransition
     */
    readonly lifecycleTransition: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.DefaultResult`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-defaultresult
     */
    readonly defaultResult?: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.HeartbeatTimeout`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-heartbeattimeout
     */
    readonly heartbeatTimeout?: number;
    /**
     * `AWS::AutoScaling::LifecycleHook.LifecycleHookName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-autoscaling-lifecyclehook-lifecyclehookname
     */
    readonly lifecycleHookName?: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.NotificationMetadata`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-notificationmetadata
     */
    readonly notificationMetadata?: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.NotificationTargetARN`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-notificationtargetarn
     */
    readonly notificationTargetArn?: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.RoleARN`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-rolearn
     */
    readonly roleArn?: string;
}
/**
 * A CloudFormation `AWS::AutoScaling::LifecycleHook`
 *
 * @cloudformationResource AWS::AutoScaling::LifecycleHook
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html
 */
export declare class CfnLifecycleHook extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::LifecycleHook";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnLifecycleHook;
    /**
     * `AWS::AutoScaling::LifecycleHook.AutoScalingGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-autoscalinggroupname
     */
    autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.LifecycleTransition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-lifecycletransition
     */
    lifecycleTransition: string;
    /**
     * `AWS::AutoScaling::LifecycleHook.DefaultResult`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-defaultresult
     */
    defaultResult: string | undefined;
    /**
     * `AWS::AutoScaling::LifecycleHook.HeartbeatTimeout`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-heartbeattimeout
     */
    heartbeatTimeout: number | undefined;
    /**
     * `AWS::AutoScaling::LifecycleHook.LifecycleHookName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-autoscaling-lifecyclehook-lifecyclehookname
     */
    lifecycleHookName: string | undefined;
    /**
     * `AWS::AutoScaling::LifecycleHook.NotificationMetadata`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-notificationmetadata
     */
    notificationMetadata: string | undefined;
    /**
     * `AWS::AutoScaling::LifecycleHook.NotificationTargetARN`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-notificationtargetarn
     */
    notificationTargetArn: string | undefined;
    /**
     * `AWS::AutoScaling::LifecycleHook.RoleARN`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-lifecyclehook.html#cfn-as-lifecyclehook-rolearn
     */
    roleArn: string | undefined;
    /**
     * Create a new `AWS::AutoScaling::LifecycleHook`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLifecycleHookProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::AutoScaling::ScalingPolicy`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html
 */
export interface CfnScalingPolicyProps {
    /**
     * `AWS::AutoScaling::ScalingPolicy.AutoScalingGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-autoscalinggroupname
     */
    readonly autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.AdjustmentType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-adjustmenttype
     */
    readonly adjustmentType?: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.Cooldown`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-cooldown
     */
    readonly cooldown?: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.EstimatedInstanceWarmup`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-estimatedinstancewarmup
     */
    readonly estimatedInstanceWarmup?: number;
    /**
     * `AWS::AutoScaling::ScalingPolicy.MetricAggregationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-metricaggregationtype
     */
    readonly metricAggregationType?: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.MinAdjustmentMagnitude`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-minadjustmentmagnitude
     */
    readonly minAdjustmentMagnitude?: number;
    /**
     * `AWS::AutoScaling::ScalingPolicy.PolicyType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-policytype
     */
    readonly policyType?: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.ScalingAdjustment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-scalingadjustment
     */
    readonly scalingAdjustment?: number;
    /**
     * `AWS::AutoScaling::ScalingPolicy.StepAdjustments`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-stepadjustments
     */
    readonly stepAdjustments?: Array<CfnScalingPolicy.StepAdjustmentProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration
     */
    readonly targetTrackingConfiguration?: CfnScalingPolicy.TargetTrackingConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AutoScaling::ScalingPolicy`
 *
 * @cloudformationResource AWS::AutoScaling::ScalingPolicy
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html
 */
export declare class CfnScalingPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::ScalingPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnScalingPolicy;
    /**
     * `AWS::AutoScaling::ScalingPolicy.AutoScalingGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-autoscalinggroupname
     */
    autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::ScalingPolicy.AdjustmentType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-adjustmenttype
     */
    adjustmentType: string | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.Cooldown`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-cooldown
     */
    cooldown: string | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.EstimatedInstanceWarmup`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-estimatedinstancewarmup
     */
    estimatedInstanceWarmup: number | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.MetricAggregationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-metricaggregationtype
     */
    metricAggregationType: string | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.MinAdjustmentMagnitude`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-minadjustmentmagnitude
     */
    minAdjustmentMagnitude: number | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.PolicyType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-policytype
     */
    policyType: string | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.ScalingAdjustment`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-scalingadjustment
     */
    scalingAdjustment: number | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.StepAdjustments`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-as-scalingpolicy-stepadjustments
     */
    stepAdjustments: Array<CfnScalingPolicy.StepAdjustmentProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AutoScaling::ScalingPolicy.TargetTrackingConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-as-policy.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration
     */
    targetTrackingConfiguration: CfnScalingPolicy.TargetTrackingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AutoScaling::ScalingPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScalingPolicyProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnScalingPolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html
     */
    interface CustomizedMetricSpecificationProperty {
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Dimensions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html#cfn-autoscaling-scalingpolicy-customizedmetricspecification-dimensions
         */
        readonly dimensions?: Array<CfnScalingPolicy.MetricDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.MetricName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html#cfn-autoscaling-scalingpolicy-customizedmetricspecification-metricname
         */
        readonly metricName: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Namespace`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html#cfn-autoscaling-scalingpolicy-customizedmetricspecification-namespace
         */
        readonly namespace: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Statistic`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html#cfn-autoscaling-scalingpolicy-customizedmetricspecification-statistic
         */
        readonly statistic: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Unit`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-customizedmetricspecification.html#cfn-autoscaling-scalingpolicy-customizedmetricspecification-unit
         */
        readonly unit?: string;
    }
}
export declare namespace CfnScalingPolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-metricdimension.html
     */
    interface MetricDimensionProperty {
        /**
         * `CfnScalingPolicy.MetricDimensionProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-metricdimension.html#cfn-autoscaling-scalingpolicy-metricdimension-name
         */
        readonly name: string;
        /**
         * `CfnScalingPolicy.MetricDimensionProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-metricdimension.html#cfn-autoscaling-scalingpolicy-metricdimension-value
         */
        readonly value: string;
    }
}
export declare namespace CfnScalingPolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-predefinedmetricspecification.html
     */
    interface PredefinedMetricSpecificationProperty {
        /**
         * `CfnScalingPolicy.PredefinedMetricSpecificationProperty.PredefinedMetricType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-autoscaling-scalingpolicy-predefinedmetricspecification-predefinedmetrictype
         */
        readonly predefinedMetricType: string;
        /**
         * `CfnScalingPolicy.PredefinedMetricSpecificationProperty.ResourceLabel`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-autoscaling-scalingpolicy-predefinedmetricspecification-resourcelabel
         */
        readonly resourceLabel?: string;
    }
}
export declare namespace CfnScalingPolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-stepadjustments.html
     */
    interface StepAdjustmentProperty {
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.MetricIntervalLowerBound`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-stepadjustments.html#cfn-autoscaling-scalingpolicy-stepadjustment-metricintervallowerbound
         */
        readonly metricIntervalLowerBound?: number;
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.MetricIntervalUpperBound`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-stepadjustments.html#cfn-autoscaling-scalingpolicy-stepadjustment-metricintervalupperbound
         */
        readonly metricIntervalUpperBound?: number;
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.ScalingAdjustment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-stepadjustments.html#cfn-autoscaling-scalingpolicy-stepadjustment-scalingadjustment
         */
        readonly scalingAdjustment: number;
    }
}
export declare namespace CfnScalingPolicy {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html
     */
    interface TargetTrackingConfigurationProperty {
        /**
         * `CfnScalingPolicy.TargetTrackingConfigurationProperty.CustomizedMetricSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration-customizedmetricspecification
         */
        readonly customizedMetricSpecification?: CfnScalingPolicy.CustomizedMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingConfigurationProperty.DisableScaleIn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration-disablescalein
         */
        readonly disableScaleIn?: boolean | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingConfigurationProperty.PredefinedMetricSpecification`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration-predefinedmetricspecification
         */
        readonly predefinedMetricSpecification?: CfnScalingPolicy.PredefinedMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingConfigurationProperty.TargetValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscaling-scalingpolicy-targettrackingconfiguration.html#cfn-autoscaling-scalingpolicy-targettrackingconfiguration-targetvalue
         */
        readonly targetValue: number;
    }
}
/**
 * Properties for defining a `AWS::AutoScaling::ScheduledAction`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html
 */
export interface CfnScheduledActionProps {
    /**
     * `AWS::AutoScaling::ScheduledAction.AutoScalingGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-asgname
     */
    readonly autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::ScheduledAction.DesiredCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-desiredcapacity
     */
    readonly desiredCapacity?: number;
    /**
     * `AWS::AutoScaling::ScheduledAction.EndTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-endtime
     */
    readonly endTime?: string;
    /**
     * `AWS::AutoScaling::ScheduledAction.MaxSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-maxsize
     */
    readonly maxSize?: number;
    /**
     * `AWS::AutoScaling::ScheduledAction.MinSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-minsize
     */
    readonly minSize?: number;
    /**
     * `AWS::AutoScaling::ScheduledAction.Recurrence`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-recurrence
     */
    readonly recurrence?: string;
    /**
     * `AWS::AutoScaling::ScheduledAction.StartTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-starttime
     */
    readonly startTime?: string;
}
/**
 * A CloudFormation `AWS::AutoScaling::ScheduledAction`
 *
 * @cloudformationResource AWS::AutoScaling::ScheduledAction
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html
 */
export declare class CfnScheduledAction extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScaling::ScheduledAction";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnScheduledAction;
    /**
     * `AWS::AutoScaling::ScheduledAction.AutoScalingGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-asgname
     */
    autoScalingGroupName: string;
    /**
     * `AWS::AutoScaling::ScheduledAction.DesiredCapacity`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-desiredcapacity
     */
    desiredCapacity: number | undefined;
    /**
     * `AWS::AutoScaling::ScheduledAction.EndTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-endtime
     */
    endTime: string | undefined;
    /**
     * `AWS::AutoScaling::ScheduledAction.MaxSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-maxsize
     */
    maxSize: number | undefined;
    /**
     * `AWS::AutoScaling::ScheduledAction.MinSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-minsize
     */
    minSize: number | undefined;
    /**
     * `AWS::AutoScaling::ScheduledAction.Recurrence`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-recurrence
     */
    recurrence: string | undefined;
    /**
     * `AWS::AutoScaling::ScheduledAction.StartTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-as-scheduledaction.html#cfn-as-scheduledaction-starttime
     */
    startTime: string | undefined;
    /**
     * Create a new `AWS::AutoScaling::ScheduledAction`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScheduledActionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
