"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Model = exports.ErrorModel = exports.EmptyModel = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
const restapi_1 = require("./restapi");
const util = require("./util");
/**
 * Represents a reference to a REST API's Empty model, which is available
 * as part of the model collection by default. This can be used for mapping
 * JSON responses from an integration to what is returned to a client,
 * where strong typing is not required. In the absence of any defined
 * model, the Empty model will be used to return the response payload
 * unmapped.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Empty Schema",
 *   "type" : "object"
 * }
 *
 * @see https://docs.amazonaws.cn/en_us/apigateway/latest/developerguide/models-mappings.html#models-mappings-models
 * @deprecated You should use @see Model.EMPTY_MODEL
 */
class EmptyModel {
    constructor() {
        this.modelId = 'Empty';
    }
}
exports.EmptyModel = EmptyModel;
/**
 * Represents a reference to a REST API's Error model, which is available
 * as part of the model collection by default. This can be used for mapping
 * error JSON responses from an integration to a client, where a simple
 * generic message field is sufficient to map and return an error payload.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Error Schema",
 *   "type" : "object",
 *   "properties" : {
 *     "message" : { "type" : "string" }
 *   }
 * }
 * @deprecated You should use @see Model.ERROR_MODEL
 */
class ErrorModel {
    constructor() {
        this.modelId = 'Error';
    }
}
exports.ErrorModel = ErrorModel;
class Model extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            physicalName: props.modelName,
        });
        const modelProps = {
            name: this.physicalName,
            restApiId: props.restApi.restApiId,
            contentType: (_a = props.contentType) !== null && _a !== void 0 ? _a : 'application/json',
            description: props.description,
            schema: util.JsonSchemaMapper.toCfnJsonSchema(props.schema),
        };
        const resource = new apigateway_generated_1.CfnModel(this, 'Resource', modelProps);
        this.modelId = this.getResourceNameAttribute(resource.ref);
        const deployment = (props.restApi instanceof restapi_1.RestApi) ? props.restApi.latestDeployment : undefined;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({ model: modelProps });
        }
    }
    static fromModelName(scope, id, modelName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.modelId = modelName;
            }
        }
        return new Import(scope, id);
    }
}
exports.Model = Model;
/**
 * Represents a reference to a REST API's Error model, which is available
 * as part of the model collection by default. This can be used for mapping
 * error JSON responses from an integration to a client, where a simple
 * generic message field is sufficient to map and return an error payload.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Error Schema",
 *   "type" : "object",
 *   "properties" : {
 *     "message" : { "type" : "string" }
 *   }
 * }
 */
Model.ERROR_MODEL = new ErrorModel();
/**
 * Represents a reference to a REST API's Empty model, which is available
 * as part of the model collection by default. This can be used for mapping
 * JSON responses from an integration to what is returned to a client,
 * where strong typing is not required. In the absence of any defined
 * model, the Empty model will be used to return the response payload
 * unmapped.
 *
 * Definition
 * {
 *   "$schema" : "http://json-schema.org/draft-04/schema#",
 *   "title" : "Empty Schema",
 *   "type" : "object"
 * }
 *
 * @see https://docs.amazonaws.cn/en_us/apigateway/latest/developerguide/models-mappings.html#models-mappings-models
 */
Model.EMPTY_MODEL = new EmptyModel();
//# sourceMappingURL=data:application/json;base64,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