# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2021-11-23T15:53:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Extra, Field, constr


class Type(Enum):
    """
    This attribute specifies how the boolean shall be considered. In this schema the only possible option is as a value.
    """

    value = 'value'


class AttributePointers(Enum):
    """
    The attribute pointer values are strings which define the type of the attribute.
    """

    num = 'num'
    text = 'text'
    boolean = 'boolean'
    vec = 'vec'


class Type1(Enum):
    """
    Type of the element data pointed by this pointer.
    """

    bbox = 'bbox'
    rbbox = 'rbbox'
    num = 'num'
    text = 'text'
    boolean = 'boolean'
    poly2d = 'poly2d'
    poly3d = 'poly3d'
    cuboid = 'cuboid'
    image = 'image'
    mat = 'mat'
    binary = 'binary'
    point2d = 'point2d'
    point3d = 'point3d'
    vec = 'vec'
    line_reference = 'line_reference'
    area_reference = 'area_reference'
    mesh = 'mesh'


class FrameInterval(BaseModel):
    """
    A frame interval defines a starting and ending frame number as a closed interval. That means the interval includes the limit frame numbers.
    """

    class Config:
        extra = Extra.forbid

    frame_end: Optional[int] = Field(
        None, description='Ending frame number of the interval.'
    )
    frame_start: Optional[int] = Field(
        None, description='Initial frame number of the interval.'
    )


class SchemaVersion(Enum):
    """
    Version number of the OpenLABEL schema this annotation JSON object follows.
    """

    field_1_0_0 = '1.0.0'


class Metadata(BaseModel):
    """
    This JSON object contains information, that is, metadata, about the annotation file itself.
    """

    class Config:
        extra = Extra.allow

    annotator: Optional[str] = Field(
        None,
        description='Name or description of the annotator that created the annotations.',
    )
    comment: Optional[str] = Field(
        None,
        description='Additional information or description about the annotation content.',
    )
    file_version: Optional[str] = Field(
        None, description='Version number of the OpenLABEL annotation content.'
    )
    name: Optional[str] = Field(
        None, description='Name of the OpenLABEL annotation content.'
    )
    schema_version: SchemaVersion = Field(
        ...,
        description='Version number of the OpenLABEL schema this annotation JSON object follows.',
    )
    tagged_file: Optional[str] = Field(
        None, description='File name or URI of the data file being tagged.'
    )


class Type2(Enum):
    """
    This attribute specifies whether the number shall be considered as a value, a minimum, or a maximum in its context.
    """

    value = 'value'
    min = 'min'
    max = 'max'


class BoundaryMode(Enum):
    include = 'include'
    exclude = 'exclude'


class OntologyItem(BaseModel):
    class Config:
        extra = Extra.allow

    boundary_list: Optional[List[str]] = None
    boundary_mode: Optional[BoundaryMode] = None
    uri: str


class Ontology(BaseModel):
    __root__: Union[str, OntologyItem] = Field(
        ...,
        description='This is the JSON object of OpenLABEL ontologies. Ontology keys are strings containing numerical UIDs or 32 bytes UUIDs. Ontology values may be strings, for example, encoding a URI. JSON objects containing a URI string and optional lists of included and excluded terms.',
    )


class Type3(Enum):
    """
    The OpenLABEL type of element.
    """

    object = 'object'
    action = 'action'
    event = 'event'
    context = 'context'


class RdfAgent(BaseModel):
    """
    An RDF agent is either an RDF semantic object or subject.
    """

    type: Optional[Type3] = Field(None, description='The OpenLABEL type of element.')
    uid: Optional[str] = Field(
        None, description='The element UID this RDF agent refers to.'
    )


class ResourceUid(BaseModel):
    __root__: str = Field(
        ...,
        description='This is a JSON object that contains links to external resources. Resource_uid keys are strings containing numerical UIDs or 32 bytes UUIDs. Resource_uid values are strings describing the identifier of the element in the external resource.',
    )


class Resource(BaseModel):
    __root__: str = Field(
        ...,
        description='This is the JSON object of OpenLABEL resources. Resource keys are strings containing numerical UIDs or 32 bytes UUIDs. Resource values are strings that describe an external resource, for example, file name, URLs, that may be used to link data of the OpenLABEL annotation content with external existing content.',
    )


class StreamProperty(BaseModel):
    """
    This JSON object defines an instance of the intrinsic parameters of a fisheye camera.
    """

    class Config:
        extra = Extra.allow

    center_x_px: Optional[Optional[float]] = Field(
        None,
        description='x-coordinate (horizontal) of the principal point of projection.',
    )
    center_y_px: Optional[Optional[float]] = Field(
        None,
        description='y-coordinate (vertical) of the principal point of projection.',
    )
    focal_length_x: Optional[Optional[float]] = Field(
        None, description='Horizontal focal length (x-axis) in pixels.'
    )
    focal_length_y: Optional[Optional[float]] = Field(
        None, description='Vertical focal length (y-axis) in pixels.'
    )
    height_px: Optional[int] = Field(
        None, description='Height of the image frame in pixels.'
    )
    lens_coeffs: Optional[List[float]] = Field(
        None,
        description='This is the list of N values for the lens coefficients.',
        max_items=5,
        min_items=4,
    )
    width_px: Optional[int] = Field(
        None, description='Width of the image frame in pixels.'
    )


class StreamProperty1(BaseModel):
    """
    This JSON object defines an instance of the intrinsic parameters of a pinhole camera.
    """

    class Config:
        extra = Extra.allow

    camera_matrix: Optional[List[float]] = Field(
        None,
        description='This is a 3x4 camera matrix which projects 3D homogeneous points (4x1) from a camera coordinate system into the image plane (3x1). This is the usual K matrix for camera projection as in OpenCV. It is extended from 3x3 to 3x4 to enable its direct utilisation to project 4x1 homogeneous 3D points. The matrix is defined to follow the camera model: x-to-right, y-down, z-forward. The following equation applies: x_img = camera_matrix * X_ccs.',
        max_items=12,
        min_items=12,
    )
    distortion_coeffs: Optional[List[float]] = Field(
        None,
        description='This is the array 1xN radial and tangential distortion coefficients.',
        max_items=14,
        min_items=5,
    )
    height_px: Optional[int] = None
    width_px: Optional[int] = None


class Type4(Enum):
    """
    A string encoding the type of the stream.
    """

    camera = 'camera'
    lidar = 'lidar'
    radar = 'radar'
    gps_imu = 'gps_imu'
    other = 'other'


class Stream(BaseModel):
    """
    A stream describes the source of a data sequence, usually a sensor.
    """

    class Config:
        extra = Extra.forbid

    description: Optional[str] = Field(None, description='Description of the stream.')
    stream_properties: Optional[
        Union[Dict[str, Any], StreamProperty, StreamProperty1]
    ] = Field(None, description='Properties of the stream.')
    type: Optional[Type4] = Field(
        None, description='A string encoding the type of the stream.'
    )
    uri: Optional[str] = Field(
        None,
        description='A string encoding the URI, for example, a URL, or file name, for example, a video file name, the stream corresponds to.',
    )


class SyncItem(BaseModel):
    frame_stream: Optional[int] = Field(
        None,
        description='This is the internal frame number inside the stream this OpenLABEL frame corresponds to.',
    )
    timestamp: Optional[Union[str, float]] = Field(
        None,
        description='The timestamp indicates a time instant as a string or numerical value to describe this frame.',
    )


class SyncItem1(BaseModel):
    frame_shift: Optional[int] = Field(
        None,
        description="Fixed shift or difference between the OpenLABEL master frame count and this stream's internal frame count.",
    )


class Sync(BaseModel):
    __root__: Union[SyncItem, SyncItem1] = Field(
        ..., description='This is the sync information for this stream.'
    )


class TransformDatum(BaseModel):
    class Config:
        extra = Extra.forbid

    matrix4x4: List[float] = Field(
        ...,
        description='Flattened list of 16 entries encoding a 4x4 homogeneous matrix to enable transform 3D column homogeneous vectors 4x1 using right-multiplication of matrices: X_dst = matrix_4x4 * X_src.',
    )


class TransformDatum1(BaseModel):
    """
    A transform can be defined with a quaternion to encode the rotation of a coordinate system with respect to another, and a translation.
    """

    class Config:
        extra = Extra.forbid

    quaternion: List[float] = Field(
        ...,
        description='List of 4 values encoding a quaternion (x, y, z, w).',
        max_items=4,
        min_items=4,
    )
    translation: List[float] = Field(
        ...,
        description='List of 3 values encoding the translation vector (x, y, z)',
        max_items=3,
        min_items=3,
    )


class TransformDatum2(BaseModel):
    """
    A transform can be defined with a sequence of Euler angles to encode the rotation of a coordinate system with respect to another and a translation.
    """

    class Config:
        extra = Extra.forbid

    euler_angles: List[float] = Field(
        ...,
        description='List of 3 values encoding Euler angle values.',
        max_items=3,
        min_items=3,
    )
    sequence: Optional[str] = Field(
        None,
        description='The sequence as a string of 3 characters defining the axis of the Euler angles and their order of application, for example, "ZYX". The default is "ZYX".',
    )
    translation: List[float] = Field(
        ...,
        description='List of 3 values encoding the translation vector (x, y, z)',
        max_items=3,
        min_items=3,
    )


class TransformData(BaseModel):
    __root__: Union[TransformDatum, TransformDatum1, TransformDatum2] = Field(
        ..., description='JSON object containing the transform data.'
    )


class Type6(Enum):
    """
    This attribute specifies whether the vector shall be considered as a descriptor of individual values or as a definition of a range.
    """

    values = 'values'
    range = 'range'


class CoordinateSystem(BaseModel):
    """
    A coordinate system is a 3D reference frame. Spatial information on objects and their properties can be defined with respect to coordinate systems.
    """

    class Config:
        extra = Extra.allow

    children: Optional[List[str]] = Field(
        None, description='List of children of this coordinate system.'
    )
    parent: str = Field(
        ...,
        description='This is the string UID of the parent coordinate system this coordinate system is referring to.',
    )
    pose_wrt_parent: Optional[TransformData] = None
    type: str = Field(
        ...,
        description='This is a string that describes the type of the coordinate system, for example, "local", "geo").',
    )


class ElementDataPointer(BaseModel):
    """
    This item contains pointers to element data of elements, indexed by "name", and containing information about the element data type, for example, bounding box, cuboid, and the frame intervals in which this element_data exists within an element. That means, these pointers can be used to explore element data dynamic information within the JSON content.
    """

    attribute_pointers: Optional[Dict[constr(regex=r'^'), AttributePointers]] = Field(
        None,
        description='This is a JSON object which contains pointers to the attributes of the element data pointed by this pointer. The attributes pointer keys shall be the "name" of the attribute of the element data this pointer points to.',
    )
    frame_intervals: List[FrameInterval] = Field(
        ...,
        description='List of frame intervals of the element data pointed by this pointer.',
    )
    type: Optional[Type1] = Field(
        None, description='Type of the element data pointed by this pointer.'
    )


class Relation(BaseModel):
    """
    A relation is a type of element which connects two or more other elements, for example, objects, actions, contexts, or events. RDF triples are used to structure the connection with one or more subjects, a predicate, and one or more semantic objects.
    """

    class Config:
        extra = Extra.forbid

    frame_intervals: Optional[List[FrameInterval]] = Field(
        None,
        description='The array of frame intervals where this relation exists or is defined.',
    )
    name: str = Field(
        ...,
        description='Name of the relation. It is a friendly name and not used for indexing.',
    )
    ontology_uid: Optional[str] = Field(
        None,
        description='This is the UID of the ontology where the type of this relation is defined.',
    )
    rdf_objects: List[RdfAgent] = Field(
        ..., description='This is the list of RDF semantic objects of this relation.'
    )
    rdf_subjects: List[RdfAgent] = Field(
        ..., description='This is the list of RDF semantic subjects of this relation.'
    )
    resource_uid: Optional[ResourceUid] = None
    type: str = Field(
        ...,
        description='The type of a relation defines the class the predicated of the relation corresponds to.',
    )


class Transform(BaseModel):
    """
    This is a JSON object with information about this transform.
    """

    class Config:
        extra = Extra.allow

    dst: str = Field(
        ...,
        description='The string UID, that is, the name, of the destination coordinate system for geometric data converted with this transform.',
    )
    src: str = Field(
        ...,
        description='The string UID, that is, the name, of the source coordinate system of geometrical data this transform converts.',
    )
    transform_src_to_dst: TransformData


class FrameProperties(BaseModel):
    """
    This is a JSON object which contains information about this frame.
    """

    class Config:
        extra = Extra.allow

    streams: Optional[Dict[constr(regex=r'^'), Stream]] = Field(
        None,
        description='Streams is a JSON object which contains OpenLABEL streams with specific information for this frame. Stream keys can be any string, for example, a friendly stream name.',
    )
    timestamp: Optional[Union[str, float]] = Field(
        None,
        description='The timestamp indicates a time instant as a string or numerical value to describe this frame.',
    )
    transforms: Optional[Dict[constr(regex=r'^'), Transform]] = Field(
        None,
        description='Transforms is a JSON object which contains OpenLABEL transforms specific for this frame. Transform keys can be any string, for example, a friendly name of a transform.',
    )


class OpenLabelAnnotation(BaseModel):
    class Config:
        extra = Extra.forbid

    openlabel: Openlabel


class Action(BaseModel):
    """
    An action is a type of element intended to describe temporal situations with semantic load as a certain activity happening in real life, such as crossing-zebra-cross, standing-still, playing-guitar. As such, actions are defined by their type, the frame intervals in which the action happens, and any additional action data, for example, numbers, booleans, text as attributes of the actions.
    """

    class Config:
        extra = Extra.forbid

    action_data: Optional[ActionData] = None
    action_data_pointers: Optional[
        Dict[constr(regex=r'^'), ElementDataPointer]
    ] = Field(
        None,
        description='This is a JSON object which contains OpenLABEL element data pointers. Element data pointer keys shall be the "name" of the element data this pointer points to.',
    )
    frame_intervals: Optional[List[FrameInterval]] = Field(
        None,
        description='The array of frame intervals where this action exists or is defined.',
    )
    name: str = Field(
        ...,
        description='Name of the action. It is a friendly name and not used for indexing.',
    )
    ontology_uid: Optional[str] = Field(
        None,
        description='This is the UID of the ontology where the type of this action is defined.',
    )
    resource_uid: Optional[ResourceUid] = None
    type: str = Field(
        ...,
        description='The type of an action defines the class the action corresponds to.',
    )


class ActionData(BaseModel):
    """
    Additional data to describe attributes of the action.
    """

    class Config:
        extra = Extra.forbid

    boolean: Optional[List[Boolean]] = Field(
        None, description='List of "boolean" that describe this action.'
    )
    num: Optional[List[Num]] = Field(
        None, description='List of "num" that describe this action.'
    )
    text: Optional[List[Text]] = Field(
        None, description='List of "text" that describe this action.'
    )
    vec: Optional[List[Vec]] = Field(
        None, description='List of "vec" that describe this action.'
    )


class AreaReference(BaseModel):
    """
    An area reference is a JSON object which defines the area of a set of 3D line segments by means of defining the indexes of all lines which outline the area. Note that coplanar 3D lines are assumed.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    name: Optional[str] = Field(
        None,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    reference_type: Optional[str] = Field(
        None,
        description='This is the type of the reference as a string with the name of the element data (e.g. line_reference)',
    )
    val: Optional[List[float]] = Field(
        None,
        description='The array of indexes of the references of type reference_type.',
    )


class Attributes(BaseModel):
    """
    Attributes is the alias of element data that can be nested inside geometric object data. For example, a certain bounding box can have attributes related to its score, visibility, etc. These values can be nested inside the bounding box as attributes.
    """

    class Config:
        extra = Extra.forbid

    boolean: Optional[List[Boolean]] = None
    num: Optional[List[Num]] = None
    text: Optional[List[Text]] = None
    vec: Optional[List[Vec]] = None


class Bbox(BaseModel):
    """
    A 2D bounding box is defined as a 4-dimensional vector [x, y, w, h], where [x, y] is the center of the bounding box and [w, h] represent the width (horizontal, x-coordinate dimension) and height (vertical, y-coordinate dimension), respectively.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    name: str = Field(
        ...,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    val: List[float] = Field(
        ...,
        description='The array of 4 values that define the [x, y, w, h] values of the bbox.',
        max_items=4,
        min_items=4,
    )


class Binary(BaseModel):
    """
    A binary payload.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    data_type: str = Field(
        ...,
        description='This is a string that declares the type of the values of the binary object.',
    )
    encoding: str = Field(
        ...,
        description='This is a string that declares the encoding type of the bytes for this binary payload, for example, "base64".',
    )
    name: str = Field(
        ...,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    val: str = Field(
        ..., description='A string with the encoded bytes of this binary payload.'
    )


class Boolean(BaseModel):
    """
    A boolean.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    name: Optional[str] = Field(
        None,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    type: Optional[Type] = Field(
        None,
        description='This attribute specifies how the boolean shall be considered. In this schema the only possible option is as a value.',
    )
    val: bool = Field(..., description='The boolean value.')


class Context(BaseModel):
    """
    A context is a type of element which defines any nonspatial or temporal annotation. Contexts can be used to add richness to the contextual information of a scene, including location, weather, application-related information.
    """

    class Config:
        extra = Extra.forbid

    context_data: Optional[ContextData] = None
    context_data_pointers: Optional[
        Dict[constr(regex=r'^'), ElementDataPointer]
    ] = Field(
        None,
        description='This is a JSON object which contains OpenLABEL element data pointers. Element data pointer keys shall be the "name" of the element data this pointer points to.',
    )
    frame_intervals: Optional[List[FrameInterval]] = Field(
        None,
        description='The array of frame intervals where this context exists or is defined.',
    )
    name: str = Field(
        ...,
        description='Name of the context. It is a friendly name and not used for indexing.',
    )
    ontology_uid: Optional[str] = Field(
        None,
        description='This is the UID of the ontology where the type of this context is defined.',
    )
    resource_uid: Optional[ResourceUid] = None
    type: str = Field(
        ...,
        description='The type of a context defines the class the context corresponds to.',
    )


class ContextData(BaseModel):
    """
    Additional data to describe attributes of the context.
    """

    class Config:
        extra = Extra.forbid

    boolean: Optional[List[Boolean]] = Field(
        None, description='List of "boolean" that describe this context.'
    )
    num: Optional[List[Num]] = Field(
        None, description='List of "num" that describe this context.'
    )
    text: Optional[List[Text]] = Field(
        None, description='List of "text" that describe this context.'
    )
    vec: Optional[List[Vec]] = Field(
        None, description='List of "vec" that describe this context.'
    )


class Cuboid(BaseModel):
    """
    A cuboid or 3D bounding box. It is defined by the position of its center, the rotation in 3D, and its dimensions.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    name: str = Field(
        ...,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    val: Optional[List[float]] = Field(
        ...,
        description='List of values encoding the position, rotation and dimensions. Two options are supported, using 9 or 10 values. If 9 values are used, the format is (x, y, z, rx, ry, rz, sx, sy, sz), where (x, y, z) encodes the position, (rx, ry, rz) encodes the Euler angles that encode the rotation, and (sx, sy, sz) are the dimensions of the cuboid in its object coordinate system. If 10 values are used, then the format is (x, y, z, qx, qy, qz, qw, sx, sy, sz) with the only difference of the rotation values which are the 4 values of a quaternion.',
    )


class Event(BaseModel):
    """
    An event is an instantaneous situation that happens without a temporal interval. Events complement actions providing a mechanism to specify triggers or to connect actions and objects with causality relations.
    """

    class Config:
        extra = Extra.forbid

    event_data: Optional[EventData] = None
    event_data_pointers: Optional[Dict[constr(regex=r'^'), ElementDataPointer]] = Field(
        None,
        description='This is a JSON object which contains OpenLABEL element data pointers. Element data pointer keys shall be the "name" of the element data this pointer points to.',
    )
    frame_intervals: Optional[List[FrameInterval]] = Field(
        None,
        description='The array of frame intervals where this event exists or is defined. Note that events are thought to be instantaneous. That means, they are defined for a single frame interval where the starting and ending frames are the same.',
    )
    name: str = Field(
        ...,
        description='Name of the event. It is a friendly name and not used for indexing.',
    )
    ontology_uid: Optional[str] = Field(
        None,
        description='This is the UID of the ontology where the type of this event is defined.',
    )
    resource_uid: Optional[ResourceUid] = None
    type: str = Field(
        ...,
        description='The type of an event defines the class the event corresponds to.',
    )


class EventData(BaseModel):
    """
    Additional data to describe attributes of the event.
    """

    class Config:
        extra = Extra.forbid

    boolean: Optional[List[Boolean]] = Field(
        None, description='List of "boolean" that describe this event.'
    )
    num: Optional[List[Num]] = Field(
        None, description='List of "num" that describe this event.'
    )
    text: Optional[List[Text]] = Field(
        None, description='List of "text" that describe this event.'
    )
    vec: Optional[List[Vec]] = Field(
        None, description='List of "vec" that describe this event.'
    )


class Actions(BaseModel):
    class Config:
        extra = Extra.forbid

    action_data: Optional[ActionData] = None


class Contexts(BaseModel):
    class Config:
        extra = Extra.forbid

    context_data: Optional[ContextData] = None


class Events(BaseModel):
    class Config:
        extra = Extra.forbid

    event_data: Optional[EventData] = None


class Objects(BaseModel):
    class Config:
        extra = Extra.forbid

    object_data: Optional[ObjectData] = None


class Frame(BaseModel):
    """
    A frame is a container of dynamic, timewise, information.
    """

    class Config:
        extra = Extra.forbid

    actions: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Actions,
        ]
    ] = Field(
        None,
        description='This is a JSON object that contains dynamic information on OpenLABEL actions. Action keys are strings containing numerical UIDs or 32 bytes UUIDs. Action values may contain an "action_data" JSON object.',
    )
    contexts: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Contexts,
        ]
    ] = Field(
        None,
        description='This is a JSON object that contains dynamic information on OpenLABEL contexts. Context keys are strings containing numerical UIDs or 32 bytes UUIDs. Context values may contain a "context_data" JSON object.',
    )
    events: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Events,
        ]
    ] = Field(
        None,
        description='This is a JSON object that contains dynamic information on OpenLABEL events. Event keys are strings containing numerical UIDs or 32 bytes UUIDs. Event values may contain an "event_data" JSON object.',
    )
    frame_properties: Optional[FrameProperties] = Field(
        None,
        description='This is a JSON object which contains information about this frame.',
    )
    objects: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Objects,
        ]
    ] = Field(
        None,
        description='This is a JSON object that contains dynamic information on OpenLABEL objects. Object keys are strings containing numerical UIDs or 32 bytes UUIDs. Object values may contain an "object_data" JSON object.',
    )
    relations: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Any,
        ]
    ] = Field(
        None,
        description='This is a JSON object that contains dynamic information of OpenLABEL relations. Relation keys are strings containing numerical UIDs or 32 bytes UUIDs. Relation values are empty. The presence of a key-value relation pair indicates the specified relation exists in this frame.',
    )


class Image(BaseModel):
    """
    An image.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    encoding: str = Field(
        ...,
        description='This is a string that declares the encoding type of the bytes for this image, for example, "base64".',
    )
    mime_type: str = Field(
        ...,
        description='This is a string that declares the MIME (multipurpose internet mail extensions) of the image, for example, "image/gif".',
    )
    name: str = Field(
        ...,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    val: str = Field(..., description='A string with the encoded bytes of this image.')


class LineReference(BaseModel):
    """
    A line reference is a JSON object which defines a 3D line segment by means of defining the indexes of its two extreme points.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    name: Optional[str] = Field(
        None,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    reference_type: Optional[str] = Field(
        None,
        description='This is the type of the reference as a string with the name of the element data (e.g. point3d)',
    )
    val: Optional[List[float]] = Field(
        None,
        description='The array of indexes of the references of type reference_type.',
        max_items=2,
        min_items=2,
    )


class Mat(BaseModel):
    """
    A matrix.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    channels: float = Field(..., description='Number of channels of the matrix.')
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    data_type: str = Field(
        ...,
        description='This is a string that declares the type of the numerical values of the matrix, for example, "float".',
    )
    height: float = Field(
        ..., description='Height of the matrix. Expressed in number of rows.'
    )
    name: str = Field(
        ...,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    val: List[float] = Field(..., description='Flattened list of values of the matrix.')
    width: float = Field(
        ..., description='Width of the matrix. Expressed in number of columns.'
    )


class Mesh(BaseModel):
    """
    A mesh encodes a point-line-area structure. It is intended to represent flat 3D meshes, such as several connected parking lots, where points, lines and areas composing the mesh are interrelated and can have their own properties.
    """

    class Config:
        extra = Extra.allow

    area_reference: Optional[Dict[constr(regex=r'^[0-9]+$'), AreaReference]] = Field(
        None,
        description='This is the JSON object for the areas defined for this mesh. Area keys are strings containing numerical UIDs.',
    )
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    line_reference: Optional[Dict[constr(regex=r'^[0-9]+$'), LineReference]] = Field(
        None,
        description='This is the JSON object for the 3D lines defined for this mesh. Line reference keys are strings containing numerical UIDs.',
    )
    name: Optional[str] = Field(
        None,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    point3d: Optional[Dict[constr(regex=r'^[0-9]+$'), Point3d]] = Field(
        None,
        description='This is the JSON object for the 3D points defined for this mesh. Point3d keys are strings containing numerical UIDs.',
    )


class Num(BaseModel):
    """
    A number.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    name: Optional[str] = Field(
        None,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    type: Optional[Type2] = Field(
        None,
        description='This attribute specifies whether the number shall be considered as a value, a minimum, or a maximum in its context.',
    )
    val: float = Field(..., description='The numerical value of the number.')


class Object(BaseModel):
    """
    An object is the main type of annotation element. Object is designed to represent spatiotemporal entities, such as physical objects in the real world. Objects shall have a name and type. Objects may have static and dynamic data. Objects are the only type of elements that may have geometric data, such as bounding boxes, cuboids, polylines, images, etc.
    """

    class Config:
        extra = Extra.forbid

    coordinate_system: Optional[str] = Field(
        None,
        description='This is the string key of the coordinate system this object is referenced with respect to.',
    )
    frame_intervals: Optional[List[FrameInterval]] = Field(
        None,
        description='The array of frame intervals where this object exists or is defined.',
    )
    name: str = Field(
        ...,
        description='Name of the object. It is a friendly name and not used for indexing.',
    )
    object_data: Optional[ObjectData] = None
    object_data_pointers: Optional[
        Dict[constr(regex=r'^'), ElementDataPointer]
    ] = Field(
        None,
        description='This is a JSON object which contains OpenLABEL element data pointers. Element data pointer keys shall be the "name" of the element data this pointer points to.',
    )
    ontology_uid: Optional[str] = Field(
        None,
        description='This is the UID of the ontology where the type of this object is defined.',
    )
    resource_uid: Optional[ResourceUid] = None
    type: str = Field(
        ...,
        description='The type of an object defines the class the object corresponds to.',
    )


class ObjectData(BaseModel):
    """
    Additional data to describe attributes of the object.
    """

    class Config:
        extra = Extra.forbid

    area_reference: Optional[List[AreaReference]] = Field(
        None, description='List of "area_reference" that describe this object.'
    )
    bbox: Optional[List[Bbox]] = Field(
        None, description='List of "bbox" that describe this object.'
    )
    binary: Optional[List[Binary]] = Field(
        None, description='List of "binary" that describe this object.'
    )
    boolean: Optional[List[Boolean]] = Field(
        None, description='List of "boolean" that describe this object.'
    )
    cuboid: Optional[List[Cuboid]] = Field(
        None, description='List of "cuboid" that describe this object.'
    )
    image: Optional[List[Image]] = Field(
        None, description='List of "image" that describe this object.'
    )
    line_reference: Optional[List[LineReference]] = Field(
        None, description='List of "line_reference" that describe this object.'
    )
    mat: Optional[List[Mat]] = Field(
        None, description='List of "mat" that describe this object.'
    )
    mesh: Optional[List[Mesh]] = Field(
        None, description='List of "mesh" that describe this object.'
    )
    num: Optional[List[Num]] = Field(
        None, description='List of "num" that describe this object.'
    )
    point2d: Optional[List[Point2d]] = Field(
        None, description='List of "point2d" that describe this object.'
    )
    point3d: Optional[List[Point3d]] = Field(
        None, description='List of "point3d" that describe this object.'
    )
    poly2d: Optional[List[Poly2d]] = Field(
        None, description='List of "poly2d" that describe this object.'
    )
    poly3d: Optional[List[Poly3d]] = Field(
        None, description='List of "poly3d" that describe this object.'
    )
    rbbox: Optional[List[Rbbox]] = Field(
        None, description='List of "rbbox" that describe this object.'
    )
    text: Optional[List[Text]] = Field(
        None, description='List of "text" that describe this object.'
    )
    vec: Optional[List[Vec]] = Field(
        None, description='List of "vec" that describe this object.'
    )


class Openlabel(BaseModel):
    """
    The OpenLABEL root JSON object, which contains all other JSON objects.
    """

    class Config:
        extra = Extra.forbid

    actions: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Action,
        ]
    ] = Field(
        None,
        description='This is the JSON object of OpenLABEL actions. Action keys are strings containing numerical UIDs or 32 bytes UUIDs.',
    )
    contexts: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Context,
        ]
    ] = Field(
        None,
        description='This is the JSON object of OpenLABEL contexts. Context keys are strings containing numerical UIDs or 32 bytes UUIDs.',
    )
    coordinate_systems: Optional[Dict[constr(regex=r'^'), CoordinateSystem]] = Field(
        None,
        description='This is a JSON object which contains OpenLABEL  coordinate systems. Coordinate system keys can be any string, for  example. a friendly coordinate system name.',
    )
    events: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Event,
        ]
    ] = Field(
        None,
        description='This is the JSON object of OpenLABEL events. Event keys are strings containing numerical UIDs or 32 bytes UUIDs.',
    )
    frame_intervals: Optional[List] = Field(
        None, description='This is an array of frame intervals.'
    )
    frames: Optional[Dict[constr(regex=r'^[0-9]+$'), Frame]] = Field(
        None,
        description='This is the JSON object of frames that contain the dynamic, timewise, annotations. Keys are strings containing numerical frame identifiers, which are denoted as master frame numbers.',
    )
    metadata: Metadata
    objects: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Object,
        ]
    ] = Field(
        None,
        description='This is the JSON object of OpenLABEL objects. Object keys are strings containing numerical UIDs or 32 bytes UUIDs.',
    )
    ontologies: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Ontology,
        ]
    ] = Field(
        None,
        description='This is the JSON object of OpenLABEL ontologies. Ontology keys are strings containing numerical UIDs or 32 bytes UUIDs. Ontology values may be strings, for example, encoding a URI. JSON objects containing a URI string and optional lists of included and excluded terms.',
    )
    relations: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Relation,
        ]
    ] = Field(
        None,
        description='This is the JSON object of OpenLABEL relations. Relation keys are strings containing numerical UIDs or 32 bytes UUIDs.',
    )
    resources: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Resource,
        ]
    ] = None
    streams: Optional[Dict[constr(regex=r'^'), Stream]] = Field(
        None,
        description='This is a JSON object which contains OpenLABEL streams.  Stream keys can be any string, for example, a friendly stream name.',
    )
    tags: Optional[
        Dict[
            constr(
                regex=r'^(-?[0-9]+|[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$'
            ),
            Tag,
        ]
    ] = Field(
        None,
        description='This is the JSON object of tags. Tag keys are strings containing numerical UIDs or 32 bytes UUIDs.',
    )


class Point2d(BaseModel):
    """
    A 2D point.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    id: Optional[int] = Field(
        None,
        description='This is an integer identifier of the point in the context of a set of points.',
    )
    name: str = Field(
        ...,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    val: List[float] = Field(
        ...,
        description='List of two coordinates to define the point, for example, x, y.',
        max_items=2,
        min_items=2,
    )


class Point3d(BaseModel):
    """
    A 3D point.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    id: Optional[int] = Field(
        None,
        description='This is an integer identifier of the point in the context of a set of points.',
    )
    name: str = Field(
        ...,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    val: List[float] = Field(
        ...,
        description='List of three coordinates to define the point, for example, x, y, z.',
        max_items=3,
        min_items=3,
    )


class Poly2d(BaseModel):
    """
    A 2D polyline defined as a sequence of 2D points.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    closed: bool = Field(
        ...,
        description='A boolean that defines whether the polyline is closed or not. In case it is closed, it is assumed that the last point of the sequence is connected with the first one.',
    )
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    hierarchy: Optional[List[int]] = Field(
        None,
        description='Hierarchy of the 2D polyline in the context of a set of 2D polylines.',
        max_items=4,
        min_items=4,
    )
    mode: str = Field(
        ...,
        description='Mode of the polyline list of values: "MODE_POLY2D_ABSOLUTE" determines that the poly2d list contains the sequence of (x, y) values of all points of the polyline. "MODE_POLY2D_RELATIVE" specifies that only the first point of the sequence is defined with its (x, y) values, while all the rest are defined relative to it. "MODE_POLY2D_SRF6DCC" specifies that SRF6DCC chain code method is used. "MODE_POLY2D_RS6FCC" specifies that the RS6FCC method is used.',
    )
    name: str = Field(
        ...,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    val: Union[List[str], List[float]] = Field(
        ...,
        description='List of numerical values of the polyline, according to its mode.',
    )


class Poly3d(BaseModel):
    """
    A 3D polyline defined as a sequence of 3D points.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    closed: bool = Field(
        ...,
        description='A boolean that defines whether the polyline is closed or not. In case it is closed, it is assumed that the last point of the sequence is connected with the first one.',
    )
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    name: str = Field(
        ...,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    val: List[float] = Field(
        ...,
        description='List of numerical values of the polyline, according to its mode.',
    )


class Rbbox(BaseModel):
    """
    A 2D rotated bounding box is defined as a 5-dimensional vector [x, y, w, h, alpha], where [x, y] is the center of the bounding box and [w, h] represent the width (horizontal, x-coordinate dimension) and height (vertical, y-coordinate dimension), respectively. The angle alpha, in radians, represents the rotation of the rotated bounding box, and is defined as a right-handed rotation, that is, positive from x to y axes, and with the origin of rotation placed at the center of the bounding box (that is, [x, y]).
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    name: str = Field(
        ...,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    val: List[float] = Field(
        ...,
        description='The array of 5 values that define the [x, y, w, h, alpha] values of the bbox.',
        max_items=5,
        min_items=5,
    )


class Tag(BaseModel):
    """
    A tag is a special type of label that can be attached to any type of content, such as images, data containers, folders. In ASAM OpenLABEL the main purpose of a tag is to allow adding metadata to scenario descriptions.
    """

    class Config:
        extra = Extra.allow

    ontology_uid: str = Field(
        ...,
        description='This is the UID of the ontology where the type of this tag is defined.',
    )
    resource_uid: Optional[ResourceUid] = None
    tag_data: Optional[TagData] = None
    type: str = Field(
        ..., description='The type of a tag defines the class the tag corresponds to.'
    )


class TagDatum(BaseModel):
    class Config:
        extra = Extra.forbid

    boolean: Optional[List[Boolean]] = Field(
        None, description='List of "boolean" that describe this tag.'
    )
    num: Optional[List[Num]] = Field(
        None, description='List of "num" that describe this tag.'
    )
    text: Optional[List[Text]] = Field(
        None, description='List of "text" that describe this tag.'
    )
    vec: Optional[List[Vec]] = Field(
        None, description='List of "vec" that describe this tag.'
    )


class TagData(BaseModel):
    __root__: Union[TagDatum, str] = Field(
        ...,
        description='Tag data can be a JSON object or a string which contains additional information about this tag.',
    )


class Text(BaseModel):
    """
    A text.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    name: Optional[str] = Field(
        None,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    type: Optional[Type] = Field(
        None,
        description='This attribute specifies how the text shall be considered. The only possible option is as a value.',
    )
    val: str = Field(..., description='The characters of the text.')


class Vec(BaseModel):
    """
    A vector (list) of numbers or strings.
    """

    class Config:
        extra = Extra.allow

    attributes: Optional[Attributes] = None
    coordinate_system: Optional[str] = Field(
        None,
        description='Name of the coordinate system in respect of which this object data is expressed.',
    )
    name: Optional[str] = Field(
        None,
        description='This is a string encoding the name of this object data. It is used as index inside the corresponding object data pointers.',
    )
    type: Optional[Type6] = Field(
        None,
        description='This attribute specifies whether the vector shall be considered as a descriptor of individual values or as a definition of a range.',
    )
    val: List[Union[float, str]] = Field(
        ..., description='The numerical values of the vector (list) of numbers.'
    )


OpenLabelAnnotation.update_forward_refs()
Action.update_forward_refs()
ActionData.update_forward_refs()
AreaReference.update_forward_refs()
Attributes.update_forward_refs()
Context.update_forward_refs()
ContextData.update_forward_refs()
Event.update_forward_refs()
EventData.update_forward_refs()
Objects.update_forward_refs()
Mesh.update_forward_refs()
Object.update_forward_refs()
ObjectData.update_forward_refs()
Openlabel.update_forward_refs()
Tag.update_forward_refs()
TagDatum.update_forward_refs()
