# these notes are all upper-cased to allow for multiple reference styles:
# Eb-2 / eb-2, etc..
NOTE_TO_MIDI = {
    "C-2": 0,
    "DB-2": 1,
    "D-2": 2,
    "EB-2": 3,
    "E-2": 4,
    "F-2": 5,
    "GB-2": 6,
    "G-2": 7,
    "AB-2": 8,
    "A-2": 9,
    "BB-2": 10,
    "B-2": 11,
    "C-1": 12,
    "DB-1": 13,
    "D-1": 14,
    "EB-1": 15,
    "E-1": 16,
    "F-1": 17,
    "GB-1": 18,
    "G-1": 19,
    "AB-1": 20,
    "A-1": 21,
    "BB-1": 22,
    "B-1": 23,
    "C0": 24,
    "DB0": 25,
    "D0": 26,
    "EB0": 27,
    "E0": 28,
    "F0": 29,
    "GB0": 30,
    "G0": 31,
    "AB0": 32,
    "A0": 33,
    "BB0": 34,
    "B0": 35,
    "C1": 36,
    "DB1": 37,
    "D1": 38,
    "EB1": 39,
    "E1": 40,
    "F1": 41,
    "GB1": 42,
    "G1": 43,
    "AB1": 44,
    "A1": 45,
    "BB1": 46,
    "B1": 47,
    "C2": 48,
    "DB2": 49,
    "D2": 50,
    "EB2": 51,
    "E2": 52,
    "F2": 53,
    "GB2": 54,
    "G2": 55,
    "AB2": 56,
    "A2": 57,
    "BB2": 58,
    "B2": 59,
    "C3": 60,
    "DB3": 61,
    "D3": 62,
    "EB3": 63,
    "E3": 64,
    "F3": 65,
    "GB3": 66,
    "G3": 67,
    "AB3": 68,
    "A3": 69,
    "BB3": 70,
    "B3": 71,
    "C4": 72,
    "DB4": 73,
    "D4": 74,
    "EB4": 75,
    "E4": 76,
    "F4": 77,
    "GB4": 78,
    "G4": 79,
    "AB4": 80,
    "A4": 81,
    "BB4": 82,
    "B4": 83,
    "C5": 84,
    "DB5": 85,
    "D5": 86,
    "EB5": 87,
    "E5": 88,
    "F5": 89,
    "GB5": 90,
    "G5": 91,
    "AB5": 92,
    "A5": 93,
    "BB5": 94,
    "B5": 95,
    "C6": 96,
    "DB6": 97,
    "D6": 98,
    "EB6": 99,
    "E6": 100,
    "F6": 101,
    "GB6": 102,
    "G6": 103,
    "AB6": 104,
    "A6": 105,
    "BB6": 106,
    "B6": 107,
    "C7": 108,
    "DB7": 109,
    "D7": 110,
    "EB7": 111,
    "E7": 112,
    "F7": 113,
    "GB7": 114,
    "G7": 115,
    "AB7": 116,
    "A7": 117,
    "BB7": 118,
    "B7": 119,
    "C8": 120,
    "DB8": 121,
    "D8": 122,
    "EB8": 123,
    "E8": 124,
    "F8": 125,
    "GB8": 126,
    "G8": 127,
}

MIDI_TO_NOTE = {m: n for n, m in NOTE_TO_MIDI.items()}

NOTE_EQUIVALENTS = {"C#": "DB", "D#": "EB", "F#": "GB", "G#": "AB", "A#": "BB"}

ROOT_TO_MIDI = {
    "C": 0,
    "DB": 1,
    "D": 2,
    "EB": 3,
    "E": 4,
    "F": 5,
    "GB": 6,
    "G": 7,
    "AB": 8,
    "A": 9,
    "BB": 10,
    "B": 11,
}

NOTE_TO_FREQ = {
    "C0": 16.35,
    "DB0": 17.32,
    "D0": 18.35,
    "EB0": 19.45,
    "E0": 20.6,
    "F0": 21.83,
    "GB0": 23.12,
    "G0": 24.5,
    "AB0": 25.96,
    "A0": 27.5,
    "BB0": 29.14,
    "B0": 30.87,
    "C1": 32.7,
    "DB1": 34.65,
    "D1": 36.71,
    "EB1": 38.89,
    "E1": 41.2,
    "F1": 43.65,
    "GB1": 46.25,
    "G1": 49,
    "AB1": 51.91,
    "A1": 55,
    "BB1": 58.27,
    "B1": 61.74,
    "C2": 65.41,
    "DB2": 69.3,
    "D2": 73.42,
    "EB2": 77.78,
    "E2": 82.41,
    "F2": 87.31,
    "GB2": 92.5,
    "G2": 98,
    "AB2": 103.83,
    "A2": 110,
    "BB2": 116.54,
    "B2": 123.47,
    "C3": 130.81,
    "DB3": 138.59,
    "D3": 146.83,
    "EB3": 155.56,
    "E3": 164.81,
    "F3": 174.61,
    "GB3": 185,
    "G3": 196,
    "AB3": 207.65,
    "A3": 220,
    "BB3": 233.08,
    "B3": 246.94,
    "C4": 261.63,
    "DB4": 277.18,
    "D4": 293.66,
    "EB4": 311.13,
    "E4": 329.63,
    "F4": 349.23,
    "GB4": 369.99,
    "G4": 392,
    "AB4": 415.3,
    "A4": 440,
    "BB4": 466.16,
    "B4": 493.88,
    "C5": 523.25,
    "DB5": 554.37,
    "D5": 587.33,
    "EB5": 622.25,
    "E5": 659.25,
    "F5": 698.46,
    "GB5": 739.99,
    "G5": 783.99,
    "AB5": 830.61,
    "A5": 880,
    "BB5": 932.33,
    "B5": 987.77,
    "C6": 1046.5,
    "DB6": 1108.73,
    "D6": 1174.66,
    "EB6": 1244.51,
    "E6": 1318.51,
    "F6": 1396.91,
    "GB6": 1479.98,
    "G6": 1567.98,
    "AB6": 1661.22,
    "A6": 1760,
    "BB6": 1864.66,
    "B6": 1975.53,
    "C7": 2093,
    "DB7": 2217.46,
    "D7": 2349.32,
    "EB7": 2489.02,
    "E7": 2637.02,
    "F7": 2793.83,
    "GB7": 2959.96,
    "G7": 3135.96,
    "AB7": 3322.44,
    "A7": 3520,
    "BB7": 3729.31,
    "B7": 3951.07,
    "C8": 4186.01,
    "DB8": 4434.92,
    "D8": 4698.63,
    "EB8": 4978.03,
    "E8": 5274.04,
    "F8": 5587.65,
    "GB8": 5919.91,
    "G8": 6271.93,
    "AB8": 6644.88,
    "A8": 7040,
    "BB8": 7458.62,
    "B8": 7902.13,
}
MIDI_TO_FREQ = {
    m: NOTE_TO_FREQ[n] for n, m in NOTE_TO_MIDI.items() if n in NOTE_TO_FREQ
}


# TODO: add chord / inversion functionality
CHORDS = {
    "MAJ": [0, 4, 7],
    "MAJ_NO_5": [0, 4],
    "POWER": [0, 7],
    "SUS": [0, 5, 7],
    "SUS2": [0, 2, 7],
    "7SUS": [0, 5, 7],
    "7SUS2": [0, 2, 7],
    "MAJ_6": [0, 4, 7, 9],
    "MAJ_6_NO_5": [0, 4, 9],
    "MAJ_6_9": [0, 4, 9, 14],
    "MAJ_9": [0, 4, 7, 14],
    "MIN": [0, 3, 7],
    "MIN_NO_5": [0, 3],
    "MIN_6": [0, 3, 7, 9],
    "MIN_6_NO_5": [0, 3, 9],
    "MIN_6_9": [0, 3, 9, 14],
    "DIM": [0, 3, 6],
    "AUG": [0, 4, 8],
    "MAJ7": [0, 4, 7, 11],
    "MAJ7_NO_5": [0, 4, 11],
    "MIN7": [0, 3, 7, 10],
    "MIN7_NO_5": [0, 3, 10],
    "MAJ9": [0, 4, 7, 14],
    "MAJ9_NO_5": [0, 4, 14],
}

SCALES = {
    "ACOUSTIC": [0, 2, 4, 6, 7, 9, 10],
    "ADONAI_MALAKH": [0, 2, 4, 5, 7, 8, 10],
    "AEOLIAN": [0, 2, 3, 5, 7, 8, 10],
    "ALGERIAN": [0, 2, 3, 6, 7, 8, 11],
    "ALTERED": [0, 1, 3, 4, 6, 8, 10],
    "AUGMENTED": [0, 3, 4, 7, 8, 11],
    "BEBOP_DOMINANT": [0, 2, 4, 5, 7, 9, 10, 11],
    "BLUES": [0, 3, 5, 6, 7, 10],
    "DORIAN": [0, 2, 3, 5, 7, 9, 10],
    "DOUBLE_HARMONIC": [0, 1, 4, 5, 7, 8, 11],
    "ENIGMATIC": [0, 1, 4, 6, 8, 10, 11],
    "FLAMENCO": [0, 1, 4, 5, 7, 8, 11],
    "GYPSY": [0, 2, 3, 6, 7, 8, 10],
    "HALF_DIMINISHED": [0, 2, 3, 5, 6, 8, 10],
    "HARMONIC_MAJOR": [0, 2, 4, 5, 7, 8, 11],
    "HARMONIC_MINOR": [0, 2, 3, 5, 7, 8, 11],
    "HIRAJOSHI": [0, 4, 6, 7, 11],
    "HUNGARIAN_GYPSY": [0, 2, 3, 6, 7, 8, 11],
    "INSEN": [0, 1, 5, 7, 10],
    "IONIAN": [0, 2, 4, 5, 7, 9, 11],
    "IWATO": [0, 1, 5, 6, 11],
    "LOCRIAN": [0, 1, 3, 5, 6, 8, 10],
    "LYDIAN_AUGMENTED": [0, 2, 4, 6, 8, 9, 11],
    "LYDIAN": [0, 2, 4, 6, 7, 9, 11],
    "MAJOR_LOCRIAN": [0, 2, 4, 5, 6, 8, 10],
    "MELODIC_MINOR": [0, 2, 3, 5, 7, 9, 11],
    "MIXOLYDIAN": [0, 2, 4, 5, 7, 9, 10],
    "NEAPOLITAN_MAJOR": [0, 1, 3, 5, 7, 9, 11],
    "NEAPOLITAN_MINOR": [0, 1, 3, 5, 7, 8, 11],
    "PERSIAN": [0, 1, 4, 5, 6, 8, 11],
    "PHRYGIAN": [0, 1, 3, 5, 7, 8, 10],
    "PROMETHEUS": [0, 2, 4, 6, 9, 10],
    "TRITONE": [0, 1, 4, 6, 7, 10],
    "UKRAINIAN_DORIAN": [0, 2, 3, 6, 7, 9, 10],
    "WHOLE_TONE": [0, 2, 4, 6, 8, 10],
    "MAJOR": [0, 2, 4, 5, 7, 9, 11],
    "MINOR": [0, 2, 3, 5, 7, 8, 10],
    "CHROMATIC": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11],
    "OCTATONIC_WHOLE": [0, 2, 3, 5, 6, 8, 9, 11],
    "OCTATONIC_SEMI": [0, 1, 3, 4, 6, 7, 9, 10],
}
