"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalableInstanceCount = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const appscaling = require("aws-cdk-lib/aws-applicationautoscaling");
/**
 * A scalable sagemaker endpoint attribute
 */
class ScalableInstanceCount extends appscaling.BaseScalableAttribute {
    /**
     * Constructs a new instance of the ScalableInstanceCount class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_alpha_ScalableInstanceCountProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ScalableInstanceCount);
            }
            throw error;
        }
    }
    /**
     * Scales in or out to achieve a target requests per second per instance.
     */
    scaleOnInvocations(id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_sagemaker_alpha_InvocationsScalingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.scaleOnInvocations);
            }
            throw error;
        }
        const predefinedMetric = appscaling.PredefinedMetric.SAGEMAKER_VARIANT_INVOCATIONS_PER_INSTANCE;
        super.doScaleToTrackMetric(id, {
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
            targetValue: this.calculateScalingTarget(props),
            predefinedMetric,
        });
    }
    /**
     * Calculate target value based on a ScalableProductionVariant
     *
     * Documentation for the equation is here: https://docs.aws.amazon.com/sagemaker/latest/dg/endpoint-scaling-loadtest.html
     * @param props the scaling properties.
     */
    calculateScalingTarget(props) {
        const safetyFactor = props.safetyFactor ?? 0.5;
        if (safetyFactor <= 0.0 || safetyFactor > 1.0) {
            throw new Error(`Safety factor (${safetyFactor}) must be greater than 0.0 and less than or equal 1.0`);
        }
        return safetyFactor * props.maxRequestsPerSecond * 60;
    }
}
exports.ScalableInstanceCount = ScalableInstanceCount;
_a = JSII_RTTI_SYMBOL_1;
ScalableInstanceCount[_a] = { fqn: "@aws-cdk/aws-sagemaker-alpha.ScalableInstanceCount", version: "2.62.2-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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