"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BundledNodejsFunction = void 0;
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cdk = require("aws-cdk-lib");
/**
 * Lambda Function wrapper that uses pre-bundled JavaScript file from the known folder `lib/lambdas` with some reasonable defaults. The bundled files are put there by projen tasks that use esbuild to bundle TypeScript files from `src/lambdas`. This code is found in `.projenrc.js`.
 */
class BundledNodejsFunction extends aws_cdk_lib_1.aws_lambda.Function {
    constructor(scope, id, props, srcId) {
        super(scope, id, {
            ...props,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '..', 'lib', 'lambdas', srcId ?? id)),
            handler: 'index.handler',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
            logRetention: aws_cdk_lib_1.aws_logs.RetentionDays.ONE_MONTH,
        });
        this.props = props;
        this.addEnvironment('AWS_NODEJS_CONNECTION_REUSE_ENABLED', '1', { removeInEdge: true });
    }
    static singleton(scope, id, props) {
        const constructName = `${id}-dcc036c8-876b-451e-a2c1-552f9e06e9e1`;
        const existing = cdk.Stack.of(scope).node.tryFindChild(constructName);
        if (existing) {
            // Just assume this is true
            return existing;
        }
        return new BundledNodejsFunction(cdk.Stack.of(scope), constructName, props, id);
    }
}
exports.BundledNodejsFunction = BundledNodejsFunction;
//# sourceMappingURL=data:application/json;base64,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