"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/lambdas/build-image/index.ts
var build_image_exports = {};
__export(build_image_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(build_image_exports);
var AWS2 = __toESM(require("aws-sdk"));

// src/lambdas/helpers.ts
var AWS = __toESM(require("aws-sdk"));
var sm = new AWS.SecretsManager();
async function customResourceRespond(event, responseStatus, reason, physicalResourceId, data) {
  const responseBody = JSON.stringify({
    Status: responseStatus,
    Reason: reason,
    PhysicalResourceId: physicalResourceId,
    StackId: event.StackId,
    RequestId: event.RequestId,
    LogicalResourceId: event.LogicalResourceId,
    NoEcho: false,
    Data: data
  });
  console.log("Responding", responseBody);
  const parsedUrl = require("url").parse(event.ResponseURL);
  const requestOptions = {
    hostname: parsedUrl.hostname,
    path: parsedUrl.path,
    method: "PUT",
    headers: {
      "content-type": "",
      "content-length": responseBody.length
    }
  };
  return new Promise((resolve, reject) => {
    try {
      const request = require("https").request(requestOptions, resolve);
      request.on("error", reject);
      request.write(responseBody);
      request.end();
    } catch (e) {
      reject(e);
    }
  });
}

// src/lambdas/build-image/index.ts
var codebuild = new AWS2.CodeBuild();
var ecr = new AWS2.ECR();
var ib = new AWS2.Imagebuilder();
async function handler(event, context) {
  try {
    console.log(JSON.stringify({ ...event, ResponseURL: "..." }));
    const deleteOnly = event.ResourceProperties.DeleteOnly;
    const repoName = event.ResourceProperties.RepoName;
    const projectName = event.ResourceProperties.ProjectName;
    const ibName = event.ResourceProperties.ImageBuilderName;
    switch (event.RequestType) {
      case "Create":
      case "Update":
        if (deleteOnly) {
          await customResourceRespond(event, "SUCCESS", "OK", "Deleter", {});
          break;
        }
        console.log(`Starting CodeBuild project ${projectName}`);
        await codebuild.startBuild({
          projectName,
          environmentVariablesOverride: [
            {
              type: "PLAINTEXT",
              name: "STACK_ID",
              value: event.StackId
            },
            {
              type: "PLAINTEXT",
              name: "REQUEST_ID",
              value: event.RequestId
            },
            {
              type: "PLAINTEXT",
              name: "LOGICAL_RESOURCE_ID",
              value: event.LogicalResourceId
            },
            {
              type: "PLAINTEXT",
              name: "RESPONSE_URL",
              value: event.ResponseURL
            }
          ]
        }).promise();
        break;
      case "Delete":
        const ecrImages = await ecr.listImages({ repositoryName: repoName, maxResults: 100 }).promise();
        if (ecrImages.imageIds && ecrImages.imageIds.length > 0) {
          await ecr.batchDeleteImage({
            imageIds: ecrImages.imageIds.map((i) => {
              return { imageDigest: i.imageDigest };
            }),
            repositoryName: repoName
          }).promise();
        }
        if (ibName) {
          const ibImages = await ib.listImages({ filters: [{ name: "name", values: [ibName] }] }).promise();
          if (ibImages.imageVersionList) {
            for (const v of ibImages.imageVersionList) {
              if (v.arn) {
                const ibImageVersions = await ib.listImageBuildVersions({ imageVersionArn: v.arn }).promise();
                if (ibImageVersions.imageSummaryList) {
                  for (const vs of ibImageVersions.imageSummaryList) {
                    if (vs.arn) {
                      console.log(`Deleting ${vs.arn}`);
                      await ib.deleteImage({ imageBuildVersionArn: vs.arn }).promise();
                    }
                  }
                }
              }
            }
          }
        }
        await customResourceRespond(event, "SUCCESS", "OK", event.PhysicalResourceId, {});
        break;
    }
  } catch (e) {
    console.error(e);
    await customResourceRespond(event, "FAILED", e.message || "Internal Error", context.logStreamName, {});
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
