# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['pygenstub']
install_requires = \
['docutils>=0.16,<0.17']

entry_points = \
{'console_scripts': ['pygenstub = pygenstub:run']}

setup_kwargs = {
    'name': 'pygenstub',
    'version': '2.0.0',
    'description': 'Python stub file generator.',
    'long_description': 'pygenstub\n=========\n\npygenstub is a utility for generating stub files from docstrings\nin source files.\n\nIf the docstring of a function includes a **sig** field,\nthe value of that field will be used to generate a stub\nby matching the types to the parameters in the same order.\n\nFor example, for the function given below:\n\n.. code-block:: python\n\n   def foo(a, b):\n       """Do foo.\n\n       :sig: (int, str) -> None\n       """\n\npygenstub will generate the following stub:\n\n.. code-block:: python\n\n   def foo(a: int, b: str) -> None: ...\n\npygenstub consists of a single `source file`_ which contains such signatures.\nYou can check the `stub file`_ generated by running pygenstub on itself\nas an example.\n\nGetting started\n---------------\n\npygenstub runs on Python 3.6 and later versions.\nYou can install the latest version from `PyPI`_::\n\n  pip install pygenstub\n\nInstallation creates a script named ``pygenstub`` which can be used\nas follows::\n\n  pygenstub foo.py\n\nThis command will generate the file ``foo.pyi`` in the same directory\nas the input file.\nIf the output file already exists, it will be overwritten.\n\nIf you download the `source file`_, you can also run it directly\nwithout installing::\n\n  python pygenstub.py foo.py\n\nIf pygenstub is activated as a Sphinx extension (after *sphinx.ext.autodoc*),\nit will insert type comments into the docstring:\n\n.. code-block:: python\n\n   extensions = [\n       "sphinx.ext.autodoc",\n       "pygenstub"\n   ]\n\nAs an example of the output, you can check the `API documentation`_\nfor pygenstub itself.\n\nGetting help\n------------\n\nThe documentation is available on: https://pygenstub.readthedocs.io/\n\nThe source code can be obtained from: https://github.com/uyar/pygenstub\n\nLicense\n-------\n\nCopyright (C) 2016-2021 H. Turgut Uyar <uyar@tekir.org>\n\npygenstub is released under the GPL license, version 3 or later.\nRead the included `LICENSE.txt`_ for details.\n\n.. _PyPI: https://pypi.org/project/pygenstub/\n.. _source file: https://github.com/uyar/pygenstub/blob/master/pygenstub.py\n.. _stub file: https://github.com/uyar/pygenstub/blob/master/pygenstub.pyi\n.. _API documentation: https://pygenstub.readthedocs.io/en/latest/api.html\n.. _LICENSE.txt: https://github.com/uyar/pygenstub/blob/master/LICENSE.txt\n',
    'author': 'H. Turgut Uyar',
    'author_email': 'uyar@tekir.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://tekir.org/pygenstub/',
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
