import * as iot from '@aws-cdk/aws-iot';
import * as s3 from '@aws-cdk/aws-s3';
import { CommonActionProps } from './common-action-props';
/**
 * Configuration properties of an action for s3.
 */
export interface S3PutObjectActionProps extends CommonActionProps {
    /**
     * The Amazon S3 canned ACL that controls access to the object identified by the object key.
     * @see https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl
     *
     * @default None
     */
    readonly accessControl?: s3.BucketAccessControl;
    /**
     * The path to the file where the data is written.
     *
     * Supports substitution templates.
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     *
     * @default '${topic()}/${timestamp()}'
     */
    readonly key?: string;
}
/**
 * The action to write the data from an MQTT message to an Amazon S3 bucket.
 */
export declare class S3PutObjectAction implements iot.IAction {
    private readonly bucket;
    private readonly accessControl?;
    private readonly key?;
    private readonly role?;
    /**
     * @param bucket The Amazon S3 bucket to which to write data.
     * @param props Optional properties to not use default
     */
    constructor(bucket: s3.IBucket, props?: S3PutObjectActionProps);
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
