"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * The action to invoke an AWS Lambda function, passing in an MQTT message.
 */
class LambdaFunctionAction {
    /**
     * @param func The lambda function to be invoked by this action
     */
    constructor(func) {
        this.func = func;
    }
    bind(topicRule) {
        this.func.addPermission(`${core_1.Names.nodeUniqueId(topicRule.node)}:IotLambdaFunctionAction`, {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('iot.amazonaws.com'),
            sourceAccount: topicRule.env.account,
            sourceArn: topicRule.topicRuleArn,
        });
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaFunctionAction = LambdaFunctionAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.LambdaFunctionAction", version: "1.163.2" };
//# sourceMappingURL=data:application/json;base64,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