"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secret = void 0;
const base_1 = require("./base");
const k8s = require("./imports/k8s");
/**
 * Kubernetes Secrets let you store and manage sensitive information, such as
 * passwords, OAuth tokens, and ssh keys. Storing confidential information in a
 * Secret is safer and more flexible than putting it verbatim in a Pod
 * definition or in a container image.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret
 */
class Secret extends base_1.Resource {
    constructor(scope, id, props = {}) {
        var _a;
        super(scope, id, { metadata: props.metadata });
        this.stringData = (_a = props.stringData) !== null && _a !== void 0 ? _a : {};
        this.apiObject = new k8s.Secret(this, 'Secret', {
            metadata: props.metadata,
            stringData: this.stringData,
        });
    }
    /**
     * Imports a secret from the cluster as a reference.
     * @param name The name of the secret to reference.
     */
    static fromSecretName(name) {
        return { name };
    }
    /**
     * Adds a string data field to the secert.
     * @param key Key
     * @param value Value
     */
    addStringData(key, value) {
        this.stringData[key] = value;
    }
    /**
     * Gets a string data by key or undefined
     * @param key Key
     */
    getStringData(key) {
        return this.stringData[key];
    }
}
exports.Secret = Secret;
//# sourceMappingURL=data:application/json;base64,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