import safepandas as pd

# Create a DataFrame
data = {'age': [25, 30, 35, 40]}
key = "my_custom_secret_key"  # Custom key for encryption
df = pd.DataFrame(data, key=key)  # Pass the key during DataFrame creation

# Perform operations (data stays encrypted)
df['age'] = df['age'] + 5

# Save the encrypted DataFrame to a CSV file
df.to_csv("encrypted_data.csv", format="csv")

# Load the encrypted DataFrame from the CSV file, providing the key
key = "my_custom_secret_key"  # Same key used for encryption
loaded_df = SafePandas.read_csv("encrypted_data.csv", format="csv", key=key)

# Decrypt the data
decrypted_df = loaded_df.decrypt()

# Display the decrypted result
print("Decrypted Data:")
print(decrypted_df)
