"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartingPosition = exports.EventSourceMapping = exports.SourceAccessConfigurationType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const lambda_generated_1 = require("./lambda.generated");
/**
 * The type of authentication protocol or the VPC components for your event source's SourceAccessConfiguration.
 *
 * @see https://docs.aws.amazon.com/lambda/latest/dg/API_SourceAccessConfiguration.html#SSS-Type-SourceAccessConfiguration-Type
 * @stability stable
 */
class SourceAccessConfigurationType {
    constructor(type) {
        this.type = type;
    }
    /**
     * A custom source access configuration property.
     *
     * @stability stable
     */
    static of(name) {
        return new SourceAccessConfigurationType(name);
    }
}
exports.SourceAccessConfigurationType = SourceAccessConfigurationType;
_a = JSII_RTTI_SYMBOL_1;
SourceAccessConfigurationType[_a] = { fqn: "@aws-cdk/aws-lambda.SourceAccessConfigurationType", version: "1.142.0" };
/**
 * (MQ) The Secrets Manager secret that stores your broker credentials.
 *
 * @stability stable
 */
SourceAccessConfigurationType.BASIC_AUTH = new SourceAccessConfigurationType('BASIC_AUTH');
/**
 * The subnets associated with your VPC.
 *
 * Lambda connects to these subnets to fetch data from your Self-Managed Apache Kafka cluster.
 *
 * @stability stable
 */
SourceAccessConfigurationType.VPC_SUBNET = new SourceAccessConfigurationType('VPC_SUBNET');
/**
 * The VPC security group used to manage access to your Self-Managed Apache Kafka brokers.
 *
 * @stability stable
 */
SourceAccessConfigurationType.VPC_SECURITY_GROUP = new SourceAccessConfigurationType('VPC_SECURITY_GROUP');
/**
 * The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your Self-Managed Apache Kafka brokers.
 *
 * @stability stable
 */
SourceAccessConfigurationType.SASL_SCRAM_256_AUTH = new SourceAccessConfigurationType('SASL_SCRAM_256_AUTH');
/**
 * The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your Self-Managed Apache Kafka brokers.
 *
 * @stability stable
 */
SourceAccessConfigurationType.SASL_SCRAM_512_AUTH = new SourceAccessConfigurationType('SASL_SCRAM_512_AUTH');
/**
 * The Secrets Manager ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM), and private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
 *
 * @stability stable
 */
SourceAccessConfigurationType.CLIENT_CERTIFICATE_TLS_AUTH = new SourceAccessConfigurationType('CLIENT_CERTIFICATE_TLS_AUTH');
/**
 * Defines a Lambda EventSourceMapping resource.
 *
 * Usually, you won't need to define the mapping yourself. This will usually be done by
 * event sources. For example, to add an SQS event source to a function:
 *
 *     import { SqsEventSource } from '@aws-cdk/aws-lambda-event-sources';
 *     lambda.addEventSource(new SqsEventSource(sqs));
 *
 * The `SqsEventSource` class will automatically create the mapping, and will also
 * modify the Lambda's execution role so it can consume messages from the queue.
 *
 * @stability stable
 */
class EventSourceMapping extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_EventSourceMappingProps(props);
        if (props.eventSourceArn == undefined && props.kafkaBootstrapServers == undefined) {
            throw new Error('Either eventSourceArn or kafkaBootstrapServers must be set');
        }
        if (props.eventSourceArn !== undefined && props.kafkaBootstrapServers !== undefined) {
            throw new Error('eventSourceArn and kafkaBootstrapServers are mutually exclusive');
        }
        if (props.kafkaBootstrapServers && (((_c = props.kafkaBootstrapServers) === null || _c === void 0 ? void 0 : _c.length) < 1)) {
            throw new Error('kafkaBootStrapServers must not be empty if set');
        }
        if (props.maxBatchingWindow && props.maxBatchingWindow.toSeconds() > 300) {
            throw new Error(`maxBatchingWindow cannot be over 300 seconds, got ${props.maxBatchingWindow.toSeconds()}`);
        }
        if (props.maxRecordAge && (props.maxRecordAge.toSeconds() < 60 || props.maxRecordAge.toDays({ integral: false }) > 7)) {
            throw new Error('maxRecordAge must be between 60 seconds and 7 days inclusive');
        }
        props.retryAttempts !== undefined && cdk.withResolved(props.retryAttempts, (attempts) => {
            if (attempts < 0 || attempts > 10000) {
                throw new Error(`retryAttempts must be between 0 and 10000 inclusive, got ${attempts}`);
            }
        });
        props.parallelizationFactor !== undefined && cdk.withResolved(props.parallelizationFactor, (factor) => {
            if (factor < 1 || factor > 10) {
                throw new Error(`parallelizationFactor must be between 1 and 10 inclusive, got ${factor}`);
            }
        });
        if (props.tumblingWindow && !cdk.Token.isUnresolved(props.tumblingWindow) && props.tumblingWindow.toSeconds() > 900) {
            throw new Error(`tumblingWindow cannot be over 900 seconds, got ${props.tumblingWindow.toSeconds()}`);
        }
        let destinationConfig;
        if (props.onFailure) {
            destinationConfig = {
                onFailure: props.onFailure.bind(this, props.target),
            };
        }
        let selfManagedEventSource;
        if (props.kafkaBootstrapServers) {
            selfManagedEventSource = { endpoints: { kafkaBootstrapServers: props.kafkaBootstrapServers } };
        }
        const cfnEventSourceMapping = new lambda_generated_1.CfnEventSourceMapping(this, 'Resource', {
            batchSize: props.batchSize,
            bisectBatchOnFunctionError: props.bisectBatchOnError,
            destinationConfig,
            enabled: props.enabled,
            eventSourceArn: props.eventSourceArn,
            functionName: props.target.functionName,
            startingPosition: props.startingPosition,
            functionResponseTypes: props.reportBatchItemFailures ? ['ReportBatchItemFailures'] : undefined,
            maximumBatchingWindowInSeconds: (_d = props.maxBatchingWindow) === null || _d === void 0 ? void 0 : _d.toSeconds(),
            maximumRecordAgeInSeconds: (_e = props.maxRecordAge) === null || _e === void 0 ? void 0 : _e.toSeconds(),
            maximumRetryAttempts: props.retryAttempts,
            parallelizationFactor: props.parallelizationFactor,
            topics: props.kafkaTopic !== undefined ? [props.kafkaTopic] : undefined,
            tumblingWindowInSeconds: (_f = props.tumblingWindow) === null || _f === void 0 ? void 0 : _f.toSeconds(),
            sourceAccessConfigurations: (_g = props.sourceAccessConfigurations) === null || _g === void 0 ? void 0 : _g.map((o) => { return { type: o.type.type, uri: o.uri }; }),
            selfManagedEventSource,
        });
        this.eventSourceMappingId = cfnEventSourceMapping.ref;
    }
    /**
     * Import an event source into this stack from its event source id.
     *
     * @stability stable
     */
    static fromEventSourceMappingId(scope, id, eventSourceMappingId) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.eventSourceMappingId = eventSourceMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.EventSourceMapping = EventSourceMapping;
_b = JSII_RTTI_SYMBOL_1;
EventSourceMapping[_b] = { fqn: "@aws-cdk/aws-lambda.EventSourceMapping", version: "1.142.0" };
/**
 * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading.
 *
 * @stability stable
 */
var StartingPosition;
(function (StartingPosition) {
    StartingPosition["TRIM_HORIZON"] = "TRIM_HORIZON";
    StartingPosition["LATEST"] = "LATEST";
})(StartingPosition = exports.StartingPosition || (exports.StartingPosition = {}));
//# sourceMappingURL=data:application/json;base64,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