#!/usr/bin/env python
#

import os

import setuptools

long_desc = """# Pylittle

Pylittle is testing.
"""

def read(fname):
    with open(os.path.join(os.path.dirname(__file__), fname), "r", encoding="utf-8") as fh:
        return fh.read()


setuptools.setup(
    name="pylittle",
    version=read("pylittle/__version__").strip(),
    description="pylittle test",
    license="Proprietary License",
    long_description=read("README.md"),
    long_description_content_type="text/markdown",
    url="https://www.pylittle.io/",
    project_urls={
        "Homepage": "https://www.pylittle.io/",
        "Documentation": "https://www.pylittle.io/",
        "Contact": "https://www.pylittle.io/",
        "End-User License Agreement": "https://www.pylittle.io/"
    },
    author="pylittle Systems, Inc.",
    author_email="support@pylittle.io",
    keywords="pylittle",
    packages=setuptools.find_packages(),
    install_requires=read("requirements.txt"),
    extras_require={
        "grpc": read("requirements-grpc.txt"),
    },
    include_package_data=True,
    python_requires=">=3.8",
    entry_points={
        'console_scripts': ['pylittle=pylittle.cli:main'],
    },
    classifiers=[
        "Development Status :: 4 - Beta",
        "Environment :: Console",
        "Environment :: Other Environment",
        "Intended Audience :: Developers",
        "Intended Audience :: Information Technology",
        "Intended Audience :: Science/Research",
        "Intended Audience :: System Administrators",
        "License :: Other/Proprietary License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Topic :: Database",
        "Topic :: Software Development",
        "Topic :: Software Development :: Libraries",
        "Topic :: Software Development :: Libraries :: Application Frameworks",
        "Topic :: Software Development :: Libraries :: Python Modules"
    ]
)