"""
    PocketSmith

    The public PocketSmith API  # noqa: E501

    The version of the OpenAPI document: 2.0+0.3.3
    Contact: api@pocketsmith.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pocketsmith.api_client import ApiClient, Endpoint as _Endpoint
from pocketsmith.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from pocketsmith.model.budget_analysis_package import BudgetAnalysisPackage


class BudgetingApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_budget_summary_endpoint = _Endpoint(
            settings={
                'response_type': ([BudgetAnalysisPackage],),
                'auth': [
                    'developerKey'
                ],
                'endpoint_path': '/users/{id}/budget_summary',
                'operation_id': 'get_budget_summary',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'period',
                    'interval',
                    'start_date',
                    'end_date',
                ],
                'required': [
                    'id',
                    'period',
                    'interval',
                    'start_date',
                    'end_date',
                ],
                'nullable': [
                ],
                'enum': [
                    'period',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('period',): {

                        "WEEKS": "weeks",
                        "MONTHS": "months",
                        "YEARS": "years",
                        "EVENT": "event"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'period':
                        (str,),
                    'interval':
                        (int,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'period': 'period',
                    'interval': 'interval',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                },
                'location_map': {
                    'id': 'path',
                    'period': 'query',
                    'interval': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_trend_analysis_endpoint = _Endpoint(
            settings={
                'response_type': (BudgetAnalysisPackage,),
                'auth': [
                    'developerKey'
                ],
                'endpoint_path': '/users/{id}/trend_analysis',
                'operation_id': 'get_trend_analysis',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'period',
                    'interval',
                    'start_date',
                    'end_date',
                    'categories',
                    'scenarios',
                ],
                'required': [
                    'id',
                    'period',
                    'interval',
                    'start_date',
                    'end_date',
                    'categories',
                    'scenarios',
                ],
                'nullable': [
                ],
                'enum': [
                    'period',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('period',): {

                        "WEEKS": "weeks",
                        "MONTHS": "months",
                        "YEARS": "years",
                        "EVENT": "event"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'period':
                        (str,),
                    'interval':
                        (int,),
                    'start_date':
                        (str,),
                    'end_date':
                        (str,),
                    'categories':
                        (str,),
                    'scenarios':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'period': 'period',
                    'interval': 'interval',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'categories': 'categories',
                    'scenarios': 'scenarios',
                },
                'location_map': {
                    'id': 'path',
                    'period': 'query',
                    'interval': 'query',
                    'start_date': 'query',
                    'end_date': 'query',
                    'categories': 'query',
                    'scenarios': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_budgets_endpoint = _Endpoint(
            settings={
                'response_type': ([BudgetAnalysisPackage],),
                'auth': [
                    'developerKey'
                ],
                'endpoint_path': '/users/{id}/budget',
                'operation_id': 'list_budgets',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'roll_up',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'roll_up':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'roll_up': 'roll_up',
                },
                'location_map': {
                    'id': 'path',
                    'roll_up': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_budget_summary(
        self,
        id,
        period,
        interval,
        start_date,
        end_date,
        **kwargs
    ):
        """Get budget summary for user  # noqa: E501

        Get the user's budget summary, containing an expense and income analysis for all categories (excluding transfer categories) for the given period and date range. Akin to the overall budget shown on the Budget page in PocketSmith.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_budget_summary(id, period, interval, start_date, end_date, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): The unique identifier of the user.
            period (str): The period to analyse in, one of `weeks`, `months` or `years`. Also supported is `event`, although event period analysis is only possible when the budget events gathered align, so in this case where all categories are analysed together, it's highly unlikely that event period analysis will be possible.
            interval (int): The period interval, e.g. if the interval is 2 and the period is weeks, the budget will be analysed fortnightly.
            start_date (str): The date to start analysing the budget from. This will be bumped out to make full periods as necessary.
            end_date (str): The date to stop analysing the budget from. This will be bumped out to make full periods as necessary.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [BudgetAnalysisPackage]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        kwargs['period'] = \
            period
        kwargs['interval'] = \
            interval
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        return self.get_budget_summary_endpoint.call_with_http_info(**kwargs)

    def get_trend_analysis(
        self,
        id,
        period,
        interval,
        start_date,
        end_date,
        categories,
        scenarios,
        **kwargs
    ):
        """Get trend analysis for user  # noqa: E501

        Get an income and/or expense budget analysis for the given date range and period across any number of categories and scenarios. Akin to the Trends page in PocketSmith.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_trend_analysis(id, period, interval, start_date, end_date, categories, scenarios, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): The unique identifier of the user.
            period (str): The period to analyse in, one of `weeks`, `months` or `years`. Also supported is `event`, although event period analysis is only possible when the budget events gathered align, so in this case where all categories are analysed together, it's highly unlikely that event period analysis will be possible.
            interval (int): The period interval, e.g. if the interval is 2 and the period is weeks, the budget will be analysed fortnightly.
            start_date (str): The date to start analysing the budget from. This will be bumped out to make full periods as necessary.
            end_date (str): The date to stop analysing the budget from. This will be bumped out to make full periods as necessary.
            categories (str): A comma-separated list of category IDs to analyse.
            scenarios (str): A comma-separated list of scenario IDs to analyse. You're likely going to want to include all a user's scenarios here, unless you have reason to only analyse for a subset of scenarios. Regardless of what scenarios are analysed, all actuals (transactions) across all accounts will be included.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            BudgetAnalysisPackage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        kwargs['period'] = \
            period
        kwargs['interval'] = \
            interval
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['categories'] = \
            categories
        kwargs['scenarios'] = \
            scenarios
        return self.get_trend_analysis_endpoint.call_with_http_info(**kwargs)

    def list_budgets(
        self,
        id,
        **kwargs
    ):
        """List budget for user  # noqa: E501

        Lists the user's budget, consisting of one or more budget analysis packages, one per category. Akin to the list on the Budget page in PocketSmith.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_budgets(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (int): The unique identifier of the account.

        Keyword Args:
            roll_up (bool): Whether parent categories should have their children rolled up into them. When used, the children will still appear in the collection on their own, but their actual and forecast figures will be rolled up to the root parent.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [BudgetAnalysisPackage]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['id'] = \
            id
        return self.list_budgets_endpoint.call_with_http_info(**kwargs)

