# To build a "basicpkglearning" pypi package  
The `basicpkglearning` is a simple testing example to understand the basics of developing your first Python package.  
Ref: https://www.freecodecamp.org/news/how-to-create-and-upload-your-first-python-package-to-pypi/  
## I. An overview of a package structure
```
    package_name/
		docs/
		scripts/
		src/
			package_a
				__init__.py
				module_a1.py
				module_a2.py
			package_b
				__init__.py
				module_b1.py
				module_b2.py
				module_b3.py
		tests/
			__init__.py
			test_module_a1.py
			test_module_a2.py
			test_module_b1.py
			test_module_b2.py
			test_module_b3.py
		LICENSE.txt
		CHANGES.txt
		MANIFEST.in
		README.txt
		pyproject.toml
		setup.py
		setup.cfg
```  
    - package_name: represents the main package.
    - docs: includes documentation files on how to use the package.
    - scripts/: your top-level scripts.
    - src: where your code goes. It contains packages, modules, sub-packages, and so on.
    - tests: where you can put unit tests.  
      Can keep it at the top level as we did above or put it inside the package  
    - LICENSE.txt: contains the text of the license (for example, MIT).
    - CHANGES.txt: reports the changes of each release.
    - MANIFEST.in: where you put instructions on what extra files you want to include (non-code files).
    - README.md: contains the package description (markdown format).
    - pyproject.toml: to register your build tools.
    - setup.py: contains the build script for your build tools.  
        An example of setup.py that uses some setup() arguments.
```python
import setuptools

with open("README.md", "r", encoding = "utf-8") as f:
	long_description = f.read()

setuptools.setup(
	name = "package-name", # Note name "test" is not allowed by pypi
	version = "0.0.1",
	author = "author",
	author_email = "author@example.com",
	description = "short package description",
	long_description = long_description,
	long_description_content_type = "text/markdown",
	url = "package URL", # Eg. "https://gitlab.com/codasteroid/basicpkg"
	project_urls = {
		"Bug Tracker": "package issues URL",
	},
	classifiers = [
		"Programming Language :: Python :: 3",
		"License :: OSI Approved :: MIT License",
		"Operating System :: OS Independent",
	],
	package_dir = {"": "src"},
	packages = setuptools.find_packages(where="src"), 
	# Note: packages="testing_pypi" # "error: package directory 't' does not exist"
	python_requires = ">=3.8"
)
```
    - setup.cfg: the configuration file of your build tools.
      Can use setup.py or setup.cfg. According to the Python Packaging User 
      Guide, setup.cfg is preferred because it's static, clean, easier to read,
      and avoids encoding errors.
      An example of setup.cfg 
```editorconfig
[metadata]
        name = package-name
        version = 0.0.1
        author = name of the author
        author_email = author@example.com
        description = short package description
        long_description = file: README.md
        long_description_content_type = text/markdown
        url = package url
        project_urls =
            Bug Tracker = package issues url
        classifiers =
            Programming Language :: Python :: 3
            License :: OSI Approved :: MIT License
            Operating System :: OS Independent
        
        [options]
        package_dir = src
        packages = find:
        python_requires = >=3.6
        
        [options.packages.find]
        where = src  
```
        

## 2. Build my first Python package  
   - use setuptools as a build system and configure the project using setup.cfg
    and pyproject.toml  
   - The package structure  
    ```
    basicpkglearning/
		src/
			divide
				__init__.py
				divide_by_five.py
			multiply
				__init__.py
				multiply_by_five.py
		tests/
			__init__.py
			test_module_divide_by_five.py
			test_module_multiply_by_five.py
		LICENSE.txt
		README.md
		pyproject.toml
		setup.cfg
    ```
   - __init__.py. This file can be completely empty but need to use it to mark the directory on a disk as a Python package  
   - The main package consists of two packages: 
        - the first one to divide numbers by five  
        - and the other to multiply numbers by five.
## 3. How to use this package 
- To install
```commandline
(pythonevn) C:\>pip install basicpkglearning
```    
- where is package after pip install. basicpkglearning is package name  
```commandline
(pythonevn) C:\>pip list -v  
(pythonevn) C:\>pip show basicpkglearning
```  
- If want to uninstall
```commandline
(pythonevn) C:\>pip uninstall basicpkglearning
```      
- To use this package
```python
import os
import sys
sys.path.insert(0, os.getcwd())

from src.divide.divide_by_five import divide_five
from src.multiply.multiply_by_five import multiply_five

print(divide_five(15))  # output: 3
print(multiply_five(3)) # output: 15
```
