# Generated by Django 4.1.3 on 2022-11-23 12:02

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import mentions.models.webmention


class Migration(migrations.Migration):

    dependencies = [
        ("mentions", "0011_alter_pendingoutgoingcontent_text"),
    ]

    operations = [
        migrations.AlterModelOptions(
            name="hcard",
            options={"verbose_name": "h-card", "verbose_name_plural": "h-cards"},
        ),
        migrations.AlterModelOptions(
            name="outgoingwebmentionstatus",
            options={
                "ordering": ["-created_at"],
                "verbose_name": "outgoing webmention",
                "verbose_name_plural": "outgoing webmentions",
            },
        ),
        migrations.AlterModelOptions(
            name="pendingincomingwebmention",
            options={
                "ordering": ["-created_at"],
                "verbose_name": "pending incoming webmention",
                "verbose_name_plural": "pending incoming webmentions",
            },
        ),
        migrations.AlterModelOptions(
            name="pendingoutgoingcontent",
            options={
                "ordering": ["-created_at"],
                "verbose_name": "pending outgoing content",
                "verbose_name_plural": "pending outgoing content",
            },
        ),
        migrations.AlterModelOptions(
            name="webmention",
            options={
                "ordering": ["-created_at"],
                "verbose_name": "webmention",
                "verbose_name_plural": "webmentions",
            },
        ),
        migrations.AlterField(
            model_name="hcard",
            name="avatar",
            field=models.URLField(
                blank=True,
                help_text="Link to their profile image.",
                null=True,
                verbose_name="avatar URL",
            ),
        ),
        migrations.AlterField(
            model_name="hcard",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, null=True, verbose_name="created at"
            ),
        ),
        migrations.AlterField(
            model_name="hcard",
            name="homepage",
            field=models.URLField(
                blank=True,
                help_text="Link to their homepage.",
                null=True,
                verbose_name="homepage URL",
            ),
        ),
        migrations.AlterField(
            model_name="hcard",
            name="json",
            field=models.TextField(
                blank=True,
                help_text="Raw json representation of this h-card.",
                verbose_name="JSON",
            ),
        ),
        migrations.AlterField(
            model_name="hcard",
            name="name",
            field=models.CharField(
                blank=True,
                help_text="Name of the person/organisation.",
                max_length=50,
                null=True,
                verbose_name="name",
            ),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, null=True, verbose_name="created at"
            ),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="is_awaiting_retry",
            field=models.BooleanField(
                default=True,
                help_text="Whether this object is eligible for another attempt at processing.",
                verbose_name="awaiting retry",
            ),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="is_retry_successful",
            field=models.BooleanField(
                default=False,
                editable=False,
                help_text="Whether this object has been processed successfully.",
                verbose_name="retry successful",
            ),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="last_retry_attempt",
            field=models.DateTimeField(
                blank=True,
                help_text="When we last attempted to process this object.",
                null=True,
                verbose_name="latest retry attempt",
            ),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="response_code",
            field=models.PositiveIntegerField(
                default=0,
                help_text="HTTP response code of the latest attempted submission.",
                verbose_name="response code",
            ),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="retry_attempt_count",
            field=models.PositiveSmallIntegerField(
                default=0,
                editable=False,
                help_text="How many times we have attempted to process this object.",
                verbose_name="retry attempt count",
            ),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="source_url",
            field=models.URLField(
                help_text="The URL on your server where this mention originates.",
                verbose_name="source URL",
            ),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="status_message",
            field=models.CharField(
                help_text="Success, or an explanation of what went wrong.",
                max_length=1024,
                verbose_name="status message",
            ),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="successful",
            field=models.BooleanField(default=False, verbose_name="successful"),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="target_url",
            field=models.URLField(
                help_text="The URL that you mentioned.", verbose_name="target URL"
            ),
        ),
        migrations.AlterField(
            model_name="outgoingwebmentionstatus",
            name="target_webmention_endpoint",
            field=models.URLField(
                blank=True,
                help_text="The endpoint URL to which we sent the webmention.",
                null=True,
                verbose_name="target webmention endpoint",
            ),
        ),
        migrations.AlterField(
            model_name="pendingincomingwebmention",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, null=True, verbose_name="created at"
            ),
        ),
        migrations.AlterField(
            model_name="pendingincomingwebmention",
            name="is_awaiting_retry",
            field=models.BooleanField(
                default=True,
                help_text="Whether this object is eligible for another attempt at processing.",
                verbose_name="awaiting retry",
            ),
        ),
        migrations.AlterField(
            model_name="pendingincomingwebmention",
            name="is_retry_successful",
            field=models.BooleanField(
                default=False,
                editable=False,
                help_text="Whether this object has been processed successfully.",
                verbose_name="retry successful",
            ),
        ),
        migrations.AlterField(
            model_name="pendingincomingwebmention",
            name="last_retry_attempt",
            field=models.DateTimeField(
                blank=True,
                help_text="When we last attempted to process this object.",
                null=True,
                verbose_name="latest retry attempt",
            ),
        ),
        migrations.AlterField(
            model_name="pendingincomingwebmention",
            name="retry_attempt_count",
            field=models.PositiveSmallIntegerField(
                default=0,
                editable=False,
                help_text="How many times we have attempted to process this object.",
                verbose_name="retry attempt count",
            ),
        ),
        migrations.AlterField(
            model_name="pendingincomingwebmention",
            name="sent_by",
            field=models.URLField(
                help_text="The origin of the webmention request.",
                verbose_name="sent by",
            ),
        ),
        migrations.AlterField(
            model_name="pendingincomingwebmention",
            name="source_url",
            field=models.URLField(
                help_text="The URL of the content that mentions your content.",
                verbose_name="source URL",
            ),
        ),
        migrations.AlterField(
            model_name="pendingincomingwebmention",
            name="target_url",
            field=models.URLField(
                help_text="The URL of the page on your server that is being mentioned.",
                verbose_name="target URL",
            ),
        ),
        migrations.AlterField(
            model_name="pendingoutgoingcontent",
            name="absolute_url",
            field=models.URLField(
                help_text="URL on our server where the content can be found.",
                unique=True,
                verbose_name="absolute URL",
            ),
        ),
        migrations.AlterField(
            model_name="pendingoutgoingcontent",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, null=True, verbose_name="created at"
            ),
        ),
        migrations.AlterField(
            model_name="pendingoutgoingcontent",
            name="text",
            field=models.TextField(
                help_text="HTML text that may contain mentionable links.",
                verbose_name="HTML content",
            ),
        ),
        migrations.AlterField(
            model_name="simplemention",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, null=True, verbose_name="created at"
            ),
        ),
        migrations.AlterField(
            model_name="simplemention",
            name="hcard",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="mentions.hcard",
                verbose_name="h-card",
            ),
        ),
        migrations.AlterField(
            model_name="simplemention",
            name="object_id",
            field=models.PositiveIntegerField(
                blank=True, null=True, verbose_name="object ID"
            ),
        ),
        migrations.AlterField(
            model_name="simplemention",
            name="post_type",
            field=models.CharField(
                blank=True,
                choices=[
                    ("bookmark", "Bookmark"),
                    ("like", "Like"),
                    ("listen", "Listen"),
                    ("reply", "Reply"),
                    ("repost", "Repost"),
                    ("translation", "Translation"),
                    ("watch", "Watch"),
                ],
                help_text="Type (e.g. like, reply, etc.) of mention, if specified.",
                max_length=64,
                null=True,
                verbose_name="post type",
            ),
        ),
        migrations.AlterField(
            model_name="simplemention",
            name="published",
            field=models.DateTimeField(
                default=django.utils.timezone.now, verbose_name="published"
            ),
        ),
        migrations.AlterField(
            model_name="simplemention",
            name="quote",
            field=models.CharField(
                blank=True,
                help_text="A short excerpt from the quoted piece.",
                max_length=300,
                null=True,
                verbose_name="quote",
            ),
        ),
        migrations.AlterField(
            model_name="simplemention",
            name="source_url",
            field=models.URLField(
                help_text="The URL that mentions our content.",
                verbose_name="source URL",
            ),
        ),
        migrations.AlterField(
            model_name="simplemention",
            name="target_url",
            field=models.URLField(
                help_text="Our URL that is mentioned.", verbose_name="target URL"
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="approved",
            field=models.BooleanField(
                default=mentions.models.webmention._approve_default,
                help_text="Allow this webmention to appear publicly.",
                verbose_name="approved",
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="created_at",
            field=models.DateTimeField(
                auto_now_add=True, null=True, verbose_name="created at"
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="hcard",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="mentions.hcard",
                verbose_name="h-card",
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="notes",
            field=models.CharField(
                blank=True,
                help_text="A description of any errors encountered when building this Webmention.",
                max_length=1024,
                verbose_name="notes",
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="object_id",
            field=models.PositiveIntegerField(
                blank=True, null=True, verbose_name="object ID"
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="post_type",
            field=models.CharField(
                blank=True,
                choices=[
                    ("bookmark", "Bookmark"),
                    ("like", "Like"),
                    ("listen", "Listen"),
                    ("reply", "Reply"),
                    ("repost", "Repost"),
                    ("translation", "Translation"),
                    ("watch", "Watch"),
                ],
                help_text="Type (e.g. like, reply, etc.) of mention, if specified.",
                max_length=64,
                null=True,
                verbose_name="post type",
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="published",
            field=models.DateTimeField(
                default=django.utils.timezone.now, verbose_name="published"
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="quote",
            field=models.CharField(
                blank=True,
                help_text="A short excerpt from the quoted piece.",
                max_length=300,
                null=True,
                verbose_name="quote",
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="sent_by",
            field=models.URLField(
                blank=True,
                help_text="Source address of the HTTP request that sent this webmention.",
                verbose_name="sent by",
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="source_url",
            field=models.URLField(
                help_text="The URL that mentions our content.",
                verbose_name="source URL",
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="target_url",
            field=models.URLField(
                help_text="Our URL that is mentioned.", verbose_name="target URL"
            ),
        ),
        migrations.AlterField(
            model_name="webmention",
            name="validated",
            field=models.BooleanField(
                default=False,
                help_text="True if both source and target have been validated, confirmed to exist, and source really does link to target.",
                verbose_name="validated",
            ),
        ),
    ]
