/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import java.io.Serializable;
import java.text.ParseException;

@SASScope
public class UsageVersion
implements Serializable,
Comparable {
    static final long serialVersionUID = -4086941163856453963L;
    private int major;
    private int minor;
    private int micro;

    public UsageVersion(int majorVersion, int minorVersion) {
        if (majorVersion < 0 || majorVersion > 999) {
            throw new IllegalArgumentException("Invalid major version.  Major version must be between 0 and 999.");
        }
        if (minorVersion < 0 || minorVersion > 99) {
            throw new IllegalArgumentException("Invalid minor version.  Minor version must be between 0 and 99.");
        }
        this.major = majorVersion;
        this.minor = minorVersion;
        this.micro = 0;
    }

    public UsageVersion(int majorVersion, int minorVersion, int microVersion) {
        if (majorVersion < 0 || majorVersion > 999) {
            throw new IllegalArgumentException("Invalid major version.  Major version must be between 0 and 999.");
        }
        if (minorVersion < 0 || minorVersion > 99) {
            throw new IllegalArgumentException("Invalid minor version.  Minor version must be between 0 and 99.");
        }
        if (microVersion < 0 || microVersion > 9999) {
            throw new IllegalArgumentException("Invalid micro version.  Micro version must be between 0 and 9999.");
        }
        this.major = majorVersion;
        this.minor = minorVersion;
        this.micro = microVersion;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getMicroVersion() {
        return this.micro;
    }

    public String toString() {
        if (this.micro == 0) {
            return Integer.toString(this.major) + "." + Integer.toString(this.minor);
        }
        return Integer.toString(this.major) + "." + Integer.toString(this.minor) + "." + Integer.toString(this.micro);
    }

    public static UsageVersion parseVersion(String versionString) throws ParseException {
        int major = 0;
        int minor = 0;
        int micro = 0;
        int i = 0;
        int state = 1;
        int value = 0;
        boolean foundDigit = false;
        char c = '-';
        while (i < versionString.length()) {
            int d;
            if ((d = Character.digit(c = (char)versionString.charAt(i++), 10)) >= 0) {
                value = value * 10 + d;
                foundDigit = true;
                continue;
            }
            if (state == 1 && c == '.' && foundDigit) {
                major = value;
                value = 0;
                foundDigit = false;
                ++state;
                continue;
            }
            if (state == 2 && c == '.' && foundDigit) {
                minor = value;
                value = 0;
                foundDigit = false;
                ++state;
                continue;
            }
            state = 4;
            break;
        }
        if (state == 1 && foundDigit) {
            major = value;
        } else if (state == 2) {
            minor = value;
        } else if (state == 3 && foundDigit) {
            micro = value;
        } else {
            throw new ParseException("Invalid usage version: " + versionString, i);
        }
        return new UsageVersion(major, minor, micro);
    }

    public static UsageVersion decode(double encodedValue) {
        long value = Math.round(encodedValue);
        if (value < 0L || value > 999999999L) {
            throw new IllegalArgumentException("Invalid encoded UsageVersion value.");
        }
        int ivalue = (int)value;
        return new UsageVersion(ivalue / 1000000, ivalue / 10000 % 100, ivalue % 10000);
    }

    public double encode() {
        return this.major * 1000000 + this.minor * 10000 + this.micro;
    }

    public boolean equals(Object usageVersion) {
        if (!(usageVersion instanceof UsageVersion)) {
            return false;
        }
        UsageVersion uv = (UsageVersion)usageVersion;
        return this.major == uv.getMajorVersion() && this.minor == uv.getMinorVersion() && this.micro == uv.getMicroVersion();
    }

    public int hashCode() {
        return this.major * 1000000 + this.minor * 10000 + this.micro;
    }

    public int compareTo(Object usageVersion) {
        UsageVersion uv = (UsageVersion)usageVersion;
        if (this.major > uv.getMajorVersion()) {
            return 1;
        }
        if (this.major < uv.getMajorVersion()) {
            return -1;
        }
        if (this.minor > uv.getMinorVersion()) {
            return 1;
        }
        if (this.minor < uv.getMinorVersion()) {
            return -1;
        }
        if (this.micro > uv.getMicroVersion()) {
            return 1;
        }
        if (this.micro < uv.getMicroVersion()) {
            return -1;
        }
        return 0;
    }

    public int compareMajorMinor(UsageVersion usageVersion) {
        if (usageVersion == null) {
            if (this.major > 0 || this.minor > 0) {
                return 1;
            }
            return 0;
        }
        if (this.major > usageVersion.getMajorVersion()) {
            return 1;
        }
        if (this.major < usageVersion.getMajorVersion()) {
            return -1;
        }
        if (this.minor > usageVersion.getMinorVersion()) {
            return 1;
        }
        if (this.minor < usageVersion.getMinorVersion()) {
            return -1;
        }
        return 0;
    }

    public boolean isReadCompatible(UsageVersion oldest, UsageVersion current) {
        return this.compareMajorMinor(oldest) >= 0 && this.major <= current.getMajorVersion();
    }

    public boolean isCompatible(UsageVersion oldest, UsageVersion current) {
        return this.compareMajorMinor(oldest) >= 0 && this.compareMajorMinor(current) <= 0;
    }
}

