/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.timezone;

import com.ibm.icu.util.TimeZone;
import com.sas.nls.timezone.TZData;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class TimeZoneProvider {
    public static Map<String, TZData> getTimeZoneList() {
        DateTimeZoneHelper helper = new DateTimeZoneHelper(Locale.getDefault(), new Date());
        return ((TimeZoneHelper)helper).getTimeZoneList();
    }

    public static Map<String, TZData> getTimeZoneList(Locale locale) {
        DateTimeZoneHelper helper = new DateTimeZoneHelper(locale, new Date());
        return ((TimeZoneHelper)helper).getTimeZoneList();
    }

    public static Map<String, TZData> getTimeZoneList(Date date) {
        DateTimeZoneHelper helper = new DateTimeZoneHelper(Locale.getDefault(), date);
        return ((TimeZoneHelper)helper).getTimeZoneList();
    }

    public static Map<String, TZData> getTimeZoneList(Locale locale, Date date) {
        DateTimeZoneHelper helper = new DateTimeZoneHelper(locale, date);
        return ((TimeZoneHelper)helper).getTimeZoneList();
    }

    public static Map<String, TZData> getRawTimeZoneList() {
        RawTimeZoneHelper helper = new RawTimeZoneHelper(Locale.getDefault());
        return ((TimeZoneHelper)helper).getTimeZoneList();
    }

    public static Map<String, TZData> getRawTimeZoneList(Locale locale) {
        RawTimeZoneHelper helper = new RawTimeZoneHelper(locale);
        return ((TimeZoneHelper)helper).getTimeZoneList();
    }

    private static class DateTimeZoneHelper
    extends TimeZoneHelper {
        private final Date date;

        DateTimeZoneHelper(Locale locale, Date date) {
            super(locale);
            this.date = date;
        }

        @Override
        protected int getOffset(TimeZone zone) {
            return zone.getOffset(this.date.getTime());
        }

        @Override
        protected boolean isDST(TimeZone zone) {
            return zone.inDaylightTime(this.date);
        }
    }

    private static class RawTimeZoneHelper
    extends TimeZoneHelper {
        RawTimeZoneHelper(Locale locale) {
            super(locale);
        }

        @Override
        protected int getOffset(TimeZone zone) {
            return zone.getRawOffset();
        }

        @Override
        protected boolean isDST(TimeZone zone) {
            return false;
        }
    }

    private static abstract class TimeZoneHelper {
        private final Locale locale;
        private final ResourceBundle bundle;
        private final MessageFormat displayFormat;

        protected TimeZoneHelper(Locale locale) {
            this.locale = locale;
            this.bundle = ResourceBundle.getBundle("com.sas.nls.timezone.timezoneList", locale);
            String fmt = this.bundle.getString("timezoneListFormat.fmt");
            this.displayFormat = new MessageFormat(fmt);
        }

        private Map<String, TZData> getTimeZoneList() {
            String timezoneList = this.bundle.getString("timezoneList.lcl");
            String[] timezoneIds = timezoneList.split(",");
            ArrayList<TZData> timezones = new ArrayList<TZData>(timezoneIds.length);
            for (String timezoneId : timezoneIds) {
                TZData data = this.getTZData(timezoneId);
                if (data == null) continue;
                timezones.add(data);
            }
            Collections.sort(timezones, new Comparator<TZData>(){

                @Override
                public int compare(TZData one, TZData two) {
                    return one.getMinuteOffset() - two.getMinuteOffset();
                }
            });
            LinkedHashMap<String, TZData> results = new LinkedHashMap<String, TZData>();
            for (TZData zone : timezones) {
                results.put(zone.getID(), zone);
            }
            return results;
        }

        protected abstract int getOffset(TimeZone var1);

        protected abstract boolean isDST(TimeZone var1);

        private TZData getTZData(String timezoneId) {
            TimeZone zone = TimeZone.getTimeZone((String)timezoneId);
            if (zone == null) {
                return null;
            }
            String displayName = zone.getDisplayName(this.isDST(zone), 7, this.locale);
            String gmtOffset = zone.getDisplayName(this.isDST(zone), 5, this.locale);
            return new TZData(timezoneId, gmtOffset, this.getMinuteOffset(this.getOffset(zone)), displayName, this.displayFormat.format(new Object[]{gmtOffset, displayName}));
        }

        private int getMinuteOffset(int offset) {
            return offset / 60000;
        }
    }
}

