/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.id;

import com.sas.nls.encoding.Encoding;
import com.sas.nls.id.IDStringException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;

public class IDString {
    public static final int MAX_LENGTH = 32;
    public static final String MESSAGE_INVALIDPROPOSEID = "IDString.InvalidProposedID.txt";
    public static final String MESSAGE_BLANKPROPOSEID = "IDString.BlankProposedID.txt";
    public static final String MESSAGE_INVALIDENCODING = "IDString.InvalidEncoding.txt";
    public static final String MESSAGE_INVALIDDICTIONARY = "IDString.InvalidDictionary.txt";
    public static final String MESSAGE_BLANKORIGINAL = "IDString.BlankOriginal.txt";
    public static final String MESSAGE_INVALIDLENGTH = "IDString.InvalidLength.txt";
    public static final String MESSAGE_FAILRESOURCEFILE = "IDString.FailResourceFile.txt";
    public static final String MESSAGE_BLANKENCODINGDEF = "IDString.BlankEncodingDef.txt";
    public static final String MESSAGE_INVALIDUNIQUESTR = "IDString.InvalidUniqueStr.txt";
    public static final String MESSAGE_EXCEEDUNIQUESTR = "IDString.ExceedUniqueStr.txt";
    public static final String MESSAGE_INVALIDENCODINGDEF = "IDString.InvalidEncodingDef.txt";
    private String errorMessage = null;

    public String createIDString(String original, String unique) {
        String string = original = original == null ? "" : original;
        if (unique == null) {
            this.errorMessage = MESSAGE_BLANKORIGINAL;
            return null;
        }
        if (unique.length() == 0) {
            this.errorMessage = MESSAGE_INVALIDLENGTH;
            return null;
        }
        PropertyResourceBundle propertyBundle = (PropertyResourceBundle)PropertyResourceBundle.getBundle("com.sas.nls.id.sas_session_encodings");
        if (propertyBundle == null) {
            this.errorMessage = MESSAGE_FAILRESOURCEFILE;
            return null;
        }
        String encodings = propertyBundle.getString("encoding");
        if (encodings == null) {
            this.errorMessage = MESSAGE_BLANKENCODINGDEF;
            return null;
        }
        String encoding = null;
        Charset charset = null;
        CharsetEncoder encoder = null;
        int uniqLength = 0;
        int origLength = 0;
        String result = original;
        ArrayList<Integer> uniqLenLst = new ArrayList<Integer>();
        StringTokenizer st = new StringTokenizer(encodings, ",");
        int index = 0;
        int size = 0;
        ArrayList<String> encodingLst = new ArrayList<String>();
        while (st.hasMoreElements()) {
            encoding = (String)st.nextElement();
            try {
                if (Charset.isSupported(encoding)) {
                    charset = Charset.forName(encoding);
                    encoder = charset.newEncoder();
                    if (!encoder.canEncode(unique)) {
                        this.errorMessage = MESSAGE_INVALIDUNIQUESTR;
                        return null;
                    }
                    uniqLength = unique.getBytes(encoding).length;
                    if (uniqLength > 32) {
                        this.errorMessage = MESSAGE_EXCEEDUNIQUESTR;
                        return null;
                    }
                    encodingLst.add(encoding);
                    uniqLenLst.add(new Integer(uniqLength));
                    continue;
                }
                this.errorMessage = MESSAGE_INVALIDENCODINGDEF;
                return null;
            }
            catch (IllegalCharsetNameException e) {
                this.errorMessage = MESSAGE_INVALIDENCODINGDEF;
                return null;
            }
            catch (UnsupportedEncodingException e) {
                this.errorMessage = MESSAGE_INVALIDENCODINGDEF;
                return null;
            }
        }
        size = encodingLst.size();
        while (index < size) {
            origLength = 32 - (Integer)uniqLenLst.get(index);
            result = this.check(result, (String)encodingLst.get(index), origLength);
            ++index;
        }
        return result + unique;
    }

    private String check(String original, String encoding, int maxLen) {
        String result = original;
        int trunLen = 1;
        try {
            while (result.getBytes(encoding).length > maxLen) {
                trunLen = IDString.isSurrogatePair(result) ? 2 : 1;
                result = result.substring(0, result.length() - trunLen);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.errorMessage = MESSAGE_INVALIDENCODINGDEF;
        }
        return result;
    }

    private static boolean isSurrogatePair(String str) {
        boolean check = false;
        int length = str.length();
        if (length > 1) {
            char ch0 = str.charAt(length - 2);
            char ch1 = str.charAt(length - 1);
            if (Character.isHighSurrogate(ch0) && Character.isLowSurrogate(ch1)) {
                check = true;
            }
        }
        return check;
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? null : new IDStringException(this.errorMessage).getLocalizedMessage();
    }

    public static String getValidIDString(String proposedID, String encoding, int length, List<String> dictionary) throws IDStringException {
        String sID = null;
        if (proposedID == null || proposedID.trim().equals("")) {
            throw new IDStringException(MESSAGE_BLANKPROPOSEID);
        }
        if (dictionary == null) {
            throw new IDStringException(MESSAGE_INVALIDDICTIONARY);
        }
        StringBuffer newEncoding = new StringBuffer();
        boolean checkEncoding = IDString.checkEncoding(encoding, newEncoding);
        if (!checkEncoding) {
            throw new IDStringException(MESSAGE_INVALIDENCODING);
        }
        Charset charset = null;
        CharsetEncoder encoder = null;
        try {
            encoding = newEncoding.toString();
            charset = Charset.forName(encoding);
            encoder = charset.newEncoder();
            if (!encoder.canEncode(proposedID)) {
                throw new IDStringException(MESSAGE_INVALIDPROPOSEID);
            }
            sID = IDString.getUniqueString(proposedID, length, encoding, dictionary);
            if (sID != null && sID.trim().equals("")) {
                sID = null;
            }
        }
        catch (IllegalCharsetNameException ex) {
            throw new IDStringException(MESSAGE_INVALIDENCODING);
        }
        return sID;
    }

    private static String getUniqueString(String idString, int lenMax, String encoding, List<String> preIDs) {
        String sID = null;
        String proposedID = idString;
        int lenID = 0;
        boolean flgUsed = true;
        boolean flgLen = false;
        if (lenMax == -1) {
            flgLen = true;
        } else {
            try {
                lenID = proposedID.getBytes(encoding).length;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            flgLen = lenID <= lenMax;
        }
        try {
            while (!flgLen) {
                proposedID = proposedID.substring(0, proposedID.length() - (IDString.isSurrogatePair(proposedID) ? 2 : 1));
                lenID = proposedID.getBytes(encoding).length;
                flgLen = lenID <= lenMax;
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (preIDs.contains(proposedID)) {
            flgUsed = true;
        } else {
            sID = proposedID;
            flgUsed = false;
        }
        while (flgUsed) {
            int iNum = 0;
            while (lenMax == -1 || String.valueOf(iNum).length() <= lenMax - lenID) {
                sID = proposedID + String.valueOf(iNum);
                if (!preIDs.contains(sID)) {
                    flgUsed = false;
                    break;
                }
                ++iNum;
            }
            if (!flgUsed) continue;
            try {
                proposedID = proposedID.substring(0, proposedID.length() - (IDString.isSurrogatePair(proposedID) ? 2 : 1));
                lenID = proposedID.getBytes(encoding).length;
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            if (lenID == 0) {
                sID = null;
                break;
            }
            if (preIDs.contains(proposedID)) {
                flgUsed = true;
                continue;
            }
            flgUsed = false;
            sID = proposedID;
        }
        return sID;
    }

    public static boolean isValidID(String idString, String encoding, int length) {
        boolean valid;
        block9: {
            valid = true;
            if (idString == null || idString.trim().equals("")) {
                return false;
            }
            StringBuffer newEncoding = new StringBuffer();
            boolean checkEncoding = IDString.checkEncoding(encoding, newEncoding);
            if (!checkEncoding) {
                return false;
            }
            Charset charset = null;
            CharsetEncoder encoder = null;
            try {
                encoding = newEncoding.toString();
                charset = Charset.forName(encoding);
                encoder = charset.newEncoder();
                if (!encoder.canEncode(idString)) {
                    valid = false;
                    break block9;
                }
                if (length == -1) {
                    valid = true;
                    break block9;
                }
                int lenID = 0;
                try {
                    lenID = idString.getBytes(encoding).length;
                    if (lenID > length) {
                        valid = false;
                    }
                }
                catch (UnsupportedEncodingException e) {}
            }
            catch (IllegalCharsetNameException ex) {
                valid = false;
            }
        }
        return valid;
    }

    public static String makeValidID(String idString, String encoding, int length, char swap) {
        String sID;
        block13: {
            sID = null;
            Charset charset = null;
            CharsetEncoder encoder = null;
            boolean replace = false;
            StringBuffer validBuff = new StringBuffer();
            if (idString == null || idString.trim().length() == 0) {
                return null;
            }
            StringBuffer newEncoding = new StringBuffer();
            boolean checkEncoding = IDString.checkEncoding(encoding, newEncoding);
            if (!checkEncoding) {
                return null;
            }
            replace = swap <= '\u00ff';
            boolean encoded = true;
            try {
                encoding = newEncoding.toString();
                charset = Charset.forName(encoding);
                encoder = charset.newEncoder();
                if (!encoder.canEncode(idString)) {
                    encoded = false;
                    int size = idString.length();
                    for (int index = 0; index < size; ++index) {
                        char c = idString.charAt(index);
                        if (encoder.canEncode(c)) {
                            validBuff.append(c);
                            continue;
                        }
                        if (!replace) continue;
                        validBuff.append(swap);
                    }
                    if (validBuff.length() == 0) {
                        return null;
                    }
                }
                if (length == -1) {
                    sID = encoded ? idString : validBuff.toString();
                    break block13;
                }
                idString = encoded ? idString : validBuff.toString();
                int trunLen = 1;
                try {
                    while (idString.getBytes(encoding).length > length) {
                        trunLen = IDString.isSurrogatePair(idString) ? 2 : 1;
                        idString = idString.substring(0, idString.length() - trunLen);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                sID = idString;
            }
            catch (IllegalCharsetNameException ex) {
                sID = null;
            }
        }
        if (sID != null && sID.trim().length() == 0) {
            sID = null;
        }
        return sID;
    }

    private static boolean checkEncoding(String encoding, StringBuffer newEncoding) {
        boolean checked = false;
        if (encoding == null) {
            newEncoding.append("UTF8");
            checked = true;
        } else {
            try {
                if (Charset.isSupported(encoding)) {
                    checked = true;
                    newEncoding.append(encoding);
                } else if (Encoding.isValidSASEncoding(encoding)) {
                    try {
                        checked = true;
                        newEncoding.append(Encoding.getJavaEncoding(encoding));
                    }
                    catch (Exception e) {
                        checked = false;
                    }
                } else {
                    checked = false;
                }
            }
            catch (IllegalCharsetNameException ex) {
                checked = false;
            }
        }
        return checked;
    }
}

