## Some notes about the compose functions

Behind the scenes, 
the [Go implementation of Docker compose](https://github.com/docker/compose-cli)
is called a.k.a. Compose v2, not the [Python implementation](https://github.com/docker/compose).

You can verify that `docker compose` is installed by running
```
docker compose --help
```
If that doesn't work, then install the cli plugin.
The instructions are here: https://github.com/docker/compose-cli#compose-v2-aka-local-docker-compose
it's just a single binary to download.

The Go implementation of compose is still experimental, so take the appropriate precautions.

If you don't need to set any project-wide options, like the project name or 
the compose file path, you can just import `docker` and start working.

```python
from python_on_whales import docker

docker.compose.build()
docker.compose.up()
...
docker.compose.down()
```

Otherwise, you have to define your project-wide options only once, when creating the Docker client.

```python
from python_on_whales import DockerClient

docker = DockerClient(compose_files=["./my-compose-file.yml"])

docker.compose.build()
docker.compose.up()
...
docker.compose.down()
```


#### About `docker.compose.images()`.

The Docker command line has a `docker compose images` command. Python-on-whales doesn't have
an equivalent because it's trivial to do so with existing functions.

```
images = [docker.image.inspect(container.image) for container in docker.container.ps()]
```

* `docker.container.ps()` returns the list of all containers in the compose stack.
* `container.image` gives you the id of the Docker image of the container as a `str`.
* `docker.image.inspect()` gives you a `python_on_whales.Image` from a `str`.


{{autogenerated}}
