function make_url() {
    var output = '', seg, len;
    for (var i=0,l=arguments.length; i<l; i++) {
        seg = arguments[i].toString();
        len = seg.length;
        if (len > 1 && seg.charAt(len-1) == '/') {
            seg = seg.substring(0, len-1);
        }
        if (seg.charAt(0) != '/') {
            output += '/' + seg;
        } else {
            output += seg;
        }
    }

    // augment static dirs with build number
    if (output!='/') {
        var segments = output.split('/');
        var firstseg = segments[1];
        if (firstseg=='static' || firstseg=='modules') {
            var postfix = output.substring(firstseg.length+2, output.length);
            output = '/'+firstseg+'/@' + window.$C['BUILD_NUMBER'];
            if (window.$C['BUILD_PUSH_NUMBER']) {
                output += '.' + window.$C['BUILD_PUSH_NUMBER'];
            }
            if (segments[2] == 'app')
            output += ':'+ getConfigValue('APP_BUILD', 0);
            output += '/' + postfix;
        }
    }

    var root = getConfigValue('MRSPARKLE_ROOT_PATH', '/');
    var djangoRoot = getConfigValue('DJANGO_ROOT_PATH', '');
    var locale = getConfigValue('LOCALE', 'en-US');

    var combinedPath = "";
    if (djangoRoot && output.substring(0, djangoRoot.length) === djangoRoot) {
        combinedPath = output.replace(
            djangoRoot,
            djangoRoot + "/" + locale.toLowerCase()
        );
    } else {
        combinedPath = "/" + locale + output;
    }

    if (root == '' || root == '/') {
        return combinedPath;
    } else {
        return root + combinedPath;
    }
}

function getConfigValue(key, defaultValue) {
    if (window.$C && window.$C.hasOwnProperty(key)) {
        return window.$C[key];
    } else {
        if (defaultValue !== undefined) {
            return defaultValue;
        }

        throw new Error(
            'getConfigValue - ' + key + ' not set, no default provided'
        );
    }
}

export const generatePublicPath = name =>
    make_url(`/static/app/${name}/js/build`) + '/';
