#!/usr/bin/python
# -*- coding: utf-8 -*-
import sqlite3

import os

from homevee import constants

def dict_factory(cursor, row):
    d = {}
    for idx, col in enumerate(cursor.description):
        d[col[0]] = row[idx]
    return d

'''Gibt eine Instanz der Datenbankverbindung zurück'''
def get_database_con():
    db_path = os.path.join(constants.DATA_DIR, "data.db")

    #init db if not yet existing
    if not os.path.isfile(db_path):
        open(db_path, "w+")
        init_db()

    #print db_path

    con = sqlite3.connect(db_path)
    con.text_factory = str
    con.row_factory = dict_factory

    return con

def get_server_data(key, db):
    with db:
        cur = db.cursor()

        cur.execute("SELECT VALUE FROM SERVER_DATA WHERE KEY = :key",
                    {'key': key})

        try:
            return cur.fetchone()['VALUE']
        except Exception, e:
            return None

def set_server_data(key, value, db):
    with db:
        cur = db.cursor()

        cur.execute("INSERT OR IGNORE INTO SERVER_DATA (VALUE, KEY) VALUES(:value, :key)",
                    {'value': value, 'key': key})

        cur.execute("UPDATE OR IGNORE SERVER_DATA SET VALUE = :value WHERE KEY = :key",
                    {'value': value, 'key': key})

def init_db():
    command = """
    CREATE TABLE "API_KEYS" ( "SERVICE_NAME" TEXT NOT NULL, "API_KEY" TEXT DEFAULT NULL, PRIMARY KEY("SERVICE_NAME") );
    CREATE TABLE "AR_CONTROL_CLASSES" ( "ID" INTEGER NOT NULL, "NAME" TEXT NOT NULL, "LOCATION" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "CONTROL_DATA" TEXT );
    CREATE TABLE "AR_CONTROL_LEARNING_DATA" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "PATH" TEXT NOT NULL, "CONTROL_KEY" INTEGER DEFAULT NULL );
    CREATE TABLE "AUTOMATION_DATA" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "ACTIVE" BOOLEAN NOT NULL DEFAULT "true", "CONDITION_DATA" TEXT NOT NULL, "ACTION_DATA" TEXT NOT NULL, "LOCATION" INTEGER NOT NULL, "TRIGGERED" INTEGER NOT NULL DEFAULT 0, "IS_ACTIVE" INTEGER NOT NULL DEFAULT 0 );
    CREATE TABLE "AUTOMATION_TRIGGER_DATA" ( "AUTOMATION_RULE_ID" INTEGER NOT NULL, "TYPE" TEXT NOT NULL, "ID" TEXT, "VALUE" TEXT );
    CREATE TABLE "CALENDAR" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "START" TEXT NOT NULL, "END" TEXT, "NOTE" TEXT, "REPEAT" TEXT );
    CREATE TABLE "CALENDAR_PARTICIPANTS" ( "USERNAME" TEXT NOT NULL UNIQUE, "CALENDAR_ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE );
    CREATE TABLE "CHAT_DATA" ( "USERNAME" TEXT NOT NULL, "DATA" TEXT NOT NULL, "TIMESTAMP" DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP UNIQUE );
    CREATE TABLE "CUSTOM_VOICE_COMMANDS" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "ACTION_DATA" TEXT NOT NULL );
    CREATE TABLE "CUSTOM_VOICE_COMMAND_RESPONSES" ( "COMMAND_ID" INTEGER NOT NULL, "RESPONSE" TEXT NOT NULL );
    CREATE TABLE "CUSTOM_VOICE_COMMAND_SENTENCES" ( "COMMAND_ID" INTEGER NOT NULL, "COMMAND" TEXT NOT NULL );
    CREATE TABLE "DEVICE_AVAILABILITY" ( "DEVICE_TYPE" TEXT NOT NULL, "DEVICE_ID" TEXT NOT NULL, "IS_ONLINE" BOOLEAN NOT NULL DEFAULT "false", PRIMARY KEY("DEVICE_TYPE","DEVICE_ID") );
    CREATE TABLE "DEVICE_ENERGY_DATA" ( "DEVICE_TYPE" TEXT NOT NULL, "DEVICE_ID" TEXT NOT NULL, "POWER_USAGE" NUMERIC NOT NULL, "DATE" DATETIME NOT NULL DEFAULT CURRENT_DATE, "LOCATION" TEXT NOT NULL );
    CREATE TABLE "DIY_DEVICES" ( "DEVICE" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT, "ROOM" INTEGER, "IP" TEXT, "ICON" TEXT, "HTTP_METHOD" TEXT NOT NULL DEFAULT "HTTP GET" );
    CREATE TABLE "DIY_MOTIONSENSORS" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "RAUM" INTEGER NOT NULL, "ICON" TEXT NOT NULL DEFAULT "motion", "NAME" TEXT NOT NULL, "IP" TEXT NOT NULL, "CHANNEL" INTEGER, "HTTP_METHOD" TEXT NOT NULL DEFAULT "get" );
    CREATE TABLE "DIY_POWER_METER" ( "ROOM_ID" INTEGER NOT NULL, "DEVICE_ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "DEVICE_NAME" TEXT, "IP" TEXT, "HTTP_METHOD" TEXT NOT NULL DEFAULT "HTTP GET" );
    CREATE TABLE "DIY_PRESENCESENSORS" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "RAUM" TEXT NOT NULL, "ICON" TEXT NOT NULL DEFAULT "presence", "NAME" TEXT NOT NULL, "IP" TEXT NOT NULL, "CHANNEL" INTEGER, "HTTP_METHOD" TEXT NOT NULL DEFAULT "get" );
    CREATE TABLE "DIY_REEDSENSORS" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "RAUM" TEXT NOT NULL, "ICON" TEXT NOT NULL DEFAULT "reed", "NAME" TEXT NOT NULL, "IP" TEXT NOT NULL, "CHANNEL" INTEGER, "HTTP_METHOD" TEXT NOT NULL DEFAULT "get" );
    CREATE TABLE "DIY_SENSORS" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "RAUM" INTEGER NOT NULL, "ICON" TEXT NOT NULL DEFAULT "device", "IP" TEXT NOT NULL, "NAME" TEXT NOT NULL, "EINHEIT" INTEGER, "SAVE_DATA" BOOLEAN NOT NULL DEFAULT "true", "CHANNEL" INTEGER, "HTTP_METHOD" TEXT NOT NULL DEFAULT "get" );
    CREATE TABLE "DIY_SWITCHES" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "ICON" TEXT NOT NULL DEFAULT "device", "RAUM" INTEGER NOT NULL, "IP" TEXT NOT NULL, "CHANNEL" INTEGER, "HTTP_METHOD" TEXT NOT NULL DEFAULT "get" );
    CREATE TABLE "ENERGY_DATA" ( "POWER_USAGE" NUMERIC, "DATE" DATETIME NOT NULL DEFAULT CURRENT_DATE, PRIMARY KEY("DATE") );
    CREATE TABLE "EVENTS" ( "TIMESTAMP" INTEGER UNIQUE, "TEXT" TEXT, "TYPE" TEXT );
    CREATE TABLE "FUNKSTECKDOSEN" ( "ROOM" INTEGER NOT NULL, "DEVICE" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "HAUSCODE" TEXT NOT NULL, "STECKDOSENNUMMER" TEXT NOT NULL, "ZUSTAND" BOOLEAN NOT NULL DEFAULT 0, "ICON" TEXT NOT NULL DEFAULT "socket", "NAME" TEXT NOT NULL, CONSTRAINT "unq" UNIQUE("HAUSCODE","STECKDOSENNUMMER") );
    CREATE TABLE "GATEWAYS" ( "NAME" TEXT NOT NULL, "IP" TEXT DEFAULT "localhost", "PORT" INTEGER NOT NULL DEFAULT 80, "KEY1" TEXT, "KEY2" TEXT, "TYPE" TEXT NOT NULL DEFAULT "user", PRIMARY KEY("NAME") );
    CREATE TABLE "GPS_DATA" ( "USERNAME" TEXT NOT NULL, "TIMESTAMP" INTEGER NOT NULL, "LATITUDE" INTEGER NOT NULL, "LONGITUDE" INTEGER NOT NULL );
    CREATE TABLE "HEATING_SCHEME" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "TIME" DATETIME NOT NULL, "VALUE" NUMERIC NOT NULL, "ACTIVE" BOOLEAN NOT NULL );
    CREATE TABLE "HEATING_SCHEME_DAYS" ( "HEATING_SCHEME_ID" INTEGER NOT NULL, "WEEKDAY_ID" INTEGER NOT NULL );
    CREATE TABLE "HEATING_SCHEME_DEVICES" ( "ID" INTEGER NOT NULL, "TYPE" TEXT NOT NULL, "DEVICE_ID" TEXT NOT NULL, "LOCATION" TEXT );
    CREATE TABLE "HOMEPILOT_BLIND_CONTROL" ( "ID" INTEGER NOT NULL UNIQUE, "NAME" TEXT, "LOCATION" TEXT, "ICON" TEXT DEFAULT "blinds", "LAST_POS" TEXT, PRIMARY KEY("ID") );
    CREATE TABLE "HOMEPILOT_THERMOSTATS" ( "ID" INTEGER NOT NULL UNIQUE, "NAME" TEXT NOT NULL, "ICON" TEXT NOT NULL DEFAULT "heating", "LAST_TEMP" TEXT NOT NULL DEFAULT "N/A", "ROOM" TEXT NOT NULL, PRIMARY KEY("ID") );
    CREATE TABLE "HOME_BUDGET_DATA" ( "DATE" TEXT NOT NULL, "AMOUNT" NUMERIC NOT NULL, "INFO" TEXT NOT NULL, "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE );
    CREATE TABLE "HTTP_DEVICE" ( "DEVICE" INTEGER NOT NULL, "NAME" TEXT NOT NULL, "LOCATION" TEXT NOT NULL, "ICON" TEXT NOT NULL DEFAULT "device", "IP" TEXT NOT NULL, "HTTP_METHOD" TEXT DEFAULT "HTTP GET", "USERNAME" TEXT, "PASSWORD" TEXT, "DEVICE_DATA" TEXT NOT NULL, PRIMARY KEY("DEVICE") );
    CREATE TABLE "IP_CAMERA" ( "TYPE" TEXT NOT NULL, "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "IP" TEXT NOT NULL, "PORT" TEXT, "PATH" TEXT, "USERNAME" TEXT, "PASSWORD" TEXT, "NAME" TEXT NOT NULL, "LOCATION" TEXT NOT NULL, "ICON" TEXT NOT NULL DEFAULT "camera", "RECORD_FOOTAGE" BOOLEAN NOT NULL DEFAULT "true", "AUTO_DELETE" BOOLEAN NOT NULL DEFAULT "false", "MOTION_DETECTION_TRESHOLD" NUMERIC, "CROP_WIDTH" INTEGER DEFAULT NULL, "CROP_HEIGHT" INTEGER DEFAULT NULL, "CROP_X_OFFSET" INTEGER DEFAULT NULL, "CROP_Y_OFFSET" INTEGER DEFAULT NULL );
    CREATE TABLE "IP_CAMERA_RECORDINGS" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "DATETIME" DATETIME NOT NULL, "VIDEOPATH" TEXT NOT NULL, "THUMBNAILPATH" TEXT NOT NULL, "FOOTAGE_ID" INTEGER NOT NULL, "DURATION" INTEGER, "MOTION_DETECTED" TEXT DEFAULT NULL );
    CREATE TABLE "MAX_THERMOSTATS" ( "RAUM" TEXT NOT NULL, "NAME" TEXT NOT NULL, "ID" TEXT NOT NULL UNIQUE, "ICON" TEXT NOT NULL DEFAULT "heating", "LAST_TEMP" TEXT NOT NULL DEFAULT "N/A", PRIMARY KEY("ID") );
    CREATE TABLE "MEDIA_CENTER" ( "TYPE" TEXT NOT NULL, "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "IP" TEXT NOT NULL, "NAME" TEXT NOT NULL, "LOCATION" INTEGER NOT NULL, "USERNAME" TEXT, "PASSWORD" TEXT, "PORT" TEXT );
    CREATE TABLE "MQTT_DEVICES" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "LOCATION" TEXT NOT NULL, "KEY" TEXT NOT NULL, "TOPIC" TEXT NOT NULL );
    CREATE TABLE "MQTT_DEVICE_INTERMEDIATES" ( "ID" INTEGER NOT NULL, "TYPE" TEXT NOT NULL );
    CREATE TABLE "MQTT_SENSORS" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "LAST_VALUE" TEXT NOT NULL, "ICON" TEXT NOT NULL DEFAULT "device", "TYPE" TEXT NOT NULL, "ROOM" INTEGER NOT NULL, "SAVE_DATA" INTEGER NOT NULL DEFAULT 0, "DEVICE_ID" INTEGER NOT NULL, "VALUE_ID" INTEGER NOT NULL );
    CREATE TABLE "MQTT_TRIGGERS" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "TOPIC" TEXT NOT NULL, "TYPE" TEXT NOT NULL, "ICON" INTEGER NOT NULL DEFAULT "device", "LOCATION" INTEGER NOT NULL );
    CREATE TABLE "NUTRITION_DATA" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "USER" TEXT NOT NULL, "DATE" TEXT NOT NULL, "DAYTIME" TEXT NOT NULL DEFAULT "snacks", "FOOD_NAME" TEXT NOT NULL, "PORTIONSIZE" NUMERIC NOT NULL, "EATEN_PORTION_SIZE" NUMERIC NOT NULL, "PORTIONUNIT" TEXT NOT NULL, "CALORIES" INTEGER NOT NULL, "PROTEIN" NUMERIC NOT NULL, "CARBS" NUMERIC NOT NULL, "SUGAR" NUMERIC, "FAT" NUMERIC NOT NULL, "SATURATED" NUMERIC, "UNSATURATED" NUMERIC );
    CREATE TABLE "PEOPLE_DATA" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "NICKNAME" TEXT, "PHONE_NUMBER" TEXT, "ADDRESS" TEXT, "BIRTHDATE" TEXT, "LATITUDE" NUMERIC, "LONGITUDE" NUMERIC );
    CREATE TABLE "PEOPLE_LEARNING_DATA" ( "ID" INTEGER NOT NULL, "PATH" TEXT NOT NULL, "PERSON_ID" INTEGER, PRIMARY KEY("ID") );
    CREATE TABLE "PHILIPS_HUE_LIGHTS" ( "NAME" TEXT NOT NULL, "ID" INTEGER NOT NULL UNIQUE, "LOCATION" INTEGER NOT NULL, "IS_ON" INTEGER, "BRIGHTNESS" INTEGER, "SATURATION" INTEGER, "HUE" INTEGER, "ICON" TEXT DEFAULT "light", "TYPE" TEXT NOT NULL DEFAULT "color", PRIMARY KEY("ID") );
    CREATE TABLE "PLACES" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "ADDRESS" TEXT NOT NULL, "LATITUDE" NUMERIC NOT NULL, "LONGITUDE" NUMERIC NOT NULL );
    CREATE TABLE "PUSH_NOTIFICATION_TOKENS" ( "USERNAME" TEXT NOT NULL, "TOKEN" TEXT NOT NULL UNIQUE );
    CREATE TABLE "REQUEST_DATA" ( "REQUEST_ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "REQUEST_TIME" DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP, "RESPONSE" TEXT NOT NULL );
    CREATE TABLE "REQUEST_DATA_PARAMS" ( "REQUEST_ID" INTEGER NOT NULL, "PARAM_KEY" TEXT NOT NULL, "PARAM_VALUE" TEXT );
    CREATE TABLE "RFID_TAGS" ( "NAME" TEXT NOT NULL, "UUID" TEXT NOT NULL UNIQUE, "ACTION_TYPE" TEXT NOT NULL, "ACTION_ID" TEXT NOT NULL, PRIMARY KEY("UUID") );
    CREATE TABLE "ROOMS" ( "NAME" TEXT NOT NULL, "LOCATION" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "ICON" TEXT NOT NULL DEFAULT room );
    CREATE TABLE "ROOM_ENERGY_DATA" ( "ROOM_ID" INTEGER NOT NULL, "POWER_USAGE" NUMERIC, "DATE" DATETIME NOT NULL DEFAULT CURRENT_DATE );
    CREATE TABLE "SCENES" ( "NAME" TEXT NOT NULL, "ROOM" TEXT NOT NULL, "ACTION_DATA" TEXT NOT NULL, "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE );
    CREATE TABLE "SENSOR_DATA" ( "VALUE" NUMERIC, "DEVICE_ID" TEXT, "DATETIME" DATETIME, "DEVICE_TYPE" TEXT NOT NULL DEFAULT "error" );
    CREATE TABLE "SERVER_DATA" ( "KEY" TEXT NOT NULL, "VALUE" TEXT NOT NULL, PRIMARY KEY("KEY") );
    CREATE TABLE "SESSION_KEYS" ( "USERNAME" TEXT NOT NULL, "SESSION_KEY" TEXT NOT NULL, "KEY_CREATED" DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP, PRIMARY KEY("USERNAME") );
    CREATE TABLE "SHOPPING_LIST" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "AMOUNT" NUMERIC, "ITEM" TEXT NOT NULL );
    CREATE TABLE "SMART_SPEAKER" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "KEY" TEXT NOT NULL, "LOCATION" INTEGER NOT NULL, "NAME" TEXT NOT NULL DEFAULT "Smart Speaker" );
    CREATE TABLE "TV_CHANNELS" ( "USERNAME" TEXT NOT NULL, "CHANNEL" TEXT NOT NULL );
    CREATE TABLE "URL_RGB_LIGHT" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "URL" TEXT NOT NULL, "ICON" TEXT NOT NULL DEFAULT "light", "LAST_COLOR" TEXT, "LOCATION" INTEGER NOT NULL );
    CREATE TABLE "URL_SWITCH_BINARY" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "URL_ON" TEXT NOT NULL, "URL_OFF" TEXT NOT NULL, "URL_GET_STATE" TEXT NOT NULL, "ICON" TEXT DEFAULT "device", "LOCATION" INTEGER NOT NULL );
    CREATE TABLE "URL_TOGGLE" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "TOGGLE_URL" TEXT NOT NULL, "ICON" TEXT DEFAULT "device", "LOCATION" INTEGER NOT NULL );
    CREATE TABLE "USERDATA" ( "USERNAME" TEXT NOT NULL UNIQUE, "PASSWORD" TEXT NOT NULL, "IP" TEXT, "AT_HOME" INTEGER, "EVENTS_LAST_CHECKED" INTEGER, "PERMISSIONS" TEXT, "DASHBOARD_DATA" TEXT, "PW_SALT" TEXT NOT NULL, "FCM_TOKEN" TEXT UNIQUE, "CURRENT_LOCATION" INTEGER NOT NULL DEFAULT -1, PRIMARY KEY("USERNAME") );
    CREATE TABLE "USER_FITNESS_DATA" ( "USERNAME" TEXT NOT NULL, "CALORIE_GOAL" INTEGER NOT NULL, "FAT_GOAL" NUMERIC, "SATURATED_GOAL" NUMERIC, "PROTEIN_GOAL" NUMERIC, "CARBS_GOAL" NUMERIC, "SUGAR_GOAL" NUMERIC, "WATER_GOAL" NUMERIC DEFAULT 2000, "BIRTHDATE" TEXT, "HEIGHT" INTEGER, "DIET_MODE" TEXT, "ACTIVITY_MODE" TEXT );
    CREATE TABLE "USER_WEIGHT_DATA" ( "USERNAME" TEXT NOT NULL, "DATE" TEXT NOT NULL, "WEIGHT" NUMERIC NOT NULL );
    CREATE TABLE "VOICE_COMMAND_REPLACE" ( "TEXT" TEXT NOT NULL UNIQUE, "REPLACE_WITH" TEXT NOT NULL, "USERNAME" TEXT NOT NULL );
    CREATE TABLE "VOICE_COMMAND_USER" ( "USERNAME" TEXT NOT NULL, "CONTEXT_TIME" INTEGER, "CONTEXT_KEY" TEXT, "CONTEXT_DATA" TEXT, PRIMARY KEY("USERNAME") );
    CREATE TABLE "WAKE_ON_LAN" ( "DEVICE" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "LOCATION" TEXT NOT NULL, "ICON" TEXT NOT NULL DEFAULT "device", "MAC_ADDRESS" TEXT NOT NULL );
    CREATE TABLE "XBOX_ONE_WOL" ( "ID" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE, "NAME" TEXT NOT NULL, "LOCATION" TEXT NOT NULL, "IP_ADDRESS" TEXT NOT NULL, "XBOX_LIVE_ID" TEXT NOT NULL, "ICON" TEXT NOT NULL DEFAULT "device" );
    CREATE TABLE "ZWAVE_DIMMER" ( "NAME" TEXT, "LOCATION" TEXT, "ID" TEXT NOT NULL UNIQUE, "ICON" TEXT NOT NULL DEFAULT "device", "VALUE" TEXT NOT NULL DEFAULT "N/A", PRIMARY KEY("ID") );
    CREATE TABLE "ZWAVE_POWER_METER" ( "ROOM_ID" TEXT, "DEVICE_ID" TEXT NOT NULL UNIQUE, "DEVICE_NAME" TEXT, "ICON" TEXT NOT NULL DEFAULT "device", "VALUE" TEXT NOT NULL DEFAULT "N/A", "IS_RESET_DAILY" INTEGER NOT NULL DEFAULT 0, "PREV_VALUE" INTEGER DEFAULT 0, PRIMARY KEY("DEVICE_ID") );
    CREATE TABLE "ZWAVE_SENSOREN" ( "RAUM" TEXT, "ID" TEXT NOT NULL UNIQUE, "SHORTFORM" TEXT, "ICON" TEXT NOT NULL DEFAULT "device", "SAVE_DATA" BOOLEAN NOT NULL DEFAULT "true", "SENSOR_TYPE" TEXT, "VALUE" TEXT DEFAULT "N/A", PRIMARY KEY("ID") );
    CREATE TABLE "ZWAVE_SWITCHES" ( "NAME" TEXT, "LOCATION" TEXT, "ID" TEXT NOT NULL UNIQUE, "ICON" TEXT NOT NULL DEFAULT "device", "VALUE" TEXT DEFAULT "N/A", PRIMARY KEY("ID") );
    CREATE TABLE "ZWAVE_THERMOSTATS" ( "RAUM" TEXT NOT NULL, "NAME" TEXT NOT NULL, "THERMOSTAT_ID" TEXT NOT NULL UNIQUE, "TEMPERATUR_ID" TEXT, "ICON" TEXT NOT NULL DEFAULT "heating", "VALUE" TEXT DEFAULT "N/A", PRIMARY KEY("THERMOSTAT_ID") );    
    """

    db = get_database_con()
    with db:
        cur = db.cursor()
        cur.executescript(command)