This package serve for two backtesting scenarios: portfolio construction or trading system.

# Installation:
* Dependency: pandas, numpy, matplotlib
* Install from pypi:(CMD) pip install backtest_pkg  
* Checking:(Python) import backtest_pkg 

# Portfolio Construction Backtest:
   1. A portfolio object is constructed by either weight or share. Input format should be a pandas dataframe with rebalance dates as index and security tickers as columns. The end date of the backtest should also be specified. Otherwise the last day available in price data is used.
   2. The benchmark of the portfolio is encouraged to specify. Two ways are supported to specify benchmark. Input benchmark weight in benchmark variable when the portfolio is initialized. Or construct a portfolio object as benchmark and set it to the benchmark attribute of the testing portfolio.
   3. Before backtest, use 'set_price(price_data)' method to specify price data. Backtest result can be generated by 'backtest()' method.
   4. To check the result, use 'plot_performance()', 'performance_summary', 'period_performance'.

Definitions and assumptions:
* Annualized is assumed to have 250 trading days.
* Active return is the difference of total return from portfolio to benchmark for the whole period. 
* Active risk is the standard deviation of daily active return multiply square root of trading days in the period. 
* Information Ratio is active return divided by active risk.

See [here](https://github.com/andyhu4023/backtest_pkg/blob/master/pkg_test/demo_backtest_pkg.py) for a small example.

# Trading System Backtest:
(Under development)



